
/* log_write() åν */

/* $Id: log_write.c,v 1.1.1.1 2003/05/13 08:17:15 tosihisa Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>

#include <syslog.h>

#include "tnetio.h"

struct _log_write_param_vars P_log_write = {
	0,
	"tnetio",
	LOG_PID,
	LOG_DAEMON,
	LOG_INFO,
	1,
	1,
};

int log_write(const char *fmt,...)
{
	time_t tim;
	char logbuf[1024];
	int  logbuf_remain = 0;
	struct tm *pst_localtime;
	static const char *time_fmt = "%x %X : ";
	va_list args;	/* Ĺ */

	va_start(args,fmt);	/* Ĺѳ */


	if(P_log_write.syslog_write)
	{
		/* syslog ͳ */
		openlog(P_log_write.syslog_ident,P_log_write.syslog_option,P_log_write.syslog_facility);

		vsyslog(P_log_write.syslog_priority,fmt,args);

		closelog();
	}
	else
	{
		/* ɸ */

		/* ֥ǡ */

		logbuf_remain = sizeof(logbuf) - 1;

		if(P_log_write.stdout_date)
		{
			tim = time(NULL);
			pst_localtime = localtime(&tim);
			strftime(logbuf,logbuf_remain ,time_fmt,pst_localtime);

			logbuf_remain = sizeof(logbuf) - strlen(logbuf) - 1;
		}

		/* ץ̾pid  */
		if(logbuf_remain > 0)
		{
			snprintf(logbuf + strlen(logbuf),logbuf_remain,"%s[%d]:",P_log_write.syslog_ident,getpid());
		}

		logbuf_remain = sizeof(logbuf) - strlen(logbuf) - 1;

		/* 񤭹ߥǡκ */
		if(logbuf_remain > 0)
		{
			vsnprintf(logbuf + strlen(logbuf),logbuf_remain,fmt,args);
			write(P_log_write.stdout_fd,logbuf,strlen(logbuf));
		}
	}

	return 0;
}

