
/* $Id: sockaddr_in_byname.c,v 1.1.1.1 2003/05/13 08:17:15 tosihisa Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <netdb.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "tnetio.h"

int tnetio_gethostbyname(int hostnamelookup,char *name,struct sockaddr_in *addr)
{
	struct _local_vars {
		int i_retval;
		struct hostent *pst_hostent;
	} INIT_LOCAL(l);

	l.i_retval = 0;

	if(name != NULL)
	{
		if(hostnamelookup)
		{
			/* ̾ǽĤ */
			if( (l.pst_hostent = gethostbyname(name)) != NULL )
			{
				/* ۥ̾μޤ */
				addr->sin_family = l.pst_hostent->h_addrtype;	/* AF_INET ΤϤ */
				addr->sin_addr   = *((struct in_addr *)(l.pst_hostent->h_addr));
				l.i_retval = 1;
			}
		}
		else
		{
			/* ̾ǽʤ */
			if(inet_aton(name,&(addr->sin_addr)) != 0)
			{
				addr->sin_family = AF_INET;
				l.i_retval = 1;
			}
		}
	}

	return l.i_retval;
}

int tnetio_sockaddr_in_byname(int hostnamelookup,char *name,char *port,char *proto,struct sockaddr_in *addr)
{
	struct _local_vars {
		int i_retval;
		struct servent *pst_servent;
	} INIT_LOCAL(l);

	memset(addr,0x00,sizeof(struct sockaddr_in));

	l.i_retval = -1;
	if(tnetio_gethostbyname(hostnamelookup,name,addr) != 0)
	{
		l.i_retval = -2;
		if((port != NULL) && (proto != NULL))
		{
			if( (isdigit(*(port + 0))) || ((l.pst_servent = getservbyname(port,proto)) != NULL) )
			{
				/* ݡȾμޤ */
				addr->sin_port = (isdigit(*(port + 0))) ? htons(atoi(port)) : l.pst_servent->s_port;
				l.i_retval = 0;
			}
		}
	}

	return l.i_retval;
}

