
/* tnetsrv - TCP/IP Хץ */

/* tnetsrv [options] port-num program [program-arg(s)] */

/* $Id: tnetsrv.c,v 1.4 2003/05/14 08:14:25 tosihisa Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/time.h>

#include <signal.h>

#include <sys/wait.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include <time.h>

#include <errno.h>

#include "tnetio.h"

static const char *log_msg[] = {
	/*      ɤʡ  ܤ */
	" accept  : %s (%s) : (%d/%d)\n",
	" refused : %s (%s) : (%d/%d)\n",
	" closed  : %d (0x%08X) : (%d/%d)\n",
	" wait    : : (%d/%d)\n",
	" bind    : %s %d %s : %s\n",
	" signal  : %d : (%d/%d)\n",
	" WARNING : IP_OPTION : [%s]\n",
	" ERROR   : exec(%s) : [%s]\n",
	" ERROR   : fork() : [%s]\n",
	" ERROR   : dynamic-link (%s) : [%s]\n",
	NULL
};

#define	LOG_MSG_ACCEPT	0
#define	LOG_MSG_REFUSED	1
#define	LOG_MSG_CLOSED	2
#define	LOG_MSG_WAIT	3
#define	LOG_MSG_BIND	4
#define	LOG_MSG_SIGNAL	5
#define	LOG_MSG_W_IPOPT	6
#define	LOG_MSG_E_EXEC	7
#define	LOG_MSG_E_FORK	8
#define	LOG_MSG_E_DLOAD	9

struct _client_info {	/* 饤(ҥץ) */
	struct sockaddr_in addr;
	int len;
	char *hostname;
};

struct _server_info {
	struct sockaddr_in addr;
	/* struct servent ent; */
};

struct _total_info {
	int connect;			/* ³߷(reject ޤ)     */
	int max_connect;		/* ³߷(reject ޤ) */
	int overflow;			/* ³¤ۤäˣ */
};

struct _global_vars {	/* Хѿ */
	int progrun;				/* 0:ϽλʤФʤʤ0:Ϸ³ */
	int now_connect;			/* ߤƱ³ϿƤ */
	struct _total_info total;		/* ߷׾ */
	struct _server_info server;		/* о */
	struct _client_info client;		/* ľ³饤Ⱦ */
	int (*tnetio_run)(int,int,int,char **);	/* ͥΩ³ĤƤνؿ */
	void *dl_handler;			/* ͭ饤֥ɤ߹ߥϥɥ */
	int pipe_file_fd;			/* pipe_file Фե뵭һ */
} G;

struct _param_vars {			/* Хѿ(ѥ᡼)¤ */
	int max_connect;
	char *bind_addr;
	int hostnamelookup;
	char *port;
	char *proto;
	char *env_prefix;
	int tcp_nodelay;
	int keepalive;
	int chg_uid;
	int chg_gid;
	int dl_flag;
	char *reject_file;
	char *status_file;
	int wrap_flag;
	char *wrap_name;
} P;

const struct _param_vars P_init = {	/* Хѿ(ѥ᡼) */
	25,		/* max_connect */
	"0.0.0.0",	/* bind_addr */
	0,		/* hostnamelookup */
	NULL,		/* port */
	"tcp",		/* proto */
	"NETSRV_",	/* env_prefix */
	0,		/* tcp_nodelay */
	0,		/* keepalive */
	-1,		/* chg_uid */
	-1,		/* chg_gid */
	0,		/* dl_flag */
	NULL,		/* reject_file */
	NULL,		/* status_file */
	0,		/* wrap_flag */
	"netsrv"	/* wrap_name */
};

extern struct _log_write_param_vars P_log_write;

void signal_handler(int signum)
{
	log_write(log_msg[LOG_MSG_SIGNAL],signum,G.now_connect,P.max_connect);
	G.progrun = 0;
}

void signal_alarm(int signum)
{
	/* ä˲⤷ޤ */
}

void signal_child(int signum)
{
	pid_t child_pid = 0;
	int status = 0;

	while((child_pid = waitpid(-1,&status,WNOHANG)) > 0)
	{
		G.now_connect--;

		log_write(log_msg[LOG_MSG_CLOSED],child_pid,status,G.now_connect,P.max_connect);
	}
}

void signal_wait(void)
{
	sigset_t sig_set;


	/* ʥ뽸ˤ롣פˡä˥ޥΤ̵ȸǤ */
	sigemptyset(&sig_set);

	/* ʥ뤬ǤޤԤޤ
	   ޥƤޤ󤫤顢餫Υʥ뤬
	   Ǥ饵ڥɤϲޤ           */
	sigsuspend(&sig_set);
}

int signal_block(int signum)
{
	sigset_t sig_set;


	/* ʥ뽸ˤ롣פˡä˥ޥΤ̵ȸǤ */
	sigemptyset(&sig_set);

	/* ꤵ줿ʥä(ޥ) */
	sigaddset(&sig_set,signum);

	/* ꤵ줿ʥԤäƤ餦(֥å) */
	return sigprocmask(SIG_BLOCK,&sig_set,NULL);
}

int signal_unblock(int signum)
{
	sigset_t sig_set;


	/* ʥ뽸ˤ롣פˡä˥ޥΤ̵ȸǤ */
	sigemptyset(&sig_set);

	/* ꤵ줿ʥä(ޥ) */
	sigaddset(&sig_set,signum);

	/* ꤵ줿ʥȯޤ(֥åޤ) */
	return sigprocmask(SIG_UNBLOCK,&sig_set,NULL);
}

void set_signals(void)
{
	signal(SIGINT,signal_handler);
	signal(SIGTERM,signal_handler);
	signal(SIGALRM,signal_alarm);
	signal(SIGCHLD,signal_child);
}

/* set_signals() ǥåȤʥϡƤδؿǸ᤹ */
void default_signals(void)
{
	signal(SIGINT,SIG_DFL);
	signal(SIGTERM,SIG_DFL);
	signal(SIGALRM,SIG_DFL);
	signal(SIGCHLD,SIG_DFL);
}

int wait_new_connect(int fd,struct sockaddr *addr, socklen_t *addrlen)
{
	struct _local_vars {
		fd_set rfds;
		struct timeval tv;
		int newfd;
	} INIT_LOCAL(l);


	l.newfd = -1;

	while(G.progrun)
	{
		if( G.now_connect >= P.max_connect )
		{
			/* ³ޤãƤʤԤޤ */
			/* ͽۤ륷ʥϡ
			   (1) SIGTERM (G.progrun = 0)
			   (2) SIGINT  (G.progrun = 0)
			   (3) SIGCHLD (G.now_connect--)
			   (4) SIGALARM (1÷в)
			   ΥʥǤ                       */
			G.total.overflow = 1;	/* Сեȯ */
			alarm(1);	/* ॢ */
			signal_wait();	/* ʥԤ */
		}
		else
		{
			/* ³ãƤʤʤ顢ϤԤޤ */
			FD_ZERO(&(l.rfds));
			FD_SET(fd, &(l.rfds));
			l.tv.tv_sec = 1;	/* ॢ */
			l.tv.tv_usec = 0;

			if(select(fd + 1, &(l.rfds), NULL, NULL, &(l.tv) ) > 0)
			{
				if(FD_ISSET(fd, &(l.rfds)))
				{
					if((l.newfd = r_eval("accept",accept(fd,addr,addrlen))) >= 0)
						break;	/* ǽλ */
					else
						G.progrun = 0;	/* ̿Ū꤬롣ץλ */
				}
			}
		}
	}

	return l.newfd;
}

int logging_connect(int acs)
{
	char *fmt = NULL;


	fmt = (char *)log_msg[LOG_MSG_REFUSED];
	if(acs)
		fmt = (char *)log_msg[LOG_MSG_ACCEPT];

	log_write(fmt,inet_ntoa(G.client.addr.sin_addr),G.client.hostname,G.now_connect,P.max_connect);

	return acs;
}

int setup_client_info(int fd,struct _client_info *pst_client)
{
	struct hostent *client_ent = NULL;


	memset(pst_client,0x00,sizeof(struct _client_info));
	pst_client->len = sizeof(pst_client->addr);

	pst_client->hostname = "";

	if(r_eval("getpeername",getpeername(fd,(struct sockaddr *)&(pst_client->addr),&(pst_client->len))) >= 0)
	{
		if(P.hostnamelookup)
		{
			pst_client->hostname = "UNKNOWN";
			client_ent = gethostbyaddr(&(pst_client->addr.sin_addr),4,AF_INET);
			if(client_ent != NULL)
			{
				pst_client->hostname = client_ent->h_name;
			}
		}
	}

	return 0;
}

int drop_ip_options(int fd)
{
	struct _local_vars {
		unsigned char optbuf[1024];
		unsigned char *optptr;
		int optsize;
		char logbuf[1024];
		int logbuf_remain;
	} INIT_LOCAL(l);


	/* ⤷꤬ IP_OPTIONS ꤷƤʤ顢λݥ˵Ͽ */

	l.optsize = sizeof(l.optbuf);
	if(getsockopt(fd,IPPROTO_IP,IP_OPTIONS,(char *)l.optbuf,&l.optsize) == 0)
	{
		if(l.optsize > 0)
		{
			/* ϡIP_OPTIONS ͭˤƤ롣λΥǡ˻Ĥ*/

			l.logbuf[0] = (char)('\0');
			l.logbuf_remain = sizeof(l.logbuf) - strlen(l.logbuf) - 1;

			l.optptr = l.optbuf;
			for(;l.optsize > 1;l.optsize--,l.optptr++)
			{
				snprintf(l.logbuf + strlen(l.logbuf),l.logbuf_remain,"%02X:",*l.optptr);
				l.logbuf_remain = sizeof(l.logbuf) - strlen(l.logbuf) - 1;
				if(l.logbuf_remain <= 20)
					break;	/* ǰΤ */
			}
			snprintf(l.logbuf + strlen(l.logbuf),l.logbuf_remain,"%02X",*l.optptr);	/* Ǹ */

			log_write(log_msg[LOG_MSG_W_IPOPT],l.logbuf);	/* ؽ񤭽Ф */
		}
	}

	/* IP_OPTIONS ̵ѤȤIP 롼ƥ󥰤̵ˤʤ(Ϥ) */
	return setsockopt(fd,IPPROTO_IP,IP_OPTIONS,NULL,0);
}

void tnetlib_set_tcp_nodelay(int fd)
{
	int optval = 1;


	if(P.tcp_nodelay)
	{
		setsockopt(fd,IPPROTO_TCP,1 /* TCP_NODELAY */,&optval,sizeof(optval));
	}
}

void tnetlib_set_keepalive(int fd)
{
	int optval = 1;


	if(P.keepalive)
	{
		setsockopt(fd,SOL_SOCKET,SO_KEEPALIVE,&optval,sizeof(optval));
	}
}

void tnetlib_set_linger(int fd,int t_tim)
{
	struct linger st_linger;


	/* ̤ѥåȤ֤ǡҥץƥλ
	   (close())ϡꤵ줿Ԥä close() 褦˻Ÿ롣  */
	st_linger.l_onoff = 1;
	st_linger.l_linger = t_tim;	/* Linux  man setsockopt ˤȡ 1/100  ñ̤餷 */
	setsockopt(fd,SOL_SOCKET,SO_LINGER,&(st_linger),sizeof(st_linger));
}

void tnetlib_set_reuse(int fd)
{
	int optval = 1;

	setsockopt(fd,SOL_SOCKET,SO_REUSEADDR,&optval,sizeof(optval));
}

void tnetlib_set_uidgid(int i_uid,int i_gid)
{
	if(i_uid >= 0)
		setuid(i_uid);

	if(i_gid >= 0)
		setgid(i_gid);
}

int set_my_env(void)
{
	char env_name[1024];
	char env_val[1024];

	snprintf(env_name,sizeof(env_name)-1,"%sPROTO",P.env_prefix);
	snprintf(env_val ,sizeof(env_val)-1 ,"%s",P.proto);
	setenv(env_name,env_val,1);

	snprintf(env_name,sizeof(env_name)-1,"%sLOCALIP",P.env_prefix);
	snprintf(env_val ,sizeof(env_val)-1 ,"%s",inet_ntoa(G.server.addr.sin_addr));
	setenv(env_name,env_val,1);

	snprintf(env_name,sizeof(env_name)-1,"%sLOCALPORT",P.env_prefix);
	snprintf(env_val ,sizeof(env_val)-1 ,"%d",ntohs(G.server.addr.sin_port));
	setenv(env_name,env_val,1);

	snprintf(env_name,sizeof(env_name)-1,"%sREMOTEIP",P.env_prefix);
	snprintf(env_val ,sizeof(env_val)-1 ,"%s",inet_ntoa(G.client.addr.sin_addr));
	setenv(env_name,env_val,1);

	snprintf(env_name,sizeof(env_name)-1,"%sREMOTEPORT",P.env_prefix);
	snprintf(env_val ,sizeof(env_val)-1 ,"%d",ntohs(G.client.addr.sin_port));
	setenv(env_name,env_val,1);

	if(G.client.hostname != NULL)
	{
		snprintf(env_name,sizeof(env_name)-1,"%sREMOTEHOST",P.env_prefix);
		snprintf(env_val ,sizeof(env_val)-1 ,"%s",G.client.hostname);
		setenv(env_name,env_val,1);
	}

	return 0;
}

int calc_argv(char **run_child_name)
{
	int i;

	for(i = 0;*(run_child_name + i) != NULL;i++);

	return i;
}

void fork_child(int *srvfd,int *newfd,char **run_child_name)
{
	int i_retval = EXIT_REFUSED;


	close_if_open(srvfd);	/* ΥåȤĤޤ */

	default_signals();	/* ʥϰöᤷޤ */

	/* IP_OPTIONS ϡ̵Ȥ롣
	   ꤬ IP 롼ƥ󥰺ΤԤäƤǽ뤫*/
	drop_ip_options(*newfd);

	/* 饤Ⱦμ(ȴĶѿ) */
	setup_client_info(*newfd,&(G.client));

	/* tnetio_test_client_connect() ƤӽФꤵ줿 IP ³ľ֤Ĵ٤ */

	/* ꤵ줿 IP ɥ쥹³϶ؤƤ(Ȳꤹ) */
	i_retval = EXIT_REFUSED;

	if(logging_connect(tnetio_test_client_connect(P.reject_file,P.wrap_flag,P.wrap_name,*newfd)))
	{
		/* ꤵ줿 IP ɥ쥹³ϵĤƤޤ */
		/* åȤγƼ */
		tnetlib_set_tcp_nodelay(*newfd);
		tnetlib_set_keepalive(*newfd);
		tnetlib_set_linger(*newfd,60*100);

		/* ³δĶѿ */
		set_my_env();

		/* ؿƤӽФޤ */
		i_retval = (*G.tnetio_run)(*newfd,*newfd,calc_argv(run_child_name),run_child_name);
	}

	close_if_open(newfd);	/* åȤƤʤĤޤ */

	exit(i_retval);	/* ǽޤ*/
}

int parse_args(int argc,char *argv[])
{
	struct _local_vars {
		int c;
		FILE *fp;
	} INIT_LOCAL(l);

	do {

		l.c = getopt(argc,argv,"b:D:E:lM:NSUW:X:u:g:ka:svP:");

		if(l.c != EOF)
		{
			switch(l.c)
			{
				case 'b':	/* bind  IP ɥ쥹ꤹ */
					P.bind_addr = optarg;
					break;
				case 'D':	/* ɸϤ˥񤭽Фˡդղäʤ*/
					P_log_write.stdout_date = 0;
					break;
				case 'E':	/* ץ¹ԻꤹĶѿƬ optarg ˤ */
					P.env_prefix = optarg;
					break;
				case 'l':	/* ³줿 IP ɥ쥹顢ۥ̾θԤ */
					P.hostnamelookup = 1;
					break;
				case 'M':	/* Ʊ³ */
					P.max_connect = atoi(optarg);
					if(P.max_connect <= 0)
						P.max_connect = 1;
					break;
				case 'N':	/* TCP_NODELAY ͭˤ */
					P.tcp_nodelay = 1;
					break;
				case 'S':	/* ǡ syslog ˽񤭹 */
					P_log_write.syslog_write = 1;
					break;
				case 'U':	/* UDP Ԥ(̤б) */
					P.proto = "udp";
					break;
				case 'W':	/* tcpwrapper(libwrap) εǽѤ롣ǡץ̾ optarg ˤ */
					P.wrap_flag = 1;
					P.wrap_name = optarg;
					break;
				case 'X':	/* ͥΩoptarg Ǽե뤬ɤ߽Фǽ¸ߤƤϤǤ */
					P.reject_file = optarg;
					break;
				case 'u':	/* ꤷ桼IDڤؤư */
					P.chg_uid = atoi(optarg);
					break;
				case 'g':	/* ꤷ롼IDڤؤư */
					P.chg_gid = atoi(optarg);
					break;
				case 'k':	/* KEEPALIVE ͭˤ */
					P.keepalive = 1;
					break;
				case 'a':	/* ϤɸϤǤϤʤoptarg եɲä */
					l.fp = fopen(optarg,"ab");
					if(l.fp == NULL)
					{
						perror(optarg);
						exit(EXIT_EPERM);
					}
					dup2(fileno(l.fp),1);	/* ɸϤϡƤΥե˸ */
					fclose(l.fp);
					break;
				case 's':	/* Ϳץ̾ϡץ̾ǤϤʤͭ饤֥ */
					if(!tnetio_dluse())
					{
						/* ͭ饤֥굡ǽϻѤǤޤ */
						fprintf(stderr,"Not supported : Dynamic-load library function.\n");
						exit(EXIT_EPERM);
					}
					P.dl_flag = 1;
					break;
				case 'v':	/* Сϸ塢exit(0) */
					printf("%s : Version %x.%02x (BUILD DATE:%s %s)\n",
						argv[0],
						(unsigned)(TNETIO_VERSION >> 8),
						(unsigned)(TNETIO_VERSION & 0x00ff),
						__DATE__,
						__TIME__);
					exit(0);
					break;
				case 'P':	/* ơեˡ߾񤭹褦ˤ */
					P.status_file = optarg;
					break;
				default:
					exit(EXIT_EPERM);
					break;
			}
		}

	} while (l.c != EOF);

	return optind;
}

void *tnetio_dynamic_load(char *libname)
{
	void *ptr_retval;


	/* ɸǼ¹Ԥؿؿ */
	ptr_retval = tnetio_run_default;

	if(P.dl_flag)
	{
		ptr_retval = NULL;
		if( (G.dl_handler = tnetio_dlopen(libname)) != NULL)
		{
			ptr_retval = tnetio_dlsym(G.dl_handler,"tnetio_run");
		}
	}

	if(ptr_retval == NULL)
	{
		log_write(log_msg[LOG_MSG_E_DLOAD],libname,tnetio_dlerror());
	}

	return ptr_retval;
}

void tnetio_dynamic_unload(void)
{
	if(G.dl_handler != NULL)
		tnetio_dlclose(G.dl_handler);
}

pid_t count_new_connect(pid_t c_pid)
{
	switch(c_pid)
	{
		case 0:		/* ҥץξ */
			/* ҥץ¦ϡҥץƤʤΤǡ
			   G.now_connect ͤϡ˽롣                */
			G.now_connect++;	/* ҥץܣ */
			break;
		case -1:	/* ʬȤνѤ˼ԤߤǤ㥯餬­ʤäʡ */
			log_write(log_msg[LOG_MSG_E_FORK],strerror(errno));
			break;
		default:	/* ƥץξ */
			/* 衢ҥץοѲ(G.now_connect ͤѤ)
			   ΤǡSIGCHLD ʥ뤬ȯȡG.now_connect ζ礬롣 
			   򿩤ߤ뤿ˡSIGCHLD ʥȯϡԤäƤ餦 */
			if(signal_block(SIGCHLD) == 0)
			{
				/*  ϡSIGCLHD γߤʤϤ  */

				G.now_connect++;	/* ҥץܣ */

				/* SIGCHLD ʥĤޤ */
				signal_unblock(SIGCHLD);
				/*  ϡSIGCHLD γߤݥݥǤϤ  */
			}

			/* ³߷פη׻ */
			G.total.connect++;		/* ³߷סܣ */
			if(G.now_connect > G.total.max_connect)
				G.total.max_connect = G.now_connect;	/* Ʊ³߷סܣ */

			break;
	}

	return c_pid;
}

int main(int argc,char *argv[])
{
	struct _local_vars {
		int start_arg;
		char **run_child_name;
		int sockfd;
		int newsockfd;
		int i_retval;
	} INIT_LOCAL(l);

	/* Хѿν */
	memset(&G,0x00,sizeof(G));
	G.progrun  = 1;

	/* Хѿ(ѥ᡼)ν */
	memcpy(&P,&P_init,sizeof(P));

	/* طν */
	P_log_write.syslog_write = 0;	/* ɸϤ˽Ф */
	P_log_write.syslog_ident = argv[0];
	if(rindex(argv[0],'/') != NULL)
		P_log_write.syslog_ident = rindex(argv[0],'/') + 1;

	/* ץβ */
	l.start_arg = parse_args(argc,argv);

	if(l.start_arg < argc)
	{
		P.port = argv[l.start_arg];
		l.start_arg++;
	}

	/* λǡbind  IPݡֹ桢ץȥ뤬Ƥ
	   Τǡbind 뤿ξ󤬹ۤǤ뤫Ĵ٤롣                */
	switch(tnetio_sockaddr_in_byname(P.hostnamelookup,P.bind_addr,P.port,P.proto,&(G.server.addr)))
	{
		case 0:		/*  */
			break;
		case -1:	/* bind ۥ̾ */
			fprintf(stderr,"%s : Invalid bind-addr %s\n",
				P_log_write.syslog_ident,
				(P.bind_addr != NULL) ? P.bind_addr : "(none)"
				);
			return EXIT_EPERM;
			break;
		case -2:	/* bind ݡֹ椬 */
			fprintf(stderr,"%s : Invalid bind-port %s\n",
				P_log_write.syslog_ident,
				(P.port != NULL) ? P.port : "(none)"
				);
			return EXIT_EPERM;
			break;
		default:	/* ???? */
			return EXIT_EPERM;
			break;
	}

	/* ¹Ԥҥץξ */

	if(l.start_arg < argc)
	{
		l.run_child_name = &(argv[l.start_arg]);
		l.start_arg++;
	}

	if( (l.run_child_name == NULL ) || (strlen(*(l.run_child_name + 0)) <= 0) )
	{
		fprintf(stderr,"%s : no child-program\n",P_log_write.syslog_ident);
		return EXIT_EPERM;
	}

	set_signals();

	l.i_retval = EXIT_BINDERR;

	/* åȤ򳫤 */
	if((l.sockfd = r_eval("socket",socket(G.server.addr.sin_family,SOCK_STREAM,0))) >= 0)
	{
		tnetlib_set_reuse(l.sockfd);	/* 륢ɥ쥹κѤǽˤƤޤ */

		/* åȤ bind  */
		if(r_eval("bind",bind(l.sockfd,(struct sockaddr *)&(G.server.addr),sizeof(G.server.addr))) >= 0)
		{
			/* bind 褿顢桼 ID ȡ롼 ID ڤؤ롣ʹߤưϡʲθ¤ǹԤ */
			tnetlib_set_uidgid(P.chg_uid,P.chg_gid);

			/* ꤵ줿ץ̾¤϶ͭ饤֥Ǥ硢ɤԤ */
			if( (G.tnetio_run = tnetio_dynamic_load(*(l.run_child_name + 0))) != NULL )
			{
				/* åȥ塼 */
				if(r_eval("listen",listen(l.sockfd,5)) >= 0)
				{
					/* λ */

					log_write(log_msg[LOG_MSG_BIND],
						inet_ntoa(G.server.addr.sin_addr),
						ntohs(G.server.addr.sin_port),
						P.proto,
						*(l.run_child_name + 0));

					log_write(log_msg[LOG_MSG_WAIT],G.now_connect,P.max_connect);

					l.i_retval = EXIT_NORMAL;

					/* ᥤ롼 */
					while((l.newsockfd = wait_new_connect(l.sockfd,NULL,NULL)) >= 0)
					{
						/* 줫Ĥʤޤ*/

						/* ץʣ(fork())³򥫥Ȥ */
						if(count_new_connect(fork()) == 0)
						{
							/* ҥץξ硢ҥץν */
							fork_child(&(l.sockfd),&(l.newsockfd),l.run_child_name);
						}

						close_if_open(&(l.newsockfd));
					}
				}
			}

			tnetio_dynamic_unload();
		}

		close_if_open(&(l.sockfd));

	}

	return l.i_retval;
}

