/*
 *  Copyright (C) 2006 Juernjakob Harder
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */ 

#ifndef __TOMOE_READING_SEARCH_H__
#define __TOMOE_READING_SEARCH_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtktable.h>
#include <tomoe.h>

G_BEGIN_DECLS

#define TOMOE_TYPE_READING_SEARCH            (tomoe_reading_search_get_type ())
#define TOMOE_READING_SEARCH(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOMOE_TYPE_READING_SEARCH, TomoeReadingSearch))
#define TOMOE_READING_SEARCH_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), TOMOE_TYPE_READING_SEARCH, TomoeReadingSearchClass))
#define TOMOE_IS_READING_SEARCH(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOMOE_TYPE_READING_SEARCH))
#define TOMOE_IS_READING_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOMOE_TYPE_READING_SEARCH))
#define TOMOE_READING_SEARCH_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), TOMOE_TYPE_READING_SEARCH, TomoeReadingSearchClass))


typedef struct _TomoeReadingSearchClass TomoeReadingSearchClass;
typedef struct _TomoeReadingSearch      TomoeReadingSearch;

struct _TomoeReadingSearch
{
    GtkTable parent_instance;
};

struct _TomoeReadingSearchClass
{
    GtkTableClass parent_class;
};


GType       tomoe_reading_search_get_type    (void) G_GNUC_CONST;
GtkWidget  *tomoe_reading_search_new         (void);
void        tomoe_reading_search_set_context (TomoeReadingSearch *page,
                                              TomoeContext       *context);

G_END_DECLS

#endif /* __TOMOE_READING_SEARCH_H__ */
 
