/*
 * include.h
 *
 * Common functions for testing TOMOYO Linux's kernel.
 *
 * Copyright (C) 2005-2006  NTT DATA CORPORATION
 *
 * Version: 1.1   2006/04/01
 *
 */
#include <errno.h>
#include <fcntl.h>
#include <linux/kdev_t.h>
struct module;
#include <linux/reboot.h>
#include <linux/unistd.h>
#include <netinet/in.h>
#include <pty.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/mount.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/syscall.h>
#include <sys/sysctl.h>
#include <sys/time.h>
#include <sys/timex.h>
#include <sys/types.h>
#include <sys/un.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>
#include <utime.h>

static _syscall0(pid_t, gettid);
pid_t gettid();
static _syscall1(int, uselib, const char *, library);
int uselib(const char *library);
static _syscall2(caddr_t, create_module, const char *, name, size_t, size);
caddr_t create_module(const char *name, size_t size);
static _syscall2(int, pivot_root, const char *, new_root, const char *, put_old);
int pivot_root(const char *new_root, const char *put_old);
static _syscall2(int, tkill, int, tid, int, sig);
int tkill(int tid, int sig);
#ifdef __NR_tgkill
static _syscall3(int, tgkill, int, tgid, int, tid, int, sig);
int tgkill(int tgid, int tid, int sig);
#endif
#ifdef __NR_compat_sys_ioctl
static _syscall3(long, compat_sys_ioctl, unsigned int, fd, unsigned int, cmd, unsigned long, arg);
long compat_sys_ioctl(unsigned int fd, unsigned int cmd, unsigned long arg);
#endif

int reboot(int magic, int magic2, int flag, void *arg);
int init_module(const char *name, struct module *image);
int delete_module(const char *name);

static int status_fd = EOF;
static int is_kernel26 = 0;
static pid_t pid = 0;

static void ClearStatus(void) {
	FILE *fp = fopen("/proc/ccs/status", "r");
	static char buffer[4096];
	if (!fp) {
		fprintf(stderr, "Can't open /proc/ccs/status\n");
		exit(1);
	}
	while (memset(buffer, 0, sizeof(buffer)), fgets(buffer, sizeof(buffer) - 10, fp)) {
		char *cp = strchr(buffer, '=');
		if (!cp) continue; *cp = '\0';
		if (strcmp(buffer, "TOMOYO_VERBOSE") == 0) continue;
		write(status_fd, buffer, strlen(buffer));
		write(status_fd, "=0\n", 3);
	}
	fclose(fp);
}

static void Init(void) {
	pid = getpid();
	if (access("/proc/ccs/", F_OK)) {
		fprintf(stderr, "You can't use this program for this kernel.\n");
		exit(1);
	}
	if ((status_fd = open("/proc/ccs/status", O_WRONLY)) == EOF) {
		fprintf(stderr, "Can't open /proc/ccs/status .\n");
		exit(1);
	}
	if (write(status_fd, "", 0) != 0) {
		fprintf(stderr, "Register this program to /root/security/manager.txt and reboot.\n");
		exit(1);
	}
	ClearStatus();
	{
		FILE *fp = fopen("/proc/sys/kernel/osrelease", "r");
		int version = 0;
		if (!fp || fscanf(fp, "2.%d.", &version) != 1) {
			fprintf(stderr, "Can't read /proc/sys/kernel/osrelease\n");
			exit(1);
		}
		fclose(fp);
		if (version == 6) is_kernel26 = 1;
	}
}
