/*
 * loadpolicy.c
 *
 * Load the policy on the disk into the kernel.
 *
 * Copyright (C) 2005-2006  NTT DATA CORPORATION
 *
 * Version: 1.1.1   2006/05/15
 *
 * This program loads policies from /root/security/ directory.
 * You can call this program to reload policies after editing policy files.
 *
 */

#include "policy.h"

int main(int argc, char *argv[]) {
	int load_system_policy = 0;
	int load_exception_policy = 0;
	int load_domain_policy = 0;
	int refresh_policy = 0;
	if (access("/proc/ccs/policy/", F_OK)) {
		fprintf(stderr, "You can't run this program for this kernel.\n");
		return 0;
	}
	if (argc == 1) {
		goto usage;
	} else {
		int i;
		for (i = 1; i < argc; i++) {
			char *p = argv[i];
			char *s = strchr(p, 's');
			char *e = strchr(p, 'e');
			char *d = strchr(p, 'd');
			char *a = strchr(p, 'a');
			char *f = strchr(p, 'f');
			if (s || a) load_system_policy = 1;
			if (e || a) load_exception_policy = 1;
			if (d || a) load_domain_policy = 1;
			if (f) refresh_policy = 1;
			if (strcspn(p, "sedaf")) {
			usage: ;
				printf("%s [s][e][d][a][f]\n"
					   "s : Load system_policy.\n"
					   "e : Load exception_policy.\n"
					   "d : Load domain_policy.\n"
					   "a : Load all policies.\n"
					   "f : Delete on-memory policy before loading on-disk policy.\n\n", argv[0]);
				printf("Note that 'accept mode' might be unable to append permissions for this program if 'f' is used "
					   "because 'f' might delete 'domain for this program' and 'execute permission for parent domain'.\n");
				return 0;
			}
		}
	}
	if (chdir("/root/security/")) {
		printf("Directory /root/security/ doesn't exist.\n");
		return 1;
	}

	if (load_system_policy) {
		FILE *file_fp, *proc_fp;
		if ((file_fp = fopen("system_policy.txt", "r")) == NULL) {
			fprintf(stderr, "Can't open system_policy.txt\n");
			goto out_system;
		}
		if ((proc_fp = fopen("/proc/ccs/policy/system_policy", "w")) == NULL) {
			fprintf(stderr, "Can't open /proc/ccs/policy/system_policy\n");
			fclose(file_fp);
			goto out_system;
		}
		if (refresh_policy) {
			FILE *proc_clear_fp = fopen("/proc/ccs/policy/system_policy", "r");
			if (!proc_clear_fp) {
				fprintf(stderr, "Can't open /proc/ccs/policy/system_policy\n");
				fclose(file_fp);
				fclose(proc_fp);
				goto out_system;
			}
			while (memset(buffer, 0, sizeof(buffer)), fgets(buffer, sizeof(buffer) - 1, proc_clear_fp) != NULL) {
				char *cp = strchr(buffer, '\n');
				if (cp) *cp = '\0';
				else if (!feof(proc_clear_fp)) break;
				NormalizeLine(buffer);
				if (buffer[0]) fprintf(proc_fp, "delete %s\n", buffer);
			}
			fclose(proc_clear_fp);
			fflush(proc_fp);
		}
		while (memset(buffer, 0, sizeof(buffer)), fgets(buffer, sizeof(buffer) - 1, file_fp) != NULL) {
			char *cp = strchr(buffer, '\n');
			if (cp) *cp = '\0';
			else if (!feof(file_fp)) break;
			NormalizeLine(buffer);
			if (buffer[0]) fprintf(proc_fp, "%s\n", buffer);
		}
		fclose(proc_fp);
		fclose(file_fp);
	}
 out_system: ;
	
	if (load_exception_policy) {
		FILE *file_fp, *proc_fp;
		if ((file_fp = fopen("exception_policy.txt", "r")) == NULL) {
			fprintf(stderr, "Can't open exception_policy.txt\n");
			goto out_exception;
		}
		if ((proc_fp = fopen("/proc/ccs/policy/exception_policy", "w")) == NULL) {
			fprintf(stderr, "Can't open /proc/ccs/policy/exception_policy\n");
			fclose(file_fp);
			goto out_exception;
		}
		if (refresh_policy) {
			FILE *proc_clear_fp = fopen("/proc/ccs/policy/exception_policy", "r");
			if (!proc_clear_fp) {
				fprintf(stderr, "Can't open /proc/ccs/policy/exception_policy\n");
				fclose(file_fp);
				fclose(proc_fp);
				goto out_exception;
			}
			while (memset(buffer, 0, sizeof(buffer)), fgets(buffer, sizeof(buffer) - 1, proc_clear_fp) != NULL) {
				char *cp = strchr(buffer, '\n');
				if (cp) *cp = '\0';
				else if (!feof(proc_clear_fp)) break;
				NormalizeLine(buffer);
				if (buffer[0]) fprintf(proc_fp, "delete %s\n", buffer);
			}
			fclose(proc_clear_fp);
			fflush(proc_fp);
		}
		while (memset(buffer, 0, sizeof(buffer)), fgets(buffer, sizeof(buffer) - 1, file_fp) != NULL) {
			char *cp = strchr(buffer, '\n');
			if (cp) *cp = '\0';
			else if (!feof(file_fp)) break;
			NormalizeLine(buffer);
			if (buffer[0]) fprintf(proc_fp, "%s\n", buffer);
		}
		fclose(proc_fp);
		fclose(file_fp);
	}
 out_exception: ;

	if (load_domain_policy) {
		int new_index;
		unsigned char *flag_list = NULL;
		const int delete_domain_fd = open("/proc/ccs/policy/delete_domain", O_WRONLY);
		const int update_domain_fd = open("/proc/ccs/policy/update_domain", O_WRONLY);
		FILE *proc_fp = fopen("/proc/ccs/policy/domain_policy", "w");
		if (delete_domain_fd == EOF || update_domain_fd == EOF || !proc_fp) {
			fprintf(stderr, "Can't open /proc/ccs/policy/\n");
			close(delete_domain_fd); close(update_domain_fd);
			if (proc_fp) fclose(proc_fp);
			goto out_domain;
		}
		ReadDomainPolicy("domain_policy.txt", 0);
		ReadDomainPolicy("/proc/ccs/policy/domain_policy", 1);
		if (domain_list_count[0] == 0) {
			fprintf(stderr, "Can't open domain_policy.txt\n");
			close(delete_domain_fd); close(update_domain_fd); fclose(proc_fp);
			goto out_domain;
		}
		flag_list = (char *) malloc(domain_list_count[1]);
		memset(flag_list, 0, domain_list_count[1]);
		for (new_index = 0; new_index < domain_list_count[0]; new_index++) {
			const char *domainname = domain_list[0][new_index].domainname;
			const char **new_string_ptr = domain_list[0][new_index].string_ptr;
			const int new_string_count = domain_list[0][new_index].string_count;
			const int old_index = FindDomain(domainname, 1);
			int i;
			if (refresh_policy) {
				if (old_index >= 0) {
					/*
					 * Old policy for this domain found.
					 * We need to compare the old policy and new policy to determine
					 * whether it is possible to continue using memory used by old policy.
					 * If new policy includes all of old policy, we can continue
					 * using memory used by old policy by just appending new policy.
					 */
					const char **old_string_ptr = domain_list[1][old_index].string_ptr;
					const int old_string_count = domain_list[1][old_index].string_count;
					if (new_string_count < old_string_count) {
					delete_old_domain: ;
						/* Need to delete old policy. */
						const int len = strlen(domainname);
						write(delete_domain_fd, domainname, len);
						write(delete_domain_fd, "\n", 1);
						/* Need to notify later. */
						flag_list[old_index] = 1;
					} else { /* new_string_count >= old_string_count */
						int j;
						for (j = 0; j < old_string_count; j++) {
							int k;
							if (new_string_ptr[j] == old_string_ptr[j]) continue;
							for (k = 0; k < new_string_count; k++) {
								if (new_string_ptr[k] == old_string_ptr[j]) break;
							}
							if (k < new_string_count) continue;
							goto delete_old_domain;
						}
						/* Needn't to delete old policy. */
						flag_list[old_index] = -1;
					}
				} else {
					/*
					 * Old policy for this domain not found.
					 * We need to delete old policy leter,
					 * indicated by "flag_list[old_index] == 0".
					 */
				}
			}
			/* Append new policy. */
			fprintf(proc_fp, "%s\n\n", domainname);
			for (i = 0; i < new_string_count; i++) {
				fprintf(proc_fp, "%s\n", new_string_ptr[i]);
			}
			fprintf(proc_fp, "\n");
			fflush(proc_fp);
			if (refresh_policy) {
				/* Notify policy update. */
				if (old_index >= 0 && flag_list[old_index] == 1) {
					const int len = strlen(domainname);
					write(update_domain_fd, domainname, len);
					write(update_domain_fd, "\n", 1);
				}
			}
		}
		fclose(proc_fp);
		if (refresh_policy) {
			int old_index;
			/* Delete all domains that are not defined in new policy. */
			for (old_index = 0; old_index < domain_list_count[1]; old_index++) {
				if (flag_list[old_index] == 0) {
					const char *domainname = domain_list[1][old_index].domainname;
					const int len = strlen(domainname);
					write(delete_domain_fd, domainname, len);
					write(delete_domain_fd, "\n", 1);
				}
			}
		}
		free(flag_list);
		close(delete_domain_fd);
		close(update_domain_fd);
	}
 out_domain: ;

	return 0;
}
