/*
 * tomoyo_name_test.c
 *
 * Testing program for various pathname patterns.
 *
 * Copyright (C) 2005-2006  NTT DATA CORPORATION
 *
 * Version: 1.1   2006/04/01
 *
 */
#include "include.h"

int main(int argc, char *argv[]) {
	int i;
	FILE *fp;
	const char *pathname;
	Init();
	system("dmesg -c > /dev/null");
	pathname = "/proc/ccs/policy/domain_policy";
	if ((fp = fopen(pathname, "w")) == NULL) {
		fprintf(stderr, "Can't open %s\n", pathname);
	} else {
		for (i = 0; i < 256; i++) fprintf(fp, "<kernel> /domain\\%03oname\n", i); // i == 0 or 041 <= i <= 0176 are NG
		fprintf(fp, "<kernel> /domain\\12c\n");
		fprintf(fp, "<kernel> /domain\\1cd\n");
		fprintf(fp, "<kernel> /domain\\cde\n");
		fprintf(fp, "<kernel><kernel>\n");
		fprintf(fp, "<kernel>  <kernel>\n");
		fprintf(fp, "<kernel> /<kernel>\n"); // OK
		fprintf(fp, "<kernel> / <kernel>\n");
		fprintf(fp, "<kernel> / /sbin/init\n"); // OK
		fprintf(fp, "<kernel> /bin/\\*\n");
		fprintf(fp, "<kernel> /bin/\\?\n");
		fprintf(fp, "<kernel> /bin/\\\\\n"); // OK
		fclose(fp);
	}
	system("dmesg -c");
	pathname = "/proc/ccs/policy/domain_policy";
	if ((fp = fopen(pathname, "w")) == NULL) {
		fprintf(stderr, "Can't open %s\n", pathname);
	} else {
		fprintf(fp, "<kernel> /\\377\n");
		for (i = 0; i < 256; i++) fprintf(fp, "4 /file\\%03o\n", i); // i == 0 or 041 <= i <= 0176 are NG
		for (i = -10; i < 10; i++) fprintf(fp, "%d /filetest\n", i); // 0 <= i <= 7 are OK
		fprintf(fp, "<kernel> / init\n");
		for (i = 0; i < 256; i++) fprintf(fp, "4 /file\\%03o\n", i); // Within a invalid domain. They are ignored.
		fprintf(fp, "<kernel> /zzz\\377zzz\n");
		for (i = 0; i < 8; i++) fprintf(fp, "%d /file\\$%d\n", i, i); // Dropping execute permission.
		for (i = 0; i < 8; i++) fprintf(fp, "%d /file%d\\*\n", i, i); // Dropping execute permission.
		fclose(fp);
	}
	system("dmesg -c");
	pathname = "/proc/ccs/policy/exception_policy";
	if ((fp = fopen(pathname, "w")) == NULL) {
		fprintf(stderr, "Can't open %s\n", pathname);
	} else {
		for (i = 0; i < 256; i++) fprintf(fp, "file_pattern /file\\%03o\n", i); // These are not patterns.
		fprintf(fp, "file_pattern /file\\$\n"); // OK
		fclose(fp);
	}
	system("dmesg -c");
	pathname = "/proc/ccs/policy/exception_policy";
	if ((fp = fopen(pathname, "w")) == NULL) {
		fprintf(stderr, "Can't open %s\n", pathname);
	} else {
		for (i = 0; i < 256; i++) fprintf(fp, "initializer /file\\%03o\n", i); // i == 0 or 041 <= i <= 0176 are NG
		fprintf(fp, "initializer /file\\$\n");
		fclose(fp);
	}
	system("dmesg -c");
	pathname = "/proc/ccs/policy/exception_policy";
	if ((fp = fopen(pathname, "w")) == NULL) {
		fprintf(stderr, "Can't open %s\n", pathname);
	} else {
		for (i = 0; i < 256; i++) fprintf(fp, "allow_read /file\\%03o\n", i); // i == 0 or 041 <= i <= 0176 are NG
		fprintf(fp, "allow_read /file\\$\n");
		fclose(fp);
	}
	system("dmesg -c");
	pathname = "/proc/ccs/policy/exception_policy";
	if ((fp = fopen(pathname, "w")) == NULL) {
		fprintf(stderr, "Can't open %s\n", pathname);
	} else {
		for (i = 0; i < 256; i++) fprintf(fp, "trust_domain <kernel> /domain\\%03oname\n", i); // i == 0 or 041 <= i <= 0176 are NG
		fprintf(fp, "trust_domain <kernel> /domain\\12c\n");
		fprintf(fp, "trust_domain <kernel> /domain\\1cd\n");
		fprintf(fp, "trust_domain <kernel> /domain\\cde\n");
		fprintf(fp, "trust_domain <kernel><kernel>\n");
		fprintf(fp, "trust_domain <kernel>  <kernel>\n");
		fprintf(fp, "trust_domain <kernel> /<kernel>\n"); // OK
		fprintf(fp, "trust_domain <kernel> / <kernel>\n");
		fprintf(fp, "trust_domain <kernel> / /sbin/init\n"); // OK
		fprintf(fp, "trust_domain <kernel> /bin/\\*\n");
		fprintf(fp, "trust_domain <kernel> /bin/\\?\n");
		fprintf(fp, "trust_domain <kernel> /bin/\\\\\n"); // OK
		fclose(fp);
	}
	system("dmesg -c");
	return 0;
}
