/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: testsuite.h,v 1.4 2003/12/20 06:51:58 takayuki Exp $
 */

/*
 *   ƥȥȼ¹ 饹/ޥ饤֥
 */

// $Header: /home/CVS/configurator/base/testsuite.h,v 1.4 2003/12/20 06:51:58 takayuki Exp $


#ifdef TESTSUITE

    //ʥꥪüޥ(Exception饹̵ͭˤäȤؤΤǤˤ)
#  undef END_CASE
#  ifdef EXCEPT_H
#    define END_CASE }catch(TestSuite::Fail & x) { _suite_control.fail_in_suite(x.getMessage()); } catch(Exception & exc) { _suite_control.fail_in_suite(string("㳰 : ") + exc.getDetails()); } catch(...) { _suite_control.fail_in_suite("ƥȼ¹㳰äǤ줿"); } _suite_control.leave_case(); }
#  else
#    define END_CASE }catch(TestSuite::Fail & x) { _suite_control.fail_in_suite(x.getMessage()); } catch(...) { _suite_control.fail_in_suite("ƥȼ¹㳰äǤ줿"); } _suite_control.leave_case(); }
#  endif

#endif


#ifndef TESTSUITE_H
#define TESTSUITE_H

    //ƥȥȤ򤫤뤫ɤ
//#define TESTSUITE


#if defined(TESTSUITE) //&& defined(_DEBUG)

    //ȥ꡼ƤƥȤǻȤΤؤ
#include <iostream>
#define cin  _cin
#define cout _cout
#define cerr _cerr

#include <sstream>

namespace std {
    extern stringstream _cin;
    extern stringstream _cout;
    extern stringstream _cerr;
}

#include <string>
#include <list>
#include <set>
#include <map>


    //ɸΥƥȥȴؿΥץȥѥޥ
#define TESTSUITE_PROTOTYPE(suite) \
    public: \
        static void test_suite_##suite(TestSuiteControl & _suite_control);


    //ɸΥƥȥȴؿѥޥ (虜ȥȼ¹Ԥξ拾ѥѤ̾Ʊ̾ˤ)
#undef TESTSUITE
#define TESTSUITE(suite,cls) \
    TestSuite TestSuite_##cls##_##suite(#cls "(" #suite ")", cls::test_suite_##suite); \
    void cls::test_suite_##suite(TestSuiteControl & _suite_control)

#define TESTSUITE_(suite,cls,spr) \
    TestSuite TestSuite_##spr##_##cls##_##suite(#spr "::" #cls "(" #suite ")", spr::cls::test_suite_##suite); \
    void spr::cls::test_suite_##suite(TestSuiteControl & _suite_control)

    //¿ż¹ɻѥޥ
#define PROCEED_ONCE static bool _proceed_once_flag_ = false; if(_proceed_once_flag_) return; else _proceed_once_flag_ = true;

    //ʥꥪϥޥ
#define BEGIN_CASE(x,y) if(_suite_control.enter_case(x,y,__FILE__,__LINE__)) { try {

    //ʥꥪԥޥ
#define TEST_FAIL     throw TestSuite::Fail();
#define TEST_FAIL_(x) throw TestSuite::Fail(x);

    //ûʥꥪѥޥ
#define TEST_CASE(x,y,z)   BEGIN_CASE(x,y) { if(!(z)) TEST_FAIL;    } END_CASE
#define TEST_CASE_(x,y,z,u) BEGIN_CASE(x,y) { if(!(z)) TEST_FAIL_(u); } END_CASE

    //ãȽޥ
#define CHECKPOINT(x) TestSuite::check(x);

    //󥰥ȥ
#define SINGLETON(x)    Singleton<x>::Context context;     Singleton<x>::saveContext(context);
#define SINGLETON_(x,y) Singleton<x>::Context context_##y; Singleton<x>::saveContext(context_##y);

/*
 *  ƥȥȤμ¹楯饹
 */
class TestSuiteControl {
protected:
    std::list<std::string> session;         //ߤΥå̾å

    std::string    target_session;          //оݥå̾
    std::string    current_session;         //ߤΥȥʥꥪ̾
    std::string    current_description;     //ߤΥȥʥꥪ
    std::ostream * out;                     //ν
    bool           fail;                    //Ԥʥꥪäɤ
    bool           verbose;                 //ĹϤ뤫ݤ

    unsigned int   case_count;              //
    unsigned int   fail_count;              //Ԥο

        //ʥꥪ̾μ
    std::string get_suitename(const char * name = "") const;


public:
        //󥹥ȥ饯
    TestSuiteControl(std::ostream & _out, const char * _pattern = "");

        //ƥȥʥꥪɽ (ֵ : ¹Ԥɬפ뤫ɤ)
    bool        _enter_case(const char * session, const char * description, const char * filename = "", long lineno = -1);
    inline void leave_case(void) { leave_session(); }

        //󥰥륹ƥå׼¹ԻӹޤʤΥå
    inline bool enter_case(const char * session, const char * description, const char * filename = "", long lineno = -1)
    {   return _enter_case(session, description, filename, lineno);   }

        //ƥȥå̾ (ʥꥪץե) /
    void enter_session(const std::string & session);
    void leave_session(void);

        //ƥȥʥꥪμ
    void fail_in_suite(std::string msg="");                                           

        //Ԥʥꥪ̵ͭγǧ
    inline bool is_failed(void) const
    {   return fail;   }

        //ĹϤ
    inline void set_verbose(bool _verbose = true)
    {   verbose = _verbose;   }

        //¹Ԥƥȥο
    inline unsigned int countCases(void) const
    {   return case_count;   }

        //Ԥƥȥο
    inline unsigned int countFails(void) const
    {   return fail_count;   }
};

    //󥰥ȥΥƥȥȤΤˤǥ󥯥롼
#include "base/singleton.h"

/*
 *  ƥȥȼ¹ԥ饹
 */
class TestSuite {
public:
    class Fail  //ƥȥΤѤ㳰ѥ饹
    {
    protected:
        std::string msg;

    public:
            //󥹥ȥ饯
        Fail(std::string src = "") throw() : msg(src) {}

            //ԡ󥹥ȥ饯
        Fail(const Fail & src) throw() : msg(src.msg) {}
        
            //å
        inline const std::string & getMessage(void) const throw()
        {   return msg;   }
    };

    typedef void (*SuiteFunction)(TestSuiteControl &);

        /* 饹ΥƥȥȤ˴ؤݻ륯饹 */
    class SuiteContainerNode
    {
    protected:
        std::string   session;
        SuiteFunction suite;
    
    public:
            //Ⱦ󥳥󥹥ȥ饯
        SuiteContainerNode(const char * session, SuiteFunction suite);
        SuiteContainerNode(const SuiteContainerNode & src);

            //Ȥμ¹
        bool invoke(TestSuiteControl & suite_control);

            //̾μ
        inline const std::string & getName(void) const throw()
        {   return session;   }
    };

        //¹Ԥ٤ƥȥȤĥ󥹥󥹤ΥꥹȤη
    class SuiteContainer : public std::list<SuiteContainerNode>
    {   public: SINGLETON_CONSTRUCTOR(SuiteContainer) {}   };

        /* ¹ԥץ */
    enum tagPerformOption {
        THROUGH = 1,    //٤̤Ǽ¹Ԥ (ߤʤ)
        VERBOSE = 2,    //Ĺ

        DEFAULT = THROUGH
    };

        /* åݥȤǼ륯饹 */
    class Checkpoint : public std::set<std::string>
    { public: SINGLETON_CONSTRUCTOR(Checkpoint) throw() {} };

protected:
    bool            fail;       //Ǹ˼¹ԤȤԤɤݻѿ
    static bool     starvated;  //new˼Ԥ뤫ɤ

public:
        //󥹥ȥ饯
    TestSuite(const char * session, SuiteFunction suite);

        //ǥȥ饯
    ~TestSuite(void);

        //ƥȥȤμ¹  (ֵ:Ȥ¹Ԥ줿ɤ)
    static bool performTestSuite(int flags = THROUGH, const char * pattern = "");

        //ƥȥȤμ¹ (Ѵ)
    inline static bool performTestSuite(const char * pattern)
    {   return performTestSuite(THROUGH, pattern);   }

        //ϿƤȥåץ٥륹Ȥΰɽ
    static void listTestSuite(void);

        /*
         *   åݥѴؿ
         */

        //̲ᤷȤ
    inline static void check(std::string checkname)
    {   Singleton<Checkpoint>::getInstance()->insert(checkname);   }

        //ޤǤ˼
    inline static void clearCheckpoints(void)
    {   Singleton<Checkpoint>::getInstance()->clear();   }

        //ΰ֤褿
    static bool isReached(std::string checkname);

        /*
         *   ƥѺȴؿ
         */

        //եȤ򳫤ƥå
    static bool compareFileContents(const char * filename, const char * filecontents, bool remove = true);
};

/*
 *  ȼ¹mainؿ
 */
extern int main(int argc, char ** argv);

#define main pseudo_main    //̾main򺹤

    //ʰץեȥȥ졼ǽΥ󥯥롼
#include "base/coverage_defs.h"

#else

/*********************************************************************************************/
/*
 *  ƥȤ¹ԤʤȤΥ饹
 */

#define TESTABLEOBJECT(x)
#define TESTABLEOBJECT_(x,y)
#define TESTSUITE_PROTOTYPE(x)
#define TESTSUITE_(x,y)
#define PROCEED_ONCE

#define BEGIN_CASE(x,y)
#define END_CASE
#define TEST_FAIL

#define CHECKPOINT(x)

/*
    *  ƥȥȼ¹ԥ饹
    */
class TestSuite {
public:
        //ƥȥȤμ¹  (ֵ:Ȥ¹Ԥɤ)
    inline static bool performTestSuite(void) { return true; };
};

#endif

#endif /* TESTSUITE_H */

