/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_support.S,v 1.11 2007/03/23 07:22:15 honda Exp $
 */

/*
 *	åȥƥ¸⥸塼 ֥
 */

#define _MACRO_ONLY
#include "jsp_kernel.h"

/*
 *  ƥ¸ν롼
 */
	.h8300h
	.text
	.align 2

	.global	_hardware_init_hook
_hardware_init_hook:
	/*
	 *  ꡼ǤϡDRAMͭˤ롣
	 */
#ifdef ROM
	mov.l	#H8P1DDR, er0
	mov.b	#0xff, r1l
	mov.b	r1l, @er0	/* enable A0  - A7  */

	add.b	#(H8P2DDR - H8P1DDR), r0l
	mov.b	r1l, @er0	/* enable A8  - A15 */

	add.b	#(H8P3DDR - H8P2DDR), r0l
	mov.b	r1l, @er0	/* enable D8  - D15 */

	add.b	#(H8P5DDR - H8P3DDR), r0l
	mov.b	r1l, @er0	/* enable A16 - A19 */

#ifdef ENABLE_LOWER_DATA

	mov.l	#H8P4DDR, er0
	mov.b	r1l, @er0	/* enable D0  - D7  */

#endif	/* #if ENABLE_LOWER_DATA */

#ifdef ENABLE_P8_CS

	mov.l	#H8P8DDR, er0
	mov.b	#ENABLE_P8_CS, r1l
	mov.b	r1l, @er0	/* enable CS0 - CS3 */

#endif	/* #ifdef ENABLE_P8_CS */

#ifdef ENABLE_PA_CS

	mov.l	#H8PADDR, er0
	mov.b	#ENABLE_PA_CS, r1l
	mov.b	r1l, @er0	/* enable CS4 - CS6 */

#elif defined(ENABLE_PA_A21_A23)

	mov.l	#H8PADDR, er0
	mov.b	#ENABLE_PA_A21_A23, r1l
	mov.b	r1l, @er0	/* enable A21 - A23 */

#endif	/* #ifdef ENABLE_PA_CS */

#ifdef ENABLE_PB_CS

	mov.l	#H8PBDDR, er0
	mov.b	#ENABLE_PB_CS, r1l
	mov.b	r1l, @er0	/* enable CS7 */

#endif	/* #ifdef ENABLE_PB_CS */

#endif	/*  #ifdef ROM  */

	rts
