/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Kunihiko Ohnaka
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_support.S,v 1.13 2007/03/23 07:22:15 honda Exp $
 */

/*
 *	åȥƥ¸⥸塼 ֥
 */

#define _MACRO_ONLY
#include "jsp_kernel.h"

/*
 *  ƥ¸ν롼
 */
	.h8300h
	.text
	.align 2

	.global	_hardware_init_hook
_hardware_init_hook:
	/*
	 *  ꡼ǤϡDRAMͭˤ롣
	 *ʳDRAMѤ
	 */
#ifdef ROM
	mov.b	#0xff, r1l
	mov.l	#H8P1DDR, er0
	mov.b	r1l, @er0	/* enable A0  - A7  */

	add.b	#(H8P2DDR - H8P1DDR), r0l
	mov.b	r1l, @er0	/* enable A8  - A15 */

	add.b	#(H8P3DDR - H8P2DDR), r0l
	mov.b	r1l, @er0	/* enable D8  - D15 */

	mov.b	#H8P5DDR_A16, r0h
	mov.b	r0h, @H8P5DDR	/*  Enable A16		*/
#endif	/*  #ifdef ROM  */

	/*
	 *  EthernetǥХѤ硢CS1ꤷʤ
	 *ǥХư롣
	 */
#if defined(ROM) || defined(INMEM_ONLY)
	mov.b	#H8P8DDR0, r0h
	mov.b	r0h, @H8P8DDR	/*  Enable CS1/CS2	*/
#endif /* defined(ROM) || defined(INMEM_ONLY) */


#ifdef ROM
	mov.b	#H8PBDDR_UCAS, r0h
	mov.b	r0h, @H8PBDDR	/*  Enable UCAS		*/

		/*  DRAM: 2,048/32ms: 32ms / 2,048 = 15.625us	*/
		/*  20MHz / 8 / 39 = 1 / 15.6us			*/
	mov.b	#((32*(CPU_CLOCK/1000))/(8*2048)), r0h
	mov.b	r0h, @H8RTCOR

	mov.b	#H8RTMCSR_CKS1, r0h
	mov.b	r0h, @H8RTMCSR	/*  clock / 8			*/

	mov.b	#(H8DRCRB_RCYCE | H8DRCRB_MXC1), r0h
	mov.b	r0h, @H8DRCRB	/*  column address: 10 bit, A23 - A10	*/

	/*
	 *åȤˤѤƤ볰RAMۤʤ
	 *Ω HM5117800
	 *OKI  M5117805D
	 *
	 *ξбˤ뤿ᡢ
	 *BE ӥåȡᣱ
	 *RDMӥåȡᣰ
	 *
	 *ܺ٤(toppers-users 1375)򻲾
	 *
	 */
	mov.b	#(H8DRCRA_BE | H8DRCRA_DRAS0), r0h
	mov.b	r0h, @H8DRCRA

	mov.l	#(CPU_CLOCK / 1000), er0    /*  Wait for DRAM stable	*/
_hw_init_hock_1:
	dec.l	#1, er0
	bne	_hw_init_hock_1

#endif	/*  #ifdef ROM  */

	rts

