/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Platform Development Center
 *                                          RICOH COMPANY,LTD. JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sfruart.c,v 1.4 2007/01/05 02:33:59 honda Exp $
 */

/*
 *	OAKS16 SFR-UART0,1ѥꥢI/O⥸塼
 */
#include <s_services.h>
#include "oaks16.h"
#include <sfruart.h>

/*
 *  ǥХץΥȥ饤
 *
 *  500ȥ饤Сʬ˽λ롥
 */
#define	SFRUART_COUNT	500

/*
 * ꥢ륳ȥ쥸 
 */
#define	MR_DEF		0x05	/* åƱ8ӥåȡѥƥʤ꡼פʤ */
#define	C0_DEF		0x10	/* RTS/CTS̤, ȥf1 */
#define	C1_DEF		0x00	/* ꥢԲ */
#define	BRG1_DEF	51		/* 19200bps = 16000000/{(UxBRG+1)*16 */
#define	BRG2_DEF	25		/* 38400bps = 16000000/{(UxBRG+1)*16 */
#define	TB_LEVEL	4		/* ߥ٥ */
#define	RB_LEVEL	5		/* ߥ٥ */

/*
 *  ꥢI/OݡȽ֥å
 */
typedef struct sio_port_initialization_block {
	UH  cntrl;		/* ȥ쥸 */
	UH  hint;		/* ߥ쥸 */

	UB  mr_def;		/* ǥեȤ (MR) */
	UB  c0_def;		/* ǥեȤ (C0) */
	UB  brg_def;	/* ǥեȤ (BRG) */
} SIOPINIB;

/*
 *  ꥢI/Oݡȴ֥å
 */
typedef struct sio_port_control_block {
	const SIOPINIB	*siopinib;	/* ꥢI/OݡȽ֥å */
	VP_INT exinf;	/* ĥ */
	UB     cr1;		/* CR1͡ʳߵġ*/
	UB     tic;		/* ߥ٥ */
} SIOPCB;

/*
 *  ꥢI/OݡȽ֥å
 *
 *  ID = 1 uart0ID = 2 uart1бƤ롥
 */
static const SIOPINIB siopinib_table[TNUM_SIOP] = {
	{ TADR_SFR_UART0_BASE, TADR_SFR_INT_BASE, MR_DEF, C0_DEF, BRG1_DEF },
	{ TADR_SFR_UART1_BASE, TADR_SFR_INT_BASE+2, MR_DEF, C0_DEF, BRG1_DEF }
};

/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 */
static SIOPCB siopcb_table[TNUM_SIOP];

/*
 *  ꥢI/OݡID֥åФΥޥ
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  SIOɥ饤Фν롼
 */
void
sfruart_initialize(void)
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  ꥢI/Oݡȴ֥åν
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
		siopcb->siopinib = &(siopinib_table[i]);
		siopcb->cr1 = C1_DEF;
		siopcb->tic = 0;
	}
}

/*
 *  ꥢI/OݡȤΥץ
 */
SIOPCB *
sfruart_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB		*siopcb;
	const SIOPINIB	*siopinib;
	int i;

	siopcb = get_siopcb(siopid);
	siopinib = siopcb->siopinib;

	sil_wrb_mem((VP)(siopinib->cntrl+TADR_SFR_UMR_OFFSET), siopinib->mr_def);
	sil_wrb_mem((VP)(siopinib->cntrl+TADR_SFR_UC0_OFFSET), siopinib->c0_def);
	sil_wrb_mem((VP)(siopinib->cntrl+TADR_SFR_UBRG_OFFSET), siopinib->brg_def);

	/*
	 *  ꥢߤ
	 */
	set_ic_ilvl((VP)(siopinib->hint+TADR_SFR_S0TIC_OFFSET), siopcb->tic);
	set_ic_ilvl((VP)(siopinib->hint+TADR_SFR_S0RIC_OFFSET), RB_LEVEL);
	siopcb->cr1 = TBIT_UiC1_TE;
	sil_wrb_mem((VP)(siopinib->cntrl+TADR_SFR_UC1_OFFSET), siopcb->cr1);

	/*
	 * ߡǡ
	 */
	sil_reb_mem((VP)(siopinib->cntrl+TADR_SFR_URB_OFFSET));
	sil_reb_mem((VP)(siopinib->cntrl+TADR_SFR_URB_OFFSET));

	for(i = 0 ; i < SFRUART_COUNT ; i++){	/* ץREADYޤԤ */
		if(sil_reb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_UC1_OFFSET)) & TBIT_UiC1_TI)
			break;
	}

	siopcb->exinf = exinf;
	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
void
sfruart_cls_por(SIOPCB *siopcb)
{
	const SIOPINIB	*siopinib;

	siopinib = siopcb->siopinib;
	siopcb->tic = 0;
	set_ic_ilvl((VP)(siopinib->hint+TADR_SFR_S0TIC_OFFSET), siopcb->tic);
	sil_wrb_mem((VP)(siopinib->hint+TADR_SFR_S0RIC_OFFSET), 0);
	siopcb->cr1 = C1_DEF;
	sil_wrb_mem((VP)(siopinib->cntrl+TADR_SFR_UC1_OFFSET), siopcb->cr1);
}

/*
 *  ꥢI/OݡȤؤʸ
 */
BOOL
sfruart_snd_chr(SIOPCB *siopcb, char c)
{
	if(sil_reb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_UC1_OFFSET)) & TBIT_UiC1_TI){
		sil_wrb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_UTB_OFFSET), c);
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  ꥢI/OݡȤʸ
 */
INT
sfruart_rcv_chr(SIOPCB *siopcb)
{
	if(sil_reb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_UC1_OFFSET)) & TBIT_UiC1_RI){
		return((INT)sil_reb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_URB_OFFSET)));
	}
	return(-1);
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void
sfruart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:
		siopcb->tic = TB_LEVEL;
		set_ic_ilvl((VP)(siopcb->siopinib->hint+TADR_SFR_S0TIC_OFFSET), siopcb->tic);
		break;
	case SIO_ERDY_RCV:
		siopcb->cr1 |= TBIT_UiC1_RE;
		sil_wrb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_UC1_OFFSET), siopcb->cr1);
		break;
	deafult:
		break;
	}
}

/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
sfruart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:
		siopcb->tic = 0;
		set_ic_ilvl((VP)(siopcb->siopinib->hint+TADR_SFR_S0TIC_OFFSET), siopcb->tic);
		break;
	case SIO_ERDY_RCV:
		siopcb->cr1 &= ~TBIT_UiC1_RE;
		sil_wrb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_UC1_OFFSET), siopcb->cr1);
		break;
	deafult:
		break;
	}
}

/*
 *  uart0μ
 */
void serial_in_handler1(void)
{
	SIOPCB *siopcb = &siopcb_table[0];
	if((siopcb->cr1 & TBIT_UiC1_RE) != 0) {
		/*
		 *  ΥХå롼ƤӽФ
		 */
		sfruart_ierdy_rcv(siopcb->exinf);
	}
}

/*
 *  uart0
 */
void serial_out_handler1(void)
{
	SIOPCB *siopcb = &siopcb_table[0];
	if(siopcb->tic > 0 && (sil_reb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_UC1_OFFSET)) & TBIT_UiC1_TI)){
		/*
		 *  ǽХå롼ƤӽФ
		 */
		sfruart_ierdy_snd(siopcb->exinf);
	}
}

/*
 *  uart1μ
 */
void serial_in_handler2(void)
{
	SIOPCB *siopcb = &siopcb_table[1];
	if((siopcb->cr1 & TBIT_UiC1_RE) != 0){
		/*
		 *  ΥХå롼ƤӽФ
		 */
		sfruart_ierdy_rcv(siopcb->exinf);
	}
}

/*
 *  uart1
 */
void serial_out_handler2(void)
{
	SIOPCB *siopcb = &siopcb_table[1];
	if(siopcb->tic > 0 && (sil_reb_mem((VP)(siopcb->siopinib->cntrl+TADR_SFR_UC1_OFFSET)) & TBIT_UiC1_TI)){
		/*
		 *  ǽХå롼ƤӽФ
		 */
		sfruart_ierdy_snd(siopcb->exinf);
	}
}

