/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.9 2003/07/08 14:57:15 hiro Exp $
 */

/*
 *	ޥɥ饤СDVE68K/40ѡ
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include <dve68k_dga.h>

/*
 *  ޳ߥϥɥΥ٥ֹ
 */
#define	INHNO_TIMER	TVEC_TT0

#ifndef _MACRO_ONLY

/*
 *  ͤɽη
 */
typedef UW	CLOCK;

/*
 *  ͤɽȥߥáñ̤ȤѴ
 *
 *  DVE68K/40 CPUܡɤǤϡޤ1˥ȥåפ롥
 */
#define	TIMER_CLOCK		1000
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define	MAX_CLOCK	((CLOCK) 0xffffff)

/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define	GET_TOLERANCE	100	/* ٤θѤ͡ñ̤ɽ*/
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ߤޤǤλ֡nsecñ̡
 *
 *  ͤ˺Ϥʤ
 */
#define	TIMER_STOP_DELAY	200

/*
 *  쥸
 */
#define	CSR12_START	0x80000000u	/* ư */

/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize()
{
	CLOCK	cyc = TO_CLOCK(TIC_NUME, TIC_DENO);

	/*
	 *  ޼ꤷޤư򳫻Ϥ롥
	 */
	assert(cyc <= MAX_CLOCK);
	dga_write((VP) TADR_DGA_CSR12, CSR12_START | cyc);

	/*
	 *  ޳ߤγߥ٥ꤷ׵򥯥ꥢ塤
	 *  ޥ롥
	 */
	dga_set_ilv((VP) TADR_DGA_CSR25, TBIT_TT0IL, TIRQ_LEVEL4);
	dga_write((VP) TADR_DGA_CSR23, TBIT_TT0);
	dga_bit_or((VP) TADR_DGA_CSR21, TBIT_TT0);
}

/*
 *  ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear()
{
	dga_write((VP) TADR_DGA_CSR23, TBIT_TT0);
}

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
Inline void
hw_timer_terminate()
{
	/*
	 *  ޤưߤ롥
	 */
	dga_bit_and((VP) TADR_DGA_CSR12, ~CSR12_START);

	/*
	 *  ޳ߤޥ׵򥯥ꥢ롥
	 */
	dga_bit_and((VP) TADR_DGA_CSR21, ~TBIT_TT0);
	dga_write((VP) TADR_DGA_CSR23, TBIT_TT0);
}

/*
 *  ޤθͤɽФ
 */
Inline CLOCK
hw_timer_get_current()
{
	CLOCK	clk;

	/*
	 *  ޤưŪߤͤɤ߽Ф
	 */
	dga_bit_and((VP) TADR_DGA_CSR12, ~CSR12_START);
	sil_dly_nse(TIMER_STOP_DELAY);
	clk = dga_read((VP) TADR_DGA_CSR13) & 0x00ffffffu;
	dga_bit_or((VP) TADR_DGA_CSR12, CSR12_START);
	return(clk);
}

/*
 *  ޳׵Υå
 */
Inline BOOL
hw_timer_fetch_interrupt()
{
	return((dga_read((VP) TADR_DGA_CSR20) & TBIT_TT0) != 0);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
