/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _VR4131_DSIU_H_
#define _VR4131_DSIU_H_

#include <s_services.h>		/* ǥХɥ饤ɸ।󥯥롼ɥե */

/*
 *  VR4131¢ǥХåꥢ륤󥿥ե˥å(DSIU)Ϣ
 *  (ʰNS16550)
 */

/* DSIU쥸Υɥ쥹 */
#define DSIURB		0x0f000820	/* Хåե쥸(꡼ɻ) */
#define DSIUTH		0x0f000820	/* ݻ쥸(饤Ȼ) */
#define DSIUDLL		0x0f000820	/* ʬ沼̥쥸 */
#define DSIUIE		0x0f000821	/* ߵĥ쥸 */
#define DSIUDLM		0x0f000821	/* ʬ̥쥸 */
#define DSIUIID		0x0f000822	/* ɽ쥸(꡼ɻ) */
#define DSIUFC		0x0f000822	/* FIFO 쥸(饤Ȼ) */
#define DSIULC		0x0f000823	/* 饤쥸 */
#define DSIUMC		0x0f000824	/* ǥ쥸 */
#define DSIULS		0x0f000825	/* 饤֥쥸 */
#define DSIUMS		0x0f000826	/* ǥ֥쥸 */
#define DSIUSC		0x0f000827	/* å쥸 */

/* for DSIULC */
#define	WORD_LENGTH_8		(BIT1 | BIT0)
#define	STOP_BITS_1		0u		/* BIT2 */
#define	PARITY_NON		0u		/* BIT3, 4 */
/* BIT5,6 ά */
#define	DIVISOR_LATCH_ACC	BIT7

/* for DSIUIE */
#define	DIS_INT			0u
#define	RECEIVE_DATA_AVAILABLE	BIT0
#define	TRANS_REG_EMPTY		BIT1
#define RECEIVE_LINE_STATUS	BIT2
#define MODEM_STATUS		BIT3

/* for DSIUMC */
#define	DTR			BIT0
#define	RTS			BIT1

/* for DSIUFC */
#define	FIFO_ENABLE		BIT0
#define	RECEIVE_FIFO_RESET	BIT1
#define	TRANS_FIFO_RESET	BIT2
#define RECEIVE_TRIG_1_BYTE	0u	/* BIT6, 7 */
#define RECEIVE_TRIG_4_BYTE	BIT6
#define	RECEIVE_TRIG_8_BYTE	BIT7
#define	RECEIVE_TRIG_14_BYTE	(BIT6 | BIT7)

/* for DSIUIID */
#define	INT_MASK		0x0eu
#define	INT_RECEIVE_DATA	BIT2
#define INT_CHAR_TIME_OUT	(BIT3 | BIT2)
#define	INT_TRANS_EMPTY		BIT1

/* for DSIULS */
#define	THRE			BIT5
#define TEMT			BIT6

/* ܡ졼ط */
#define	DIVISOR			XIN_CLOCK / (16u * DEVIDE_RATIO)

#ifndef _MACRO_ONLY

/*
 *  ꥢI/OݡȽ֥å
 */
typedef struct sio_port_control_block	SIOPCB;

#endif /* _MACRO_ONLY */

/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND	1u		/* ǽХå */
#define SIO_ERDY_RCV	2u		/* ΥХå */

#ifndef _MACRO_ONLY

/*
 *  SIOɥ饤Фν롼
 */
extern void	vr4131_dsiu_initialize(void);

/*
 *  ץ󤷤ƤݡȤ뤫
 */
extern BOOL	vr4131_dsiu_openflag(void);

/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB	*vr4131_dsiu_opn_por(ID siopid, VP_INT exinf);

/*
 *  ꥢI/OݡȤΥ
 */
extern void	vr4131_dsiu_cls_por(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤؤʸ
 */
extern BOOL	vr4131_dsiu_snd_chr(SIOPCB *siopcb, char c);

/*
 *  ꥢI/OݡȤʸ
 */
extern INT	vr4131_dsiu_rcv_chr(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤΥХåε
 */
extern void	vr4131_dsiu_ena_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void	vr4131_dsiu_dis_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  SIOγߥӥ롼
 */
extern void	vr4131_dsiu_dsiu_isr(void);

/*
 *  ꥢI/OݡȤǽХå
 */
extern void	vr4131_dsiu_ierdy_snd(VP_INT exinf);

/*
 *  ꥢI/OݡȤμΥХå
 */
extern void	vr4131_dsiu_ierdy_rcv(VP_INT exinf);

/*
 *  ͥ뵯ưѤν (sys_putc)
 */
extern void	vr4131_dsiu_init(void);

/*
 *  ꥢI/OݡȤؤʸʥݡ󥰡
 */
extern void	vr4131_dsiu_putchar_pol(char c);

#endif /* _MACRO_ONLY */

#endif /* _VR4131_DSIU_H_ */
