/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sh7145sci.h,v 1.1 2005/07/06 00:45:07 honda Exp $
 */

/*
 *   SH2¢ꥢ륳ߥ˥󥤥󥿥եSCI ʰץɥ饤
 */

#ifndef _sh7145sci_H_
#define _sh7145sci_H_

#include <t_config.h>

/*
 *  ꥢI/OݡȽ֥å
 */
typedef struct sio_port_initialization_block
{
	UW reg_base;				/* 쥸Υ١ɥ쥹 */
	UB brr;						/* ܡ졼Ȥ   */
	UB smr;						/* ⡼ɥ쥸   */
	UB int_level;				/* ߥ٥   */
} SIOPINIB;

/*
 *  ꥢI/Oݡȴ֥å
 */
typedef struct sio_port_control_block
{
	const SIOPINIB *siopinib;	/* ꥢI/OݡȽ֥å */
	VP_INT exinf;				/* ĥ */
	BOOL openflag;				/* ץѤߥե饰 */
	BOOL sendflag;				/* ߥ֥͡ե饰 */
	BOOL getready;				/* ʸ */
	BOOL putready;				/* ʸǤ */
} SIOPCB;

/*
 *  ȥ쥸Υɥ쥹Υեå 
 */
#define SCI_SCR	0x2
#define SCI_SSR	0x4
#define SCI_BRR	0x1
#define SCI_SMR	0x0
#define SCI_TDR	0x3
#define SCI_RDR	0x5
#define SCI_SDCR 0x6


/*
 *  ȥ쥸
 */
#define SCI_TIE		0x80		/* ȥ󥹥ߥåȥ󥿥ץȥ֥͡ */
#define SCI_RIE		0x40		/* 쥷֥󥿥ץȥ֥͡   */
#define SCI_TE		0x20		/* ȥ󥹥ߥåȥ֥͡         */
#define SCI_RE		0x10		/* 쥷֥֥͡           */
#define SSR_ORER	0x20		/* С󥨥顼           */
#define SSR_FER		0x10		/* ե졼ߥ󥰥顼           */
#define SSR_PER		0x08		/* ѥƥ顼           */
#define SSR_TDRE	0x80		/* ȥ󥹥ߥåȥǡ쥸ץƥ */
#define SSR_RDRF	0x40		/* 쥷֥ǡ쥸ե       */

#define sh2sci_DELAY 	105000

#define PFC_TXD0	0x0004
#define PFC_RXD0	0x0001
#define PFC_TXD1	0x0100
#define PFC_RXD1	0x0040
#define PFC_TXD2	0x0020
#define PFC_RXD2	0x8000

/*
 *  SCI
 */
#define SMR_CKS 	0x0			/*  ʬ          */
#define BRR9600 	79			/*  9600 ӥåȥ졼    */
#define BRR19200	39			/*  19200 ӥåȥ졼    */
#define BRR38400	19			/*  38400 ӥåȥ졼    */

/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND	1u		/* ǽХå */
#define SIO_ERDY_RCV	2u		/* ΥХå */

/*
 *  SIOɥ饤Фν롼
 */
extern void sh2sci_initialize (void);

/*
 *  ץ󤷤ƤݡȤ뤫
 */
extern BOOL sh2sci_openflag (ID siopid);

/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB *sh2sci_opn_por (ID siopid, VP_INT exinf);

/*
 *  ꥢI/OݡȤΥ
 */
extern void sh2sci_cls_por (SIOPCB * siopcb);

/*
 *  ꥢI/OݡȤؤʸ
 */
extern BOOL sh2sci_snd_chr (SIOPCB * siopcb, char c);

/*
 *  ꥢI/OݡȤʸ
 */
extern INT sh2sci_rcv_chr (SIOPCB * siopcb);

/*
 *  ꥢI/OݡȤΥХåε
 */
extern void sh2sci_ena_cbr (SIOPCB * siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void sh2sci_dis_cbr (SIOPCB * siopcb, UINT cbrtn);

/*
 *  SIOγߥӥ롼
 */
extern void sh2sci_isr (void);

/*
 *  ꥢI/OݡȤǽХå
 */
extern void sh2sci_ierdy_snd (VP_INT exinf);

/*
 *  ꥢI/OݡȤμΥХå
 */
extern void sh2sci_ierdy_rcv (VP_INT exinf);

#endif /* _sh7145sci_H_ */
