/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2005 by Freelines CO.,Ltd 
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: v850es_sg2.h,v 1.4 2007/03/23 08:20:08 honda Exp $
 */

#ifndef	_V850ES_SG2_H_
#define	_V850ES_SG2_H_
/*
 *	ץå˰¸V850ѡ
 */
#ifndef _MACRO_ONLY
typedef unsigned char   byte;
typedef unsigned short  word;
typedef unsigned long   dword;
typedef volatile byte   IOREG;
typedef volatile word   HIOREG;
typedef volatile dword  LIOREG;
#endif /* _MACRO_ONLY */

/*
 * ¢RAM
 */
#define	IRAM_TOP	0x03FF7000		/* ¢RAMƬɥ쥹 */
#define IRAM_SIZE	0x8000			/* ¢RAM礭 32Kbyte(uPD70F3281Y) */
/*
 * ¢FlashROM
 */
#define	IROM_TOP	0x0000000		/* ¢FlashROMƬɥ쥹 */
#define IROM_SIZE	0x60000			/* ¢FlashROM礭 384Kbyte(uPD70F3281Y) */

/* 
 * V850ES/SG2IO쥸
 */
#define	PDL			0xFFFFF004		/* ݡDL쥸 */
#define	PDLL		0xFFFFF004		/* ݡDL쥸L */
#define	PDLH		0xFFFFF005		/* ݡDL쥸H */
#define	PDH			0xFFFFF006		/* ݡDH쥸 */
#define	PCT			0xFFFFF00A		/* ݡCT쥸 */
#define	PCM			0xFFFFF00C		/* ݡCM쥸 */
#define	PMDL		0xFFFFF024		/* ݡDL⡼ɡ쥸 */
#define	PMDLL		0xFFFFF024		/* ݡDL⡼ɡ쥸L */
#define	PMDLH		0xFFFFF025		/* ݡDL⡼ɡ쥸H */
#define	PMDH		0xFFFFF026		/* ݡDH⡼ɡ쥸 */
#define	PMCT		0xFFFFF02A		/* ݡCT⡼ɡ쥸 */
#define	PMCM		0xFFFFF02C		/* ݡCM⡼ɡ쥸 */
#define	PMCDL		0xFFFFF044		/* ݡDL⡼ɡȥ롦쥸 */
#define	PMCDLL		0xFFFFF044		/* ݡDL⡼ɡȥ롦쥸L */
#define	PMCDLH		0xFFFFF045		/* ݡDL⡼ɡȥ롦쥸H */
#define	PMCDH		0xFFFFF046		/* ݡDH⡼ɡȥ롦쥸 */
#define	PMCCT		0xFFFFF04A		/* ݡCT⡼ɡȥ롦쥸 */
#define	PMCCM		0xFFFFF04C		/* ݡCM⡼ɡȥ롦쥸 */
#define	BPC			0xFFFFF064		/* I/Oΰ襻쥯쥸 */
#define	BSC			0xFFFFF066		/* Хե졼󡦥쥸Х */
#define	VSWC		0xFFFFF06E		/* ƥࡦȡȥ롦쥸 */
#define	DSA0L		0xFFFFF080		/* DMAɥ쥹쥸0L */
#define	DSA0H		0xFFFFF082		/* DMAɥ쥹쥸0H */
#define	DDA0L		0xFFFFF084		/* DMAǥƥ͡󡦥ɥ쥹쥸0L */
#define	DDA0H		0xFFFFF086		/* DMAǥƥ͡󡦥ɥ쥹쥸0H */
#define	DSA1L		0xFFFFF088		/* DMAɥ쥹쥸1L */
#define	DSA1H		0xFFFFF08A		/* DMAɥ쥹쥸1H */
#define	DDA1L		0xFFFFF08C		/* DMAǥƥ͡󡦥ɥ쥹쥸1L */
#define	DDA1H		0xFFFFF08E		/* DMAǥƥ͡󡦥ɥ쥹쥸1H */
#define	DSA2L		0xFFFFF090		/* DMAɥ쥹쥸2L */
#define	DSA2H		0xFFFFF092		/* DMAɥ쥹쥸2H */
#define	DDA2L		0xFFFFF094		/* DMAǥƥ͡󡦥ɥ쥹쥸2L */
#define	DDA2H		0xFFFFF096		/* DMAǥƥ͡󡦥ɥ쥹쥸2H */
#define	DSA3L		0xFFFFF098		/* DMAɥ쥹쥸3L */
#define	DSA3H		0xFFFFF09A		/* DMAɥ쥹쥸3H */
#define	DDA3L		0xFFFFF09C		/* DMAǥƥ͡󡦥ɥ쥹쥸3L */
#define	DDA3H		0xFFFFF09E		/* DMAǥƥ͡󡦥ɥ쥹쥸3H */
#define	DBC0		0xFFFFF0C0		/* DMAžȡ쥸0 */
#define	DBC1		0xFFFFF0C2		/* DMAžȡ쥸1 */
#define	DBC2		0xFFFFF0C4		/* DMAžȡ쥸2 */
#define	DBC3		0xFFFFF0C6		/* DMAžȡ쥸3 */
#define	DADC0		0xFFFFF0D0		/* DMAɥ쥷󥰡ȥ롦쥸0 */
#define	DADC1		0xFFFFF0D2		/* DMAɥ쥷󥰡ȥ롦쥸1 */
#define	DADC2		0xFFFFF0D4		/* DMAɥ쥷󥰡ȥ롦쥸2 */
#define	DADC3		0xFFFFF0D6		/* DMAɥ쥷󥰡ȥ롦쥸3 */
#define	DCHC0		0xFFFFF0E0		/* DMAͥ롦ȥ롦쥸0 */
#define	DCHC1		0xFFFFF0E2		/* DMAͥ롦ȥ롦쥸1 */
#define	DCHC2		0xFFFFF0E4		/* DMAͥ롦ȥ롦쥸2 */
#define	DCHC3		0xFFFFF0E6		/* DMAͥ롦ȥ롦쥸3 */
#define	IMR0		0xFFFFF100		/* ߥޥ쥸0 */
#define	IMR0L		0xFFFFF100		/* ߥޥ쥸0L */
#define	IMR0H		0xFFFFF101		/* ߥޥ쥸0H */
#define	IMR1		0xFFFFF102		/* ߥޥ쥸1 */
#define	IMR1L		0xFFFFF102		/* ߥޥ쥸1L */
#define	IMR1H		0xFFFFF103		/* ߥޥ쥸1H */
#define	IMR2		0xFFFFF104		/* ߥޥ쥸2 */
#define	IMR2L		0xFFFFF104		/* ߥޥ쥸2L */
#define	IMR2H		0xFFFFF105		/* ߥޥ쥸2H */
#define	IMR3		0xFFFFF106		/* ߥޥ쥸3 */
#define	IMR3L		0xFFFFF106		/* ߥޥ쥸3L */
#define	IMR3H		0xFFFFF107		/* ߥޥ쥸3H */
#define	LVIIC		0xFFFFF110		/* 쥸 */
#define	PIC0		0xFFFFF112		/* 쥸 */
#define	PIC1		0xFFFFF114		/* 쥸 */
#define	PIC2		0xFFFFF116		/* 쥸 */
#define	PIC3		0xFFFFF118		/* 쥸 */
#define	PIC4		0xFFFFF11A		/* 쥸 */
#define	PIC5		0xFFFFF11C		/* 쥸 */
#define	PIC6		0xFFFFF11E		/* 쥸 */
#define	PIC7		0xFFFFF120		/* 쥸 */
#define	TQ0OVIC		0xFFFFF122		/* 쥸 */
#define	TQ0CCIC0	0xFFFFF124		/* 쥸 */
#define	TQ0CCIC1	0xFFFFF126		/* 쥸 */
#define	TQ0CCIC2	0xFFFFF128		/* 쥸 */
#define	TQ0CCIC3	0xFFFFF12A		/* 쥸 */
#define	TP0OVIC		0xFFFFF12C		/* 쥸 */
#define	TP0CCIC0	0xFFFFF12E		/* 쥸 */
#define	TP0CCIC1	0xFFFFF130		/* 쥸 */
#define	TP1OVIC		0xFFFFF132		/* 쥸 */
#define	TP1CCIC0	0xFFFFF134		/* 쥸 */
#define	TP1CCIC1	0xFFFFF136		/* 쥸 */
#define	TP2OVIC		0xFFFFF138		/* 쥸 */
#define	TP2CCIC0	0xFFFFF13A		/* 쥸 */
#define	TP2CCIC1	0xFFFFF13C		/* 쥸 */
#define	TP3OVIC		0xFFFFF13E		/* 쥸 */
#define	TP3CCIC0	0xFFFFF140		/* 쥸 */
#define	TP3CCIC1	0xFFFFF142		/* 쥸 */
#define	TP4OVIC		0xFFFFF144		/* 쥸 */
#define	TP4CCIC0	0xFFFFF146		/* 쥸 */
#define	TP4CCIC1	0xFFFFF148		/* 쥸 */
#define	TP5OVIC		0xFFFFF14A		/* 쥸 */
#define	TP5CCIC0	0xFFFFF14C		/* 쥸 */
#define	TP5CCIC1	0xFFFFF14E		/* 쥸 */
#define	TM0EQIC0	0xFFFFF150		/* 쥸 */
#define	CB0RIC		0xFFFFF152		/* 쥸 */
#define	IICIC1		0xFFFFF152		/* 쥸 */
#define	CB0TIC		0xFFFFF154		/* 쥸 */
#define	CB1RIC		0xFFFFF156		/* 쥸 */
#define	CB1TIC		0xFFFFF158		/* 쥸 */
#define	CB2RIC		0xFFFFF15A		/* 쥸 */
#define	CB2TIC		0xFFFFF15C		/* 쥸 */
#define	CB3RIC		0xFFFFF15E		/* 쥸 */
#define	CB3TIC		0xFFFFF160		/* 쥸 */
#define	UA0RIC		0xFFFFF162		/* 쥸 */
#define	CB4RIC		0xFFFFF162		/* 쥸 */
#define	UA0TIC		0xFFFFF164		/* 쥸 */
#define	CB4TIC		0xFFFFF164		/* 쥸 */
#define	UA1RIC		0xFFFFF166		/* 쥸 */
#define	IICIC2		0xFFFFF166		/* 쥸 */
#define	UA1TIC		0xFFFFF168		/* 쥸 */
#define	UA2RIC		0xFFFFF16A		/* 쥸 */
#define	IICIC0		0xFFFFF16A		/* 쥸 */
#define	UA2TIC		0xFFFFF16C		/* 쥸 */
#define	ADIC		0xFFFFF16E		/* 쥸 */
#define	DMAIC0		0xFFFFF170		/* 쥸 */
#define	DMAIC1		0xFFFFF172		/* 쥸 */
#define	DMAIC2		0xFFFFF174		/* 쥸 */
#define	DMAIC3		0xFFFFF176		/* 쥸 */
#define	KRIC		0xFFFFF178		/* 쥸 */
#define	WTIIC		0xFFFFF17A		/* 쥸 */
#define	WTIC		0xFFFFF17C		/* 쥸 */
#define	ERRIC0		0xFFFFF17E		/* 쥸 */
#define	ERRIC		0xFFFFF17E		/* 쥸 */
#define	WUPIC0		0xFFFFF180		/* 쥸 */
#define	STAIC		0xFFFFF180		/* 쥸 */
#define	RECIC0		0xFFFFF182		/* 쥸 */
#define	IEIC1		0xFFFFF182		/* 쥸 */
#define	TRXIC0		0xFFFFF184		/* 쥸 */
#define	IEIC2		0xFFFFF184		/* 쥸 */
#define	ISPR		0xFFFFF1FA		/* 󥵡ӥץ饤ƥ쥸 */
#define	PRCMD		0xFFFFF1FC		/* ޥɡ쥸 */
#define	PSC			0xFFFFF1FE		/* ѥ֡ȥ롦쥸 */
#define	ADA0M0		0xFFFFF200		/* A/DС⡼ɡ쥸0 */
#define	ADA0M1		0xFFFFF201		/* A/DС⡼ɡ쥸1 */
#define	ADA0S		0xFFFFF202		/* A/DСͥ쥸 */
#define	ADA0M2		0xFFFFF203		/* A/DС⡼ɡ쥸2 */
#define	ADA0PFM		0xFFFFF204		/* ѥեӥ⡼ɡ쥸 */
#define	ADA0PFT		0xFFFFF205		/* ѥեӤͥ쥸 */
#define	ADA0CR0		0xFFFFF210		/* A/DѴ̥쥸0 */
#define	ADA0CR0H	0xFFFFF211		/* A/DѴ̥쥸0H */
#define	ADA0CR1		0xFFFFF212		/* A/DѴ̥쥸1 */
#define	ADA0CR1H	0xFFFFF213		/* A/DѴ̥쥸1H */
#define	ADA0CR2		0xFFFFF214		/* A/DѴ̥쥸2 */
#define	ADA0CR2H	0xFFFFF215		/* A/DѴ̥쥸2H */
#define	ADA0CR3		0xFFFFF216		/* A/DѴ̥쥸3 */
#define	ADA0CR3H	0xFFFFF217		/* A/DѴ̥쥸3H */
#define	ADA0CR4		0xFFFFF218		/* A/DѴ̥쥸4 */
#define	ADA0CR4H	0xFFFFF219		/* A/DѴ̥쥸4H */
#define	ADA0CR5		0xFFFFF21A		/* A/DѴ̥쥸5 */
#define	ADA0CR5H	0xFFFFF21B		/* A/DѴ̥쥸5H */
#define	ADA0CR6		0xFFFFF21C		/* A/DѴ̥쥸6 */
#define	ADA0CR6H	0xFFFFF21D		/* A/DѴ̥쥸6H */
#define	ADA0CR7		0xFFFFF21E		/* A/DѴ̥쥸7 */
#define	ADA0CR7H	0xFFFFF21F		/* A/DѴ̥쥸7H */
#define	ADA0CR8		0xFFFFF220		/* A/DѴ̥쥸8 */
#define	ADA0CR8H	0xFFFFF221		/* A/DѴ̥쥸8H */
#define	ADA0CR9		0xFFFFF222		/* A/DѴ̥쥸9 */
#define	ADA0CR9H	0xFFFFF223		/* A/DѴ̥쥸9H */
#define	ADA0CR10	0xFFFFF224		/* A/DѴ̥쥸10 */
#define	ADA0CR10H	0xFFFFF225		/* A/DѴ̥쥸10H */
#define	ADA0CR11	0xFFFFF226		/* A/DѴ̥쥸11 */
#define	ADA0CR11H	0xFFFFF227		/* A/DѴ̥쥸11H */
#define	DA0CS0		0xFFFFF280		/* D/AСѴ쥸0 */
#define	DA0CS1		0xFFFFF281		/* D/AСѴ쥸1 */
#define	DA0M		0xFFFFF282		/* D/AС⡼ɡ쥸 */
#define	KRM			0xFFFFF300		/* ꥿󡦥⡼ɡ쥸 */
#define	SELCNT0		0xFFFFF308		/* 쥯ư쥸 */
#define	CRCIN		0xFFFFF310		/* CRCץåȡ쥸 */
#define	CRCD		0xFFFFF312		/* CRCǡ쥸 */
#define	NFC			0xFFFFF318		/* Υ쥸 */
#define	PRSM1		0xFFFFF320		/* BRG1ץꥹ顦⡼ɡ쥸 */
#define	PRSCM1		0xFFFFF321		/* BRG1ץꥹ顦ڥ쥸 */
#define	PRSM2		0xFFFFF324		/* BRG2ץꥹ顦⡼ɡ쥸 */
#define	PRSCM2		0xFFFFF325		/* BRG2ץꥹ顦ڥ쥸 */
#define	PRSM3		0xFFFFF328		/* BRG3ץꥹ顦⡼ɡ쥸 */
#define	PRSCM3		0xFFFFF329		/* BRG3ץꥹ顦ڥ쥸 */
#define	OCKS0		0xFFFFF340		/* IICʬå쥸0 */
#define	OCKS1		0xFFFFF344		/* IICʬå쥸1 */
#define	OCKS2		0xFFFFF348		/* IEBuså쥸 */
#define	BCR			0xFFFFF360		/* IEBusȥ롦쥸 */
#define	PSR			0xFFFFF361		/* IEBusѥ֡쥸 */
#define	SSR			0xFFFFF362		/* IEBus졼֡ơ쥸 */
#define	USR			0xFFFFF363		/* IEBus˥åȡơ쥸 */
#define	ISR			0xFFFFF364		/* IEBus󥿥ץȡơ쥸 */
#define	ESR			0xFFFFF365		/* IEBus顼ơ쥸 */
#define	UAR			0xFFFFF366		/* IEBus˥åȡɥ쥹쥸 */
#define	SAR			0xFFFFF368		/* IEBus졼֡ɥ쥹쥸 */
#define	PAR			0xFFFFF36A		/* IEBusѡȥʡɥ쥹쥸 */
#define	RSA			0xFFFFF36C		/* IEBus졼֡ɥ쥹쥸 */
#define	CDR			0xFFFFF36E		/* IEBusȥ롦ǡ쥸 */
#define	DLR			0xFFFFF36F		/* IEBusʸĹ쥸 */
#define	DR			0xFFFFF370		/* IEBusǡ쥸 */
#define	FSR			0xFFFFF371		/* IEBusեɡơ쥸 */
#define	SCR			0xFFFFF372		/* IEBusȡ쥸 */
#define	CCR			0xFFFFF373		/* IEBusߥ˥󡦥ȡ쥸 */
#define	P0			0xFFFFF400		/* ݡ0쥸 */
#define	P1			0xFFFFF402		/* ݡ1쥸 */
#define	P3			0xFFFFF406		/* ݡ3쥸 */
#define	P3L			0xFFFFF406		/* ݡ3쥸L */
#define	P3H			0xFFFFF407		/* ݡ3쥸H */
#define	P4			0xFFFFF408		/* ݡ4쥸 */
#define	P5			0xFFFFF40A		/* ݡ5쥸 */
#define	P7L			0xFFFFF40E		/* ݡ7쥸L */
#define	P7H			0xFFFFF40F		/* ݡ7쥸H */
#define	P9			0xFFFFF412		/* ݡ9쥸 */
#define	P9L			0xFFFFF412		/* ݡ9쥸L */
#define	P9H			0xFFFFF413		/* ݡ9쥸H */
#define	PM0			0xFFFFF420		/* ݡ0⡼ɡ쥸 */
#define	PM1			0xFFFFF422		/* ݡ1⡼ɡ쥸 */
#define	PM3			0xFFFFF426		/* ݡ3⡼ɡ쥸 */
#define	PM3L		0xFFFFF426		/* ݡ3⡼ɡ쥸L */
#define	PM3H		0xFFFFF427		/* ݡ3⡼ɡ쥸H */
#define	PM4			0xFFFFF428		/* ݡ4⡼ɡ쥸 */
#define	PM5			0xFFFFF42A		/* ݡ5⡼ɡ쥸 */
#define	PM7L		0xFFFFF42E		/* ݡ7⡼ɡ쥸L */
#define	PM7H		0xFFFFF42F		/* ݡ7⡼ɡ쥸H */
#define	PM9			0xFFFFF432		/* ݡ9⡼ɡ쥸 */
#define	PM9L		0xFFFFF432		/* ݡ9⡼ɡ쥸L */
#define	PM9H		0xFFFFF433		/* ݡ9⡼ɡ쥸H */
#define	PMC0		0xFFFFF440		/* ݡ0⡼ɡȥ롦쥸 */
#define	PMC3		0xFFFFF446		/* ݡ3⡼ɡȥ롦쥸 */
#define	PMC3L		0xFFFFF446		/* ݡ3⡼ɡȥ롦쥸L */
#define	PMC3H		0xFFFFF447		/* ݡ3⡼ɡȥ롦쥸H */
#define	PMC4		0xFFFFF448		/* ݡ4⡼ɡȥ롦쥸 */
#define	PMC5		0xFFFFF44A		/* ݡ5⡼ɡȥ롦쥸 */
#define	PMC9		0xFFFFF452		/* ݡ9⡼ɡȥ롦쥸 */
#define	PMC9L		0xFFFFF452		/* ݡ9⡼ɡȥ롦쥸L */
#define	PMC9H		0xFFFFF453		/* ݡ9⡼ɡȥ롦쥸H */
#define	PFC0		0xFFFFF460		/* ݡ0ե󥯥󡦥ȥ롦쥸 */
#define	PFC3		0xFFFFF466		/* ݡ3ե󥯥󡦥ȥ롦쥸 */
#define	PFC3L		0xFFFFF466		/* ݡ3ե󥯥󡦥ȥ롦쥸L */
#define	PFC3H		0xFFFFF467		/* ݡ3ե󥯥󡦥ȥ롦쥸H */
#define	PFC4		0xFFFFF468		/* ݡ4ե󥯥󡦥ȥ롦쥸 */
#define	PFC5		0xFFFFF46A		/* ݡ5ե󥯥󡦥ȥ롦쥸 */
#define	PFC9		0xFFFFF472		/* ݡ9ե󥯥󡦥ȥ롦쥸 */
#define	PFC9L		0xFFFFF472		/* ݡ9ե󥯥󡦥ȥ롦쥸L */
#define	PFC9H		0xFFFFF473		/* ݡ9ե󥯥󡦥ȥ롦쥸H */
#define	DWC0		0xFFFFF484		/* ǡȡȥ롦쥸0 */
#define	AWC			0xFFFFF488		/* ɥ쥹ȡȥ롦쥸 */
#define	BCC			0xFFFFF48A		/* Х롦ȥ롦쥸 */
#define	TQ0CTL0		0xFFFFF540		/* TMQ0쥸0 */
#define	TQ0CTL1		0xFFFFF541		/* TMQ0쥸1 */
#define	TQ0IOC0		0xFFFFF542		/* TMQ0I/O쥸0 */
#define	TQ0IOC1		0xFFFFF543		/* TMQ0I/O쥸1 */
#define	TQ0IOC2		0xFFFFF544		/* TMQ0I/O쥸2 */
#define	TQ0OPT0		0xFFFFF545		/* TMQ0ץ󡦥쥸 */
#define	TQ0CCR0		0xFFFFF546		/* TMQ0ץ㡿ڥ쥸0 */
#define	TQ0CCR1		0xFFFFF548		/* TMQ0ץ㡿ڥ쥸1 */
#define	TQ0CCR2		0xFFFFF54A		/* TMQ0ץ㡿ڥ쥸2 */
#define	TQ0CCR3		0xFFFFF54C		/* TMQ0ץ㡿ڥ쥸3 */
#define	TQ0CNT		0xFFFFF54E		/* TMQ0󥿡꡼ɡХåե쥸 */
#define	TP0CTL0		0xFFFFF590		/* TMP0쥸0 */
#define	TP0CTL1		0xFFFFF591		/* TMP0쥸1 */
#define	TP0IOC0		0xFFFFF592		/* TMP0I/O쥸0 */
#define	TP0IOC1		0xFFFFF593		/* TMP0I/O쥸1 */
#define	TP0IOC2		0xFFFFF594		/* TMP0I/O쥸2 */
#define	TP0OPT0		0xFFFFF595		/* TMP0ץ󡦥쥸 */
#define	TP0CCR0		0xFFFFF596		/* TMP0ץ㡿ڥ쥸0 */
#define	TP0CCR1		0xFFFFF598		/* TMP0ץ㡿ڥ쥸1 */
#define	TP0CNT		0xFFFFF59A		/* TMP0󥿡꡼ɡХåե쥸 */
#define	TP1CTL0		0xFFFFF5A0		/* TMP1쥸0 */
#define	TP1CTL1		0xFFFFF5A1		/* TMP1쥸1 */
#define	TP1IOC0		0xFFFFF5A2		/* TMP1I/O쥸0 */
#define	TP1IOC1		0xFFFFF5A3		/* TMP1I/O쥸1 */
#define	TP1IOC2		0xFFFFF5A4		/* TMP1I/O쥸2 */
#define	TP1OPT0		0xFFFFF5A5		/* TMP1ץ󡦥쥸 */
#define	TP1CCR0		0xFFFFF5A6		/* TMP1ץ㡿ڥ쥸0 */
#define	TP1CCR1		0xFFFFF5A8		/* TMP1ץ㡿ڥ쥸1 */
#define	TP1CNT		0xFFFFF5AA		/* TMP1󥿡꡼ɡХåե쥸 */
#define	TP2CTL0		0xFFFFF5B0		/* TMP2쥸0 */
#define	TP2CTL1		0xFFFFF5B1		/* TMP2쥸1 */
#define	TP2IOC0		0xFFFFF5B2		/* TMP2I/O쥸0 */
#define	TP2IOC1		0xFFFFF5B3		/* TMP2I/O쥸1 */
#define	TP2IOC2		0xFFFFF5B4		/* TMP2I/O쥸2 */
#define	TP2OPT0		0xFFFFF5B5		/* TMP2ץ󡦥쥸 */
#define	TP2CCR0		0xFFFFF5B6		/* TMP2ץ㡿ڥ쥸0 */
#define	TP2CCR1		0xFFFFF5B8		/* TMP2ץ㡿ڥ쥸1 */
#define	TP2CNT		0xFFFFF5BA		/* TMP2󥿡꡼ɡХåե쥸 */
#define	TP3CTL0		0xFFFFF5C0		/* TMP3쥸0 */
#define	TP3CTL1		0xFFFFF5C1		/* TMP3쥸1 */
#define	TP3IOC0		0xFFFFF5C2		/* TMP3I/O쥸0 */
#define	TP3IOC1		0xFFFFF5C3		/* TMP3I/O쥸1 */
#define	TP3IOC2		0xFFFFF5C4		/* TMP3I/O쥸2 */
#define	TP3OPT0		0xFFFFF5C5		/* TMP3ץ󡦥쥸 */
#define	TP3CCR0		0xFFFFF5C6		/* TMP3ץ㡿ڥ쥸0 */
#define	TP3CCR1		0xFFFFF5C8		/* TMP3ץ㡿ڥ쥸1 */
#define	TP3CNT		0xFFFFF5CA		/* TMP3󥿡꡼ɡХåե쥸 */
#define	TP4CTL0		0xFFFFF5D0		/* TMP4쥸0 */
#define	TP4CTL1		0xFFFFF5D1		/* TMP4쥸1 */
#define	TP4IOC0		0xFFFFF5D2		/* TMP4I/O쥸0 */
#define	TP4IOC1		0xFFFFF5D3		/* TMP4I/O쥸1 */
#define	TP4IOC2		0xFFFFF5D4		/* TMP4I/O쥸2 */
#define	TP4OPT0		0xFFFFF5D5		/* TMP4ץ󡦥쥸 */
#define	TP4CCR0		0xFFFFF5D6		/* TMP4ץ㡿ڥ쥸0 */
#define	TP4CCR1		0xFFFFF5D8		/* TMP4ץ㡿ڥ쥸1 */
#define	TP4CNT		0xFFFFF5DA		/* TMP4󥿡꡼ɡХåե쥸 */
#define	TP5CTL0		0xFFFFF5E0		/* TMP5쥸0 */
#define	TP5CTL1		0xFFFFF5E1		/* TMP5쥸1 */
#define	TP5IOC0		0xFFFFF5E2		/* TMP5I/O쥸0 */
#define	TP5IOC1		0xFFFFF5E3		/* TMP5I/O쥸1 */
#define	TP5IOC2		0xFFFFF5E4		/* TMP5I/O쥸2 */
#define	TP5OPT0		0xFFFFF5E5		/* TMP5ץ󡦥쥸 */
#define	TP5CCR0		0xFFFFF5E6		/* TMP5ץ㡿ڥ쥸0 */
#define	TP5CCR1		0xFFFFF5E8		/* TMP5ץ㡿ڥ쥸1 */
#define	TP5CNT		0xFFFFF5EA		/* TMP5󥿡꡼ɡХåե쥸 */
#define	WTM			0xFFFFF680		/* ץư⡼ɡ쥸 */
#define	TM0CTL0		0xFFFFF690		/* TMM0쥸0 */
#define	TM0CMP0		0xFFFFF694		/* TMM0ڥ쥸0 */
#define	OSTS		0xFFFFF6C0		/* ȯ쥸 */
#define	PLLS		0xFFFFF6C1		/* PLLåå׻ֻ쥸 */
#define	WDTM2		0xFFFFF6D0		/* åɥåޡ⡼ɡ쥸2 */
#define	WDTE		0xFFFFF6D1		/* åɥåޡ֥͡롦쥸 */
#define	RTBL0		0xFFFFF6E0		/* ꥢ륿ϥХåե쥸0 */
#define	RTBH0		0xFFFFF6E2		/* ꥢ륿ϥХåե쥸0H */
#define	RTPM0		0xFFFFF6E4		/* ꥢ륿ϥݡȡ⡼ɡ쥸0 */
#define	RTPC0		0xFFFFF6E5		/* ꥢ륿ϥݡȡȥ롦쥸0 */
#define	PFCE3L		0xFFFFF706		/* ݡ3ե󥯥󡦥ȥĥ쥸L */
#define	PFCE5		0xFFFFF70A		/* ݡ5ե󥯥󡦥ȥĥ쥸 */
#define	PFCE9		0xFFFFF712		/* ݡ9ե󥯥󡦥ȥĥ쥸 */
#define	PFCE9L		0xFFFFF712		/* ݡ9ե󥯥󡦥ȥĥ쥸L */
#define	PFCE9H		0xFFFFF713		/* ݡ9ե󥯥󡦥ȥĥ쥸H */
#define	SYS			0xFFFFF802		/* ƥࡦơ쥸 */
#define	RCM			0xFFFFF80C		/* OSC⡼ɡ쥸 */
#define	DTFR0		0xFFFFF810		/* DMAȥꥬװ쥸0 */
#define	DTFR1		0xFFFFF812		/* DMAȥꥬװ쥸1 */
#define	DTFR2		0xFFFFF814		/* DMAȥꥬװ쥸2 */
#define	DTFR3		0xFFFFF816		/* DMAȥꥬװ쥸3 */
#define	PSMR		0xFFFFF820		/* ѥ֡⡼ɡ쥸 */
#define	CKC			0xFFFFF822		/* åȥ롦쥸 */
#define	LOCKR		0xFFFFF824		/* å쥸 */
#define	PCC			0xFFFFF828		/* ץååȥ롦쥸 */
#define	PLLCTL		0xFFFFF82C		/* PLLȥ롦쥸 */
#define	CCLS		0xFFFFF82E		/* CPUưåơ쥸 */
#define	CORAD0		0xFFFFF840		/* 쥯󡦥ɥ쥹쥸0 */
#define	CORAD0L		0xFFFFF840		/* 쥯󡦥ɥ쥹쥸0L */
#define	CORAD0H		0xFFFFF842		/* 쥯󡦥ɥ쥹쥸0H */
#define	CORAD1		0xFFFFF844		/* 쥯󡦥ɥ쥹쥸1 */
#define	CORAD1L		0xFFFFF844		/* 쥯󡦥ɥ쥹쥸1L */
#define	CORAD1H		0xFFFFF846		/* 쥯󡦥ɥ쥹쥸1H */
#define	CORAD2		0xFFFFF848		/* 쥯󡦥ɥ쥹쥸2 */
#define	CORAD2L		0xFFFFF848		/* 쥯󡦥ɥ쥹쥸2L */
#define	CORAD2H		0xFFFFF84A		/* 쥯󡦥ɥ쥹쥸2H */
#define	CORAD3		0xFFFFF84C		/* 쥯󡦥ɥ쥹쥸3 */
#define	CORAD3L		0xFFFFF84C		/* 쥯󡦥ɥ쥹쥸3L */
#define	CORAD3H		0xFFFFF84E		/* 쥯󡦥ɥ쥹쥸3H */
#define	CLM			0xFFFFF870		/* å˥⡼ɡ쥸 */
#define	CORCN		0xFFFFF880		/* 쥯󡦥ȥ롦쥸 */
#define	RESF		0xFFFFF888		/* ꥻåװե饰쥸 */
#define	LVIM		0xFFFFF890		/* ŰХ쥸 */
#define	LVIS		0xFFFFF891		/* ŰХ٥쥸 */
#define	RAMS		0xFFFFF892		/* ¢RAMǡơ쥸 */
#define	PRSM0		0xFFFFF8B0		/* ץꥹ顦⡼ɡ쥸 */
#define	PRSCM0		0xFFFFF8B1		/* ץꥹ顦ڥ쥸 */
#define	OCDM		0xFFFFF9FC		/* åסǥХ⡼ɡ쥸 */
#define	PEMU1		0xFFFFF9FE		/* եߥ졼󡦥쥸1 */
#define	UA0CTL0		0xFFFFFA00		/* UARTA0쥸0 */
#define	UA0CTL1		0xFFFFFA01		/* UARTA0쥸1 */
#define	UA0CTL2		0xFFFFFA02		/* UARTA0쥸2 */
#define	UA0OPT0		0xFFFFFA03		/* UARTA0ץ쥸0 */
#define	UA0STR		0xFFFFFA04		/* UARTA0֥쥸 */
#define	UA0RX		0xFFFFFA06		/* UARTA0ǡ쥸 */
#define	UA0TX		0xFFFFFA07		/* UARTA0ǡ쥸 */
#define	UA1CTL0		0xFFFFFA10		/* UARTA1쥸0 */
#define	UA1CTL1		0xFFFFFA11		/* UARTA1쥸1 */
#define	UA1CTL2		0xFFFFFA12		/* UARTA1쥸2 */
#define	UA1OPT0		0xFFFFFA13		/* UARTA1ץ쥸0 */
#define	UA1STR		0xFFFFFA14		/* UARTA1֥쥸 */
#define	UA1RX		0xFFFFFA16		/* UARTA1ǡ쥸 */
#define	UA1TX		0xFFFFFA17		/* UARTA1ǡ쥸 */
#define	UA2CTL0		0xFFFFFA20		/* UARTA2쥸0 */
#define	UA2CTL1		0xFFFFFA21		/* UARTA2쥸1 */
#define	UA2CTL2		0xFFFFFA22		/* UARTA2쥸2 */
#define	UA2OPT0		0xFFFFFA23		/* UARTA2ץ쥸0 */
#define	UA2STR		0xFFFFFA24		/* UARTA2֥쥸 */
#define	UA2RX		0xFFFFFA26		/* UARTA2ǡ쥸 */
#define	UA2TX		0xFFFFFA27		/* UARTA2ǡ쥸 */
#define	INTF0		0xFFFFFC00		/* Ωꥨå쥸0 */
#define	INTF3		0xFFFFFC06		/* Ωꥨå쥸3 */
#define	INTF9H		0xFFFFFC13		/* Ωꥨå쥸9H */
#define	INTR0		0xFFFFFC20		/* Ω夬ꥨå쥸0 */
#define	INTR3		0xFFFFFC26		/* Ω夬ꥨå쥸3 */
#define	INTR9H		0xFFFFFC33		/* Ω夬ꥨå쥸9H */
#define	PF0			0xFFFFFC60		/* ݡ0ե󥯥쥸 */
#define	PF3			0xFFFFFC66		/* ݡ3ե󥯥쥸 */
#define	PF3L		0xFFFFFC66		/* ݡ3ե󥯥쥸L */
#define	PF3H		0xFFFFFC67		/* ݡ3ե󥯥쥸H */
#define	PF4			0xFFFFFC68		/* ݡ4ե󥯥쥸 */
#define	PF5			0xFFFFFC6A		/* ݡ5ե󥯥쥸 */
#define	PF9			0xFFFFFC72		/* ݡ9ե󥯥쥸 */
#define	PF9L		0xFFFFFC72		/* ݡ9ե󥯥쥸L */
#define	PF9H		0xFFFFFC73		/* ݡ9ե󥯥쥸H */
#define	CB0CTL0		0xFFFFFD00		/* CSIB0쥸0 */
#define	CB0CTL1		0xFFFFFD01		/* CSIB0쥸1 */
#define	CB0CTL2		0xFFFFFD02		/* CSIB0쥸2 */
#define	CB0STR		0xFFFFFD03		/* CSIB0֥쥸 */
#define	CB0RX		0xFFFFFD04		/* CSIB0ǡ쥸 */
#define	CB0RXL		0xFFFFFD04		/* CSIB0ǡ쥸L */
#define	CB0TX		0xFFFFFD06		/* CSIB0ǡ쥸 */
#define	CB0TXL		0xFFFFFD06		/* CSIB0ǡ쥸L */
#define	CB1CTL0		0xFFFFFD10		/* CSIB1쥸0 */
#define	CB1CTL1		0xFFFFFD11		/* CSIB1쥸1 */
#define	CB1CTL2		0xFFFFFD12		/* CSIB1쥸2 */
#define	CB1STR		0xFFFFFD13		/* CSIB1֥쥸 */
#define	CB1RX		0xFFFFFD14		/* CSIB1ǡ쥸 */
#define	CB1RXL		0xFFFFFD14		/* CSIB1ǡ쥸L */
#define	CB1TX		0xFFFFFD16		/* CSIB1ǡ쥸 */
#define	CB1TXL		0xFFFFFD16		/* CSIB1ǡ쥸L */
#define	CB2CTL0		0xFFFFFD20		/* CSIB2쥸0 */
#define	CB2CTL1		0xFFFFFD21		/* CSIB2쥸1 */
#define	CB2CTL2		0xFFFFFD22		/* CSIB2쥸2 */
#define	CB2STR		0xFFFFFD23		/* CSIB2֥쥸 */
#define	CB2RX		0xFFFFFD24		/* CSIB2ǡ쥸 */
#define	CB2RXL		0xFFFFFD24		/* CSIB2ǡ쥸L */
#define	CB2TX		0xFFFFFD26		/* CSIB2ǡ쥸 */
#define	CB2TXL		0xFFFFFD26		/* CSIB2ǡ쥸L */
#define	CB3CTL0		0xFFFFFD30		/* CSIB3쥸0 */
#define	CB3CTL1		0xFFFFFD31		/* CSIB3쥸1 */
#define	CB3CTL2		0xFFFFFD32		/* CSIB3쥸2 */
#define	CB3STR		0xFFFFFD33		/* CSIB3֥쥸 */
#define	CB3RX		0xFFFFFD34		/* CSIB3ǡ쥸 */
#define	CB3RXL		0xFFFFFD34		/* CSIB3ǡ쥸L */
#define	CB3TX		0xFFFFFD36		/* CSIB3ǡ쥸 */
#define	CB3TXL		0xFFFFFD36		/* CSIB3ǡ쥸L */
#define	CB4CTL0		0xFFFFFD40		/* CSIB4쥸0 */
#define	CB4CTL1		0xFFFFFD41		/* CSIB4쥸1 */
#define	CB4CTL2		0xFFFFFD42		/* CSIB4쥸2 */
#define	CB4STR		0xFFFFFD43		/* CSIB4֥쥸 */
#define	CB4RX		0xFFFFFD44		/* CSIB4ǡ쥸 */
#define	CB4RXL		0xFFFFFD44		/* CSIB4ǡ쥸L */
#define	CB4TX		0xFFFFFD46		/* CSIB4ǡ쥸 */
#define	CB4TXL		0xFFFFFD46		/* CSIB4ǡ쥸L */
#define	IIC0		0xFFFFFD80		/* IICեȡ쥸0 */
#define	IICC0		0xFFFFFD82		/* IICȥ롦쥸0 */
#define	SVA0		0xFFFFFD83		/* 졼֡ɥ쥹쥸0 */
#define	IICCL0		0xFFFFFD84		/* IICå쥸0 */
#define	IICX0		0xFFFFFD85		/* IICǽĥ쥸0 */
#define	IICS0		0xFFFFFD86		/* IIC֥쥸0 */
#define	IICF0		0xFFFFFD8A		/* IICե饰쥸0 */
#define	IIC1		0xFFFFFD90		/* IICեȡ쥸1 */
#define	IICC1		0xFFFFFD92		/* IICȥ롦쥸1 */
#define	SVA1		0xFFFFFD93		/* IIC졼֡ɥ쥹쥸1 */
#define	IICCL1		0xFFFFFD94		/* IICå쥸1 */
#define	IICX1		0xFFFFFD95		/* IICǽĥ쥸1 */
#define	IICS1		0xFFFFFD96		/* IIC֥쥸1 */
#define	IICF1		0xFFFFFD9A		/* IICե饰쥸1 */
#define	IIC2		0xFFFFFDA0		/* IICեȡ쥸2 */
#define	IICC2		0xFFFFFDA2		/* IICȥ롦쥸2 */
#define	SVA2		0xFFFFFDA3		/* IIC졼֡ɥ쥹쥸2 */
#define	IICCL2		0xFFFFFDA4		/* IICå쥸2 */
#define	IICX2		0xFFFFFDA5		/* IICǽĥ쥸2 */
#define	IICS2		0xFFFFFDA6		/* IIC֥쥸2 */
#define	IICF2		0xFFFFFDAA		/* IICե饰쥸2 */
#define	EXIMC		0xFFFFFFBE		/* Х󥿥ե⡼ɡȥ롦쥸 */

#endif	/* _V850ES_SG2_H_ */
