/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2005 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */

/*
 *  ȯĶ˰¸
 */

#ifndef _TOOL_DEFS_H_
#define _TOOL_DEFS_H_

/*
 *  ѥ¸Υǡ
 */
#define _int8_      char        /* 8ӥåȤ */
#define _int16_     short       /* 16ӥåȤ */
#define _int32_     long        /* 32ӥåȤ */
#define _int64_     long long   /* 64ӥåȤ */
#define _intptr_    int         /* ݥ󥿤ǼǤ */

/*
 *  ѥγĥǽΤΥޥ
 */
#ifndef __cplusplus             /* C++ ˤ inline  */
#if __STDC_VERSION__ < 199901L  /* C99 ˤ inline  */
#define inline  __inline__
#endif /* __STDC_VERSION__ < 199901L */
#endif /* __cplusplus */

#define Inline      static inline

#ifndef __cplusplus         /* C++ ˤ asm  */
#define asm     __asm__
#endif /* __cplusplus */

#define Asm     __asm__ volatile

/*
 *  .init/.finiؤδؿϿΤΥޥ
 */
#define REGISTER_INIT_ROUTINE( function ) \
    __asm__( ".section .init,\"ax\"" ) ; \
    __asm__( "callf " #function ) ; \
    __asm__( ".text" ) ;
#define REGISTER_FINI_ROUTINE( function ) \
    __asm__( ".section .fini,\"ax\"" ) ; \
    __asm__( "callf " #function ) ; \
    __asm__( ".text" ) ;

#endif /* _TOOL_DEFS_H_ */
