/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */

#ifndef _TL16PIR552_H_
#define _TL16PIR552_H_

#include <s_services.h>		/* ǥХɥ饤ɸ।󥯥롼ɥե */

/*
 *  ꥢ롿ѥ I/O TL16PIR552(TI) Ϣ
 */
/* TL16PIR552Υ쥸Υɥ쥹 */
#define RBR	0x00	/* Receiver Buffer (ɤ߽Ф) */
#define THR	0x00	/* Transmitter Holding Register (񤭽Ф) */
#define DLL	0x00	/* Divisor Latch (LSB) */
#define IER	0x10	/* Interrupt-Enable Register */
#define DLM	0x10	/* Divisor Latch (MSB) */
#define	IIR	0x20	/* Interrupt-Ident Register (ɤ߽Ф) */
#define	FCR	0x20	/* FIFO Control Register (񤭽Ф) */
#define	LCR	0x30	/* Line-Control Register */
#define	MCR	0x40	/* Modem-Control Register */
#define	LSR	0x50	/* Line-Status Register */
#define	MSR	0x60	/* Modem-Status Register */
#define	SCR	0x70	/* Scratch Register */

/* for LCR */
#define	WORD_LENGTH_8		(BIT1 | BIT0)
#define	STOP_BITS_1		0u		/* BIT2 */
#define	PARITY_NON		0u		/* BIT3, 4 */
/* BIT5,6 ά */
#define	DIVISOR_LATCH_ACC	BIT7

/* for IER */
#define	DIS_INT			0u
#define	RECEIVE_DATA_AVAILABLE	BIT0
#define	TRANS_REG_EMPTY		BIT1
#define RECEIVE_LINE_STATUS	BIT2
#define MODEM_STATUS		BIT3

/* for MCR */
#define	DTR			BIT0
#define	RTS			BIT1
#define	ENABLE_EXT_INT		BIT3
#define	AUTOFLOW_CONTROL	BIT5

/* for FCR */
#define	FIFO_ENABLE		BIT0
#define	RECEIVE_FIFO_RESET	BIT1
#define	TRANS_FIFO_RESET	BIT2
#define RECEIVE_TRIG_1_BYTE	0u		/* BIT6, 7 */
#define RECEIVE_TRIG_4_BYTE	BIT6
#define	RECEIVE_TRIG_8_BYTE	BIT7
#define	RECEIVE_TRIG_14_BYTE	(BIT6 | BIT7)

/* for IIR */
#define	INT_MASK		0x0f
#define	INT_RECEIVE_DATA	BIT2
#define INT_CHAR_TIME_OUT	(BIT3 | BIT2)
#define	INT_TRANS_EMPTY		BIT1

/* for LSR */
#define	THRE			BIT5
#define TEMT			BIT6

/* ܡ졼ط */
#define	PRE_DIVISOR	4
#define	DIVISOR		XIN_CLOCK / (8 * DEVIDE_RATIO * PRE_DIVISOR)

#ifndef _MACRO_ONLY

/*
 *  ꥢI/Oݡȴ֥å
 */
typedef struct sio_port_control_block	SIOPCB;

#endif /* _MACRO_ONLY */

/*
 *  SIOѥƥ।󥿥ե쥤䡼
 */
/* x : ݡȤΥ١ɥ쥹y : 쥸եåȡz : 쥸 */
#define tl16pir552_wrb( x, y, z )	sil_wrb_mem( (VP)(x + y), z )
#define tl16pir552_reb( x, y )		sil_reb_mem( (VP)(x + y) )

/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND	1u		/* ǽХå */
#define SIO_ERDY_RCV	2u		/* ΥХå */

#ifndef _MACRO_ONLY

/*
 *  SIOɥ饤Фν롼
 */
extern void	tl16pir552_initialize(void);

/*
 *  ץ󤷤ƤݡȤ뤫
 */
extern BOOL	tl16pir552_openflag(void);

/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB	*tl16pir552_opn_por(ID siopid, VP_INT exinf);

/*
 *  ꥢI/OݡȤΥ
 */
extern void	tl16pir552_cls_por(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤؤʸ
 */
extern BOOL	tl16pir552_snd_chr(SIOPCB *siopcb, char c);

/*
 *  ꥢI/OݡȤʸ
 */
extern INT	tl16pir552_rcv_chr(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤΥХåε
 */
extern void	tl16pir552_ena_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void	tl16pir552_dis_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  SIOγߥӥ롼
 */
extern void	tl16pir552_uart0_isr(void);
extern void	tl16pir552_uart1_isr(void);

/*
 *  ꥢI/OݡȤǽХå
 */
extern void	tl16pir552_ierdy_snd(VP_INT exinf);

/*
 *  ꥢI/OݡȤμΥХå
 */
extern void	tl16pir552_ierdy_rcv(VP_INT exinf);

/*
 *  ͥ뵯ưѤν (sys_putc)
 */
extern void	tl16pir552_init(void);

/*
 *  ꥢI/OݡȤؤʸʥݡ󥰡
 */
extern void	tl16pir552_putchar_pol(char c);

#endif /* _MACRO_ONLY */
#endif /* _TL16PIR552_H_ */
