#! /usr/bin/perl
#
#  TOPPERS/JSP Kernel
#      Toyohashi Open Platform for Embedded Real-Time Systems/
#      Just Standard Profile Kernel
# 
#  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
#                              Toyohashi Univ. of Technology, JAPAN
#  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
#              Graduate School of Information Science, Nagoya Univ., JAPAN
#  Copyright (C) 2005-2007 by Industrial Technology Institute,
#                              Miyagi Prefectural Government, JAPAN
# 
#  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
#  ˤäƸɽƤ GNU General Public License  Version 2 ˵
#  ҤƤ˸¤ꡤܥեȥܥեȥ
#  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
#  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
#  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
#      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
#      ˴ޤޤƤ뤳ȡ
#  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
#      ѤǤǺۤˤϡۤȼɥȡ
#      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
#      ̵ݾڵǺܤ뤳ȡ
#  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
#      ѤǤʤǺۤˤϡΤ줫ξ
#      ȡ
#    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
#        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
#    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
#        𤹤뤳ȡ
#  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
#      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
# 
#  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
#  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
#  ޤơʤݾڤԤʤޤܥեȥѤˤľ
#  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
# 
#  @(#) $Id: genvector.pl,v 1.5 2007/03/23 07:19:00 honda Exp $
# 


#
#  ٥ơ֥ץ
#  make dependtmp_script.plɤ߹ळȤˤä
#  ¹ԤǤ褦ˤʤ

#  ץ
#
#  -s <vector size>	٥ơ֥Υ
#  -z 		ϿƤʤߥ٥ˤ0񤭹
#		-zץꤷʤϡ_no_reg_expretion
#		񤭹
#		¹ԴĶMakefileƤDBGENVޥ͡ˤ
#		˥λͤˤꡢɬפ˱Ѥ


require "getopt.pl";


#
#  ߥϥɥ٥ơ֥Ͽ
# tmp_script.pl⤫ƤФ롣

sub define_inh {
	my($inhno, $inthdr) = @_;
	
	if ($inhno == 0) {
		print STDERR <<ERRMESSAGE
In generating vector.S
Error in DEF_INH($inhno, {TA_HLNG, $inthdr});
\t Macro of interrupt handler number $inhno isn't defined.
\t If you define macro $inhno in header files,
\t it's necessary to use "#include" directive in configuration files
\t to genarate vector.S. 
\t (And it's also necessary to use static API "INCLUDE()" 
\t in configuration files to genarate kernel_cfg.c. )
\t Check configuration files and header files.

ERRMESSAGE
		;
		exit(1);
	}
	else {
		# ٥ơ֥˳ߥϥɥϿ
		# ߥϥɥ̾"__kernel_""_entry"ղ
		$vector_table[$inhno] = "__kernel_" . $inthdr . "_entry";
	}
}	


#
#  ץν
#
do Getopt("s");

if ($opt_s == 0) {
	print STDERR "genvector.pl:\n";
	print STDERR "\t -s option(vector size) is necessary.\n";
	print STDERR "\t check jsp/config/h8/\$(SYS)/Makefile.config\n";
	exit(1);
}
	
$vector_size = $opt_s;

# ¹ԴĶˤäơ̤Ͽγ߽εҤڤʬ
if ($opt_z) {
	$no_reg_exception = "0";
}
else {
	$no_reg_exception = "_no_reg_exception";
}

for ($i=0; $i<$vector_size; $i++) {
	$vector_table[$i]=$no_reg_exception;
}

# ꥻåȥ٥
$vector_table[0] = "_start";

# ư줿ץȤɤ߹
require "./tmp_script.pl";

# ٥ơ֥ν
for ($i=0; $i<$vector_size; $i++) {
	printf "\t.long %s\t\t/* %d(0x%02x) */\n", $vector_table[$i], $i, $i;
}

