/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: kernellog.h,v 1.2 2003/12/20 09:19:59 takayuki Exp $
 */

// KernelLog.h : CKernelLog 

#ifndef __KERNELLOG_H_
#define __KERNELLOG_H_

#include "resource.h"       // ᥤ ܥ
#include "devicemanagerCP.h"

/////////////////////////////////////////////////////////////////////////////
// CKernelLog
class ATL_NO_VTABLE CKernelLog : 
    public CComObjectRootEx<CComSingleThreadModel>,
    public CComCoClass<CKernelLog, &CLSID_KernelLog>,
    public IConnectionPointContainerImpl<CKernelLog>,
    public IKernelLog,
    public CProxy_IKernelLogEvents< CKernelLog >
{
public:
    CKernelLog();
    ~CKernelLog();

DECLARE_REGISTRY_RESOURCEID(IDR_KERNELLOG)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CKernelLog)
    COM_INTERFACE_ENTRY(IKernelLog)
    COM_INTERFACE_ENTRY(IConnectionPointContainer)
    COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()
BEGIN_CONNECTION_POINT_MAP(CKernelLog)
CONNECTION_POINT_ENTRY(IID__IKernelLogEvents)
END_CONNECTION_POINT_MAP()


// IKernelLog
public:
};

#endif //__KERNELLOG_H_



#if 0

template <class T>
class CProxy_IKernelLogEvents : public IConnectionPointImpl<T, &IID__IKernelLogEvents, CComDynamicUnkArray>
{
public:
    bool onKernelStart_Performed;

    CProxy_IKernelLogEvents(void) : onKernelStart_Performed(false) {};

    //Warning this class may be recreated by the wizard.
public:
    HRESULT Fire_OnKernelStart()
    {
        HRESULT ret;
        T* pT = static_cast<T*>(this);
        int nConnectionIndex;
        int nConnections = m_vec.GetSize();
        
        for (nConnectionIndex = 0; nConnectionIndex < nConnections; nConnectionIndex++)
        {
            pT->Lock();
            CComPtr<IUnknown> sp = m_vec.GetAt(nConnectionIndex);
            pT->Unlock();
            _IKernelLogEvents* p_IKernelLogEvents = reinterpret_cast<_IKernelLogEvents*>(sp.p);
            if (p_IKernelLogEvents != NULL)
                ret = p_IKernelLogEvents->OnKernelStart();
        }
        onKernelStart_Performed = true;
        return ret;
    }

    HRESULT Fire_OnKernelExit()
    {
        HRESULT ret;
        T* pT = static_cast<T*>(this);
        int nConnectionIndex;
        int nConnections = m_vec.GetSize();
        
        for (nConnectionIndex = 0; nConnectionIndex < nConnections; nConnectionIndex++)
        {
            pT->Lock();
            CComPtr<IUnknown> sp = m_vec.GetAt(nConnectionIndex);
            pT->Unlock();
            _IKernelLogEvents* p_IKernelLogEvents = reinterpret_cast<_IKernelLogEvents*>(sp.p);
            if (p_IKernelLogEvents != NULL)
                ret = p_IKernelLogEvents->OnKernelExit();
        }
        onKernelStart_Performed = false;    
        return ret;
    }

    HRESULT Fire_OnLogEvent(LONG sz, unsigned char * data)
    {
        HRESULT ret;
        T* pT = static_cast<T*>(this);
        int nConnectionIndex;
        int nConnections = m_vec.GetSize();
        
        for (nConnectionIndex = 0; nConnectionIndex < nConnections; nConnectionIndex++)
        {
            pT->Lock();
            CComPtr<IUnknown> sp = m_vec.GetAt(nConnectionIndex);
            pT->Unlock();
            _IKernelLogEvents* p_IKernelLogEvents = reinterpret_cast<_IKernelLogEvents*>(sp.p);
            if (p_IKernelLogEvents != NULL)
            {
                if(!onKernelStart_Performed)
                    p_IKernelLogEvents->OnKernelStart();
                ret = p_IKernelLogEvents->OnLogEvent(sz, data);
            }
        }
        onKernelStart_Performed = true; 
        return ret; 
    }
};
#endif