/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                2003      by Advanced Data Controls, Corp
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_sysio.h,v 1.5 2003/12/24 07:24:40 honda Exp $
 */

#ifndef _HW_SYSIO_H_
#define _HW_SYSIO_H_


#include "integrator.h"

/*
 *  ꥢI/OݡȤν
 */
Inline void
hw_sysio_initialize()
{
    /*disable interrupt*/
    sil_wrw_mem((VP)UART0_CR,~UCR_UARTEN);
    /*baud rate 38400*/
    sil_wrw_mem((VP)UART0_LCRM,ULCRM_38400);
    sil_wrw_mem((VP)UART0_LCRL,ULCRL_38400);
    /*8bits, 1Stop bit, no parity*/
    sil_wrw_mem((VP)UART0_LCRH,ULCRH_WLEN_8BIT);
    /*Clear all registers*/
    sil_wrw_mem((VP)UART0_ICR,0xff);
    /*enable interrupt*/
    sil_wrw_mem((VP)UART0_CR,UCR_UARTEN | UCR_RIE);
}


/*
 *  ꥢI/OݡȤνλ
 */
Inline void
hw_sysio_terminate()
{
    /*disable interrupt*/
    sil_wrw_mem((VP)UART0_CR,~UCR_UARTEN);
}


/*
 *  ʸǤ뤫
 */
Inline BOOL
hw_sysio_putready()
{
    return((sil_rew_mem((VP)UART0_FR) & UFR_BUSY)==0);
}


/*
 *  ʸν񤭹
 */
Inline void
hw_sysio_putchar(UB c)
{
    while(!hw_sysio_putready())
        ;
    sil_wrw_mem((VP)UART0_DR,c);
}

#endif /* _HW_SYSIO_H_ */
