/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_support.S,v 1.17 2007/03/23 07:22:15 honda Exp $
 */

/*
 *	ץå¸⥸塼 ֥H8ѡ
 */

#define _MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"

/*
 *  NMI٤Ƥγߤػ
 */
#define DISINT	orc.b  #H8INT_DIS_ALL, ccr

/*
 *  ٤Ƥγߤ
 */
#define ENAINT	andc.b #H8INT_ENA_ALL, ccr


	.h8300h

	.text
	.align 2

/*
 *  ǥѥå
 *
 *    _dispatch ϡ߳ͥȥ = 0,߶ػ߾
 *    ǸƤӽФʤФʤʤexit_and_dispatch ⡤ߥͥ
 *     = 0߶ػ߾֤ǸƤӽФΤ§Ǥ뤬ͥ
 *    ưб뤿ᡤߥͥȥ = 1ǸƤӽФ
 *    бƤ롥
 */

	.global _dispatch
_dispatch:
	push.l	er4			/*  er46¸		*/
	push.l	er5
	push.l	er6
	mov.l	@_runtsk, er0		/* er0 <- runtsk		*/
	mov.l	sp, @(TCB_sp, er0)	/* åݥ󥿤¸	*/
	mov.l	#dispatch_r, er1	/* ¹ԺƳ			*/
	mov.l	er1, @(TCB_pc, er0)
	bra     dispatcher

dispatch_r:
	pop.l	er6			/*  er46		*/
	pop.l	er5
	pop.l	er4
	mov.l	@_runtsk, er0
	mov.b	@(TCB_enatex, er0), r1l	/* runtsk->enatex Υå	*/
	btst	#TCB_enatex_bit, r1l
	beq	dispatch_r_1
	mov.l	@(TCB_texptn, er0), er1	/* runtsk->texptn Υå	*/
	beq	dispatch_r_1
	jmp	@_call_texrtn

dispatch_r_1:
	rts			/*  dispatch()θƤӽФإ꥿  */

	.global	_exit_and_dispatch
_exit_and_dispatch:
	/* ߶ػߤǸƤФ */
        mov.b   #0, r0l         	/* ߥͥȥ󥿤򥯥ꥢ	*/
        mov.b   r0l, @_intnest

/*  
 *ǥѥåƥ
 */
dispatcher:
	/*
	 * ˤϳ߶ػߤ뤳
	 */

	/*
	 * runtskschedtskΤϣĤΰ̣롣
	 * (1) schedtsk != NULLξ
	 * ̾ΥڤؤԤ
	 * (2) schedtsk == NULLξ
	 * runtskNULLƤ
	 * dispatcher_1ʹߤγԤǳߤꡢ
	 * iget_tid()뤵줿ȤTSK_NONE֤
	 * ˤϡ¹Ծ֤ΥʤˡruntskNULLˤ
	 * ɬפ롣
	 */
	mov.l	@_schedtsk, er0		/* er0 <- schedtsk		*/
	mov.l	er0, @_runtsk		/* schedtskruntsk		*/
			/*  ¹Ԥ٤ʤСԤʬ  */
	beq	dispatcher_1
	mov.l	@(TCB_sp, er0), sp
	mov.l	@(TCB_pc, er0), er0	/* ¹ԺƳϤ		*/
	jmp	@er0


	/*
	 *  ¹Ԥ٤ʤγԤ
	 *  
	 *  ǳߥ⡼ɤڤ괹Τϡȯ߽
	 *  ˤɤΥåȤȤβȡߥϥɥ
	 *  ΥǥѥåɻߤȤĤΰ̣롥
	 */
dispatcher_1:
	    			/* åߥåؤ	*/
	mov.l	#STACKTOP, sp
				/*  ߥͥȥ󥿤򣱤ˤ	*/
        mov.b   #1, r0l
        mov.b   r0l, @_intnest

	/*
	 * r1lߵĻccrꤹ
	 *ߥϥɥǤchg_ipmѤǤʤΤǡ
	 *task_intmask1ɤ߹ǤСOK
	 */
#ifdef SUPPORT_CHG_IPM
        mov.b     @_task_intmask, r1l
#else	/* SUPPORT_CHG_IPM */
        mov.b     #H8INT_ENA_ALL, r1l
#endif	/* SUPPORT_CHG_IPM */

	/* CPUåե饰򥯥ꥢ */
	sub.l	er0, er0
        mov.l   er0, @_iscpulocked


dispatcher_2_enable_interrupt:
        /*
         *ldc̿ľϳ߶ػߤǤꡢ׵᤬äƤ
         *̿᤬¹Ԥ롣
         *ʳߤäƤsleep륱Ϥʤ
         */
        ldc.b     r1l, ccr              /* ߵ */
        sleep                           /* Ԥ */
        DISINT                          /* ߶ػ */

	mov.l   @_reqflg, er0           /* reqflgΥå */
			/* reqflgBOOL -> int(32bits) */
		/*  reqflg==NULLʤС⤦1ٳԤ  */
	beq     dispatcher_2_enable_interrupt
	sub.l	er0, er0
	mov.l   er0, @_reqflg		/* reqflgΥꥢ */
			/* ߥͥȥ󥿤򥯥ꥢ	*/
	mov.b   r0l, @_intnest
	bra	dispatcher

/*
 *
 *  ߥϥɥ
 *װ˰ͤ餺̤ʬ
 *cpu_config.hINTHDR_ENTRY³
 *
 *ʲξ֤ǤˤäƤ
 *߶ػ
 *er0er3Ѥ
 *er2C롼Ƭɥ쥹
 *r3lߵĻ˳ߥޥꤹ
 */
        .global _common_interrupt_process
_common_interrupt_process:
	push.l	er4			/*  Ŭкer4  */
        mov.b   @_intnest, r0l          /* ߥͥȥ󥿤Υå */
        bne     _interrupt_from_int     /*  intnet0ǤʤС*/
        				/*  ¿ųߤν  */

        /*
         *ʤγߤξ
         */
        mov.b   #1, r1l                 /* ߥͥȥ󥿢 */
        mov.b   r1l, @_intnest
        mov.l   sp, er0
        mov.l   #STACKTOP, sp           /* å */
        push.l  er0                     /* åݥ󥿤 */
        ldc.b   r3l, ccr                /* ߵ */
        jsr     @er2                    /* C롼ƤӽФ */
        DISINT                          /* ߶ػ */
        mov.b   #0, r0l                 /* ߥͥȥ󥿤Υꥢ */
        mov.b   r0l, @_intnest
        mov.l   @sp, sp                 /* å */
        mov.l   @_reqflg, er0           /* reqflgΥå */
        beq     _ret_to_task_int        /* reqflgFALSEʤ */
        				/* ret_to_task_int */
        sub.l	er0, er0
        mov.l   er0, @_reqflg           /* reqflg򥯥ꥢ */
        bra     ret_int                 /* иإ */

        /*
         *¿ųߤξ
         *߶ػߤǤˤäƤ
         *
         *ߥͥȥ󥿤Υ󥯥Ȥϰʲͳ
         *άƤ
         *ߤ2٥뤷ʤ
         *CPU㳰򥵥ݡȤʤ
         *exc_sense_context()ΤȤθʤƤɤ
         */
_interrupt_from_int:
        /* ߥͥȥ󥿤Υ󥯥ȤϾά */
        ldc.b   r3l, ccr                /* ߵ */
        jsr     @er2                    /* C롼ƤӽФ */
        DISINT                          /* ߶ػ */
        /* ߥͥȥ󥿤ΥǥȤϾά */

        /*
         *Ϥ褬Ԥsleep̿ᤫɤΥ
         *ɬפǤ롣ʤ⤷ߥϥɥreqflg=TRUEˤ
         *ǥѥå㤬ƤФʤ᥿¹Ԥʤ
         *H8ξ硢sleep̿ľˤߵĤldc̿μ¹ľ
         *ϳ߶ػߤǤꡢ׵᤬äȤƤߤϼ
         *դʤǡsleep̿᤬¹Ԥ롣Τᡢߤ
         *äľsleep̿᤬¹Ԥ륱Ϲθʤɤ
         */

        /*
         *ǥѥåƤФˡ߸
         */
_ret_to_task_int:
					/* 쥸 */
	pop.l	er4			/*  er4ϺŬк  */
        pop.l   er3
        pop.l   er2
        pop.l   er1
        pop.l   er0
        rte                             /* ߸إ꥿ */

/*
 * иˤƥåݥ󥿤ؤƤϤCCR쥸
 * ѤޤƤϤޤǤΥեåȤ
 *
 * +0:er4
 * +4:er3
 * +8:er2
 *+12:er1
 *+16:er0
 *  +20:ccr spХ
 */
#define OFFSET_CCR	20

/*
 *  ߥϥɥи
 *
 * 褬reqflgåȤƤΤߤˤ롣
 * ߥͥȥ = 0,߶ػ߾,å쥸
 * ¸֤ǸƤӽФȡ
 *
 */

ret_int:
	mov.l	@_enadsp, er0		/* enadspΥå		*/
	beq	ret_int_1	/* ǥѥåػߤʤret_int_1	*/

	mov.l	@_runtsk, er0		/* er0 <- runtsk		*/
	mov.l	@_schedtsk, er1		/* er1 <- schedtsk		*/
	cmp.l	er0, er1		/* runtsk  schedtsk 	*/
	beq	ret_int_1		/* Ʊʤret_int_1		*/

        push.l  er5                     /* 쥸 */
        push.l  er6

	mov.l	sp, @(TCB_sp, e0)	/* åݥ󥿤¸	*/
	mov.l	#ret_int_r, er1  	/* ¹ԺƳ			*/
	mov.l	er1, @(TCB_pc, er0)
	bra	dispatcher:16
		/*  8ӥåPCʬǤϤʤᡢ16ӥåȻ  */

/*
 *  ߤνиǥǥѥå㤫餳äƤ
 */
ret_int_r:
        pop.l   er6                     /* 쥸 */
        pop.l   er5

        /*
         *åʤϤή
         */
ret_int_1:
					/*  㳰ľ֤Υå */
	mov.l	@_runtsk, er0
	mov.b	@(TCB_enatex, er0), r1l
	btst	#TCB_enatex_bit, r1l	/*  TCB.enatex=0 -> CCR.Z=1  */
	beq	ret_int_2	/*  㳰ػ߾֤ʤ饸  */
	
					/*  㳰׵Υå */
	mov.l	@(TCB_texptn, er0), er1
	beq	ret_int_2	/*  㳰׵᤬ʤХ */
	jsr	@_call_texrtn		/* 㳰롼ư	*/

ret_int_2:
        /* CPUåե饰򥯥ꥢ */
        sub.l   er0, er0
        mov.l   er0, @_iscpulocked

#ifdef SUPPORT_CHG_IPM
        /*
         *  åѤǤccrγߥޥˤ
         *task_intmaskˤ롣ʲȡ
         */
        mov.b   @(OFFSET_CCR, sp), r0l
        mov.b   @_task_intmask, r1l
        and.b   #H8INT_ENA_ALL, r0l
        or.b    r1l, r0l
        mov.b   r0l, @(OFFSET_CCR, sp)
#endif 	/* SUPPORT_CHG_IPM */
                                        /* 쥸 */
        pop.l   er4                     /*  +0:er4 */
        pop.l   er3                     /*  +4:er3 */
        pop.l   er2                     /*  +8:er2 */
        pop.l   er1                     /* +12:er1 */
        pop.l   er0                     /* +16:er0 */
                                        /*   +20:ccr 񤭴 */
        rte


/*
 *  ư
 */

	.globl _activate_r
_activate_r:
        /* CPUåե饰򥯥ꥢ */
        sub.l   er0, er0
        mov.l   er0, @_iscpulocked

	/*  ߵ  */
#ifdef SUPPORT_CHG_IPM
        mov.b   @_task_intmask, r0l
        ldc.b   r0l, ccr
#else 	/* SUPPORT_CHG_IPM */
        ENAINT
#endif 	/* SUPPORT_CHG_IPM */

	mov.l	#_ext_tsk, er2
	push.l	er2
	mov.l	@_runtsk, er2
	mov.l	@(TCB_tinib, er2), er2
	mov.l	@(TINIB_task, er2), er1	/*  ư		*/
					/*  ĥʥؤΰ	*/
	mov.l	@(TINIB_exinf, er2), er0
	jmp	@er1


/**************************************************************
 *  ʲȤΥ󥿡եˤϴޤޤʤȼʬ
 **************************************************************/

/*
 *  no_reg_exception()
 *  CPU㳰ȤϿƤʤ㳰ȯȸƤӽФ롣
 *  㳰ȯPC,ER07Ϥƥͥ
 *  ߤ롣
 * 
 * å¤
 * +0:er0
 * +4:er1
 * +8:er2
 *+12:er3
 *+16:er4
 *+20:er5
 *+24:er6
 *+28:crr
 *+29:pc
 *+32:˻ѤƤåΰ
 */
	.globl _no_reg_exception
_no_reg_exception:

	push.l	er6		/*  ER06¸			*/
	push.l	er5
	push.l	er4
	push.l	er3
	push.l	er2
	push.l	er1
	push.l	er0

	mov.l	sp, er0		/*  				*/
				/*  SP  +32 ǡȯ		*/
	jsr	@_cpu_experr	/*  cpu_experr()θƤӽФ		*/

