/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

/*
 *	ꥢI/OǥХSIO˥ɥ饤СTI16PIR552ѡ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <tl16pir552.h>		/* siopcb, tl16pir552_openflag */

/*
 *  SIOγߥϥɥΥ٥ֹ
 */
#define INHNO_SIO1		INTNO_SERIAL0
#define INHNO_SIO2		INTNO_SERIAL1

/*
 *  SIOɥ饤Фν롼
 */
#define	sio_initialize		tl16pir552_initialize

/*
 *  ͥ뵯ưѤν (sys_putc)
 */
#define sio_init		tl16pir552_init

#ifndef _MACRO_ONLY

/*
 *  ꥢI/OݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;
	BOOL	openflag;

	UB	mask = 0;

	/*
	 *  ץ󤷤ݡȤ뤫 openflag ɤǤ
	 */
	openflag = tl16pir552_openflag();

	/*
	 *  ǥХ¸Υץ
	 */
	siopcb = tl16pir552_opn_por(siopid, exinf);

	/*
	 *  ꥢI/Oߤγߥ٥ꤷޥ롥
	 */
	if (!openflag) {
		switch(siopid) {
		case 1 :	/* ݡȣ; ꥢ룰 */
			all_set_ilv( INTNO_SERIAL0, &((IPM) IPM_SCC0) );
							/* ߥ٥ */
			mask = SERIAL0;
			break;
		case 2 :	/* ݡȣ; ꥢ룱 */
			all_set_ilv( INTNO_SERIAL1, &((IPM) IPM_SCC1) );
							/* ߥ٥ */
			mask = SERIAL1;
			break;
		}
		icu_orb( (VP) ICU_INT0M, mask );
							/* ޥ */
	}

	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  ǥХ¸Υ
	 */
	tl16pir552_cls_por(siopcb);

	/*
	 *  ꥢI/Oߤޥ롥(ݡȣξ)
	 */
	if (!tl16pir552_openflag) {
		icu_andb( (VP) ICU_INT0M, ~(SERIAL0 | SERIAL1) );
							/* ޥ */
	}
}

#endif /* _MACRO_ONLY */

/*
 *  SIOγߥϥɥ
 */
#define	sio1_handler		tl16pir552_uart0_isr
#if TNUM_SIOP >= 2
#define sio2_handler		tl16pir552_uart1_isr
#endif /* TNUM_SIOP */

/*
 *  ꥢI/OݡȤؤʸ
 */
#define	sio_snd_chr		tl16pir552_snd_chr

/*
 *  ꥢI/OݡȤؤʸʥݡ󥰡
 */
#define	sio_snd_chr_pol		tl16pir552_putchar_pol

/*
 *  ꥢI/OݡȤʸ
 */
#define	sio_rcv_chr		tl16pir552_rcv_chr

/*
 *  ꥢI/OݡȤΥХåε
 */
#define	sio_ena_cbr		tl16pir552_ena_cbr

/*
 *  ꥢI/OݡȤΥХåζػ
 */
#define	sio_dis_cbr		tl16pir552_dis_cbr

/*
 *  ꥢI/OݡȤǽХå
 */
#define	sio_ierdy_snd		tl16pir552_ierdy_snd

/*
 *  ꥢI/OݡȤμΥХå
 */
#define	sio_ierdy_rcv		tl16pir552_ierdy_rcv

#endif /* _HW_SERIAL_H_ */
