/* 
 *
 *  TOPPERS/JSP Kernel
 *     Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN  
 * 
 * 嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 * ˤäƸɽƤ GNU General Public License  Version 2 ˵
 * ҤƤ˸¤ꡤܥեȥܥեȥ
 * ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 * ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 * (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *     ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *     ˴ޤޤƤ뤳ȡ
 * (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *     ѤǤǺۤˤϡۤȼɥȡ
 *     ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *     ̵ݾڵǺܤ뤳ȡ
 * (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *     ѤǤʤǺۤˤϡΤ줫ξ
 *     ȡ
 *   (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *       ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *   (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *       𤹤뤳ȡ
 * (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *     ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 * ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 * TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 * ޤơʤݾڤԤʤޤܥեȥѤˤľ
 * ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: cpu_support.S,v 1.4 2005/07/06 01:48:21 honda Exp $
 */

#define _MACRO_ONLY

/*
 *  ץꥱȶ̤Υ󥯥롼ɥե
 */
#include <kernel.h>
/*
 *  åȰ¸
 */
#include <t_config.h>

#include "jsp_kernel.h"
#include "offset.h"
#include <nios2.h>

    .set noat
    .section .exceptions, "xa"
    .align 2
    .global _irq_entry
    .type   _irq_entry, @function
_irq_entry:
    /*
     *  㳰װȽ
     */
    rdctl   et, estatus
    andi    et, et, 1
    beq     et, zero, _check_trap
    rdctl   et, ipending
    beq     et, zero, _check_trap

    
   /*
    * 㳰װϳ
    */
    addi ea, ea, -4      /* Ϥǥ */

    addi  sp, sp, -76    /* 쥸¸ */
    rdctl et, estatus
    stw   et,   0(sp)
    stw   at,   4(sp)
    stw   r2,   8(sp)
    stw   r3,  12(sp)
    stw   r4,  16(sp)
    stw   r5,  20(sp)
    stw   r6,  24(sp)
    stw   r7,  28(sp)
    stw   r8,  32(sp)
    stw   r9,  36(sp)
    stw   r10, 40(sp)
    stw   r11, 44(sp)
    stw   r12, 48(sp)
    stw   r13, 52(sp)
    stw   r14, 56(sp)
    stw   r15, 60(sp)
    stw   fp,  64(sp)
    stw   ra,  68(sp)
    stw   ea,  72(sp)

    /*
     * ¿ųߤȽ
     */
    ldw   r3, %gprel(interrupt_count)(gp)  /* ͥȲΥå */
    bltu  zero, r3,  nest_int

    movhi r2, %hiadj(STACKTOP-4)
    addi  r2, r2, %lo(STACKTOP-4)
    stw   sp, 0(r2)     /* åݥ󥿤¸ */        
    mov   sp, r2        /* åݥ󥿤ؤ */
nest_int:
    /*
     *  װȽȸƤӽФ
     */
    call int_handler_call

ret_from_int:
    ldw   r3, %gprel(interrupt_count)(gp)   
    bltu  zero, r3, res_reg_and_ret /* ͥȲ1ʾʤ */

    ldw   r2, 0(sp)                 /* åݥ󥿤᤹ */
    mov   sp, r2                    /* åݥ󥿤᤹ */

    ldw   r3, %gprel(reqflg)(gp)    /* reqflgΥå */
    beq   r3, zero, res_reg_and_ret
    br    ret_int

res_reg_and_ret:
    ldw   et,   0(sp)  /* 쥸 */
    wrctl estatus, et
    ldw   at,   4(sp)
    ldw   r2,   8(sp)
    ldw   r3,  12(sp)
    ldw   r4,  16(sp)
    ldw   r5,  20(sp)
    ldw   r6,  24(sp)
    ldw   r7,  28(sp)
    ldw   r8,  32(sp)
    ldw   r9,  36(sp)
    ldw   r10, 40(sp)
    ldw   r11, 44(sp)
    ldw   r12, 48(sp)
    ldw   r13, 52(sp)
    ldw   r14, 56(sp)
    ldw   r15, 60(sp)
    ldw   fp,  64(sp)
    ldw   ra,  68(sp)
    ldw   ea,  72(sp)
    addi  sp, sp, 76        
    eret      


_check_trap:        
    /*
     *  TrapȽ
     */
    ldw   et, -4(ea)               /* 㳰Ф̿ */
    xorhi et, et, 0x003b           /*  16bit             */
    xori  et, et, 0x683a           /*  16bit             */
    beq   et, zero, trap_handler

_check_exc:
    addi  sp, sp, -76
    rdctl et,   estatus
    stw   et,    0(sp)
    stw   at,    4(sp)
    stw   r2,    8(sp)
    stw   r3,   12(sp)
    stw   r4,   16(sp)
    stw   r5,   20(sp)
    stw   r6,   24(sp)
    stw   r7,   28(sp)
    stw   r8,   32(sp)
    stw   r9,   36(sp)
    stw   r10,  40(sp)
    stw   r11,  44(sp)
    stw   r12,  48(sp)
    stw   r13,  52(sp)
    stw   r14,  56(sp)
    stw   r15,  60(sp)
    stw   fp,   64(sp)
    stw   ra,   68(sp)
    stw   ea,   72(sp)
    mov   r4,   sp     /* ϥɥΰ */

    /*
     * ¿ųߤȽ
     */
    ldw   r3, %gprel(interrupt_count)(gp)  /* ͥȲΥå */
    bltu  zero, r3,  nest_int_exc
    
    movhi r2, %hiadj(STACKTOP-4)
    addi  r2, r2, %lo(STACKTOP-4)
    stw   sp, 0(r2)     /* åݥ󥿤¸ */        
    mov   sp, r2        /* åݥ󥿤ؤ */
nest_int_exc:
    
    call exc_handler_call  /* CPU㳰ϥɥƤӽФ롼μ¹ */

    br ret_from_int        /* ꥿ */


trap_handler:
   /*
    *  Trapϥɥ顼
    */
    eret  



    .set noat
    .align  2
    .global ret_int
    .global ret_exc
ret_int:
ret_exc:
    stw   zero, %gprel(reqflg)(gp)   /* reqflg  FALSE */
    ldw   r5,   %gprel(runtsk)(gp)   /* r5 <- runtsk      */
    ldw   r6,   %gprel(enadsp)(gp)   /* r6 <- enadsp      */
    beq   r6,   zero, ret_int_1      /* enadsp  FALSE ʤ ret_int_1  */
    ldw   r4,   %gprel(schedtsk)(gp) /* r4 <- schedtsk    */
    beq   r4,   r5, ret_int_1        /* runtsk  schedtskƱʤret_int_1 */
    addi  sp,   sp, -32              /* ĤΥ쥸¸ */    
    stw   r16,  0(sp)
    stw   r17,  4(sp)
    stw   r18,  8(sp)
    stw   r19, 12(sp)
    stw   r20, 16(sp)
    stw   r21, 20(sp)
    stw   r22, 24(sp)
    stw   r23, 28(sp)
    stw   sp,  TCB_sp(r5)         /* åTCB¸ */
    movhi r2,  %hiadj(ret_int_r)  /* ¹ԳϤ¸        */
    addi  r2,  r2, %lo(ret_int_r)
    stw   r2,  TCB_pc(r5)         /* ¹ԺƳϤTCB¸   */
    br    dispatcher

ret_int_r:
    ldw   r16,  0(sp)       /* 쥸 */
    ldw   r17,  4(sp)
    ldw   r18,  8(sp)
    ldw   r19, 12(sp)
    ldw   r20, 16(sp)
    ldw   r21, 20(sp)
    ldw   r22, 24(sp)
    ldw   r23, 28(sp)
    addi  sp, sp, 32    
ret_int_1:
    /*
     *  㳰롼εư    
     *  ret_int_r  dispatcher ƤӽФ뤿ᡤ
     *  tcbΥɥ쥹 r4 äƤ
     */
    ldw  r5, TCB_enatex(r4)       /* r5 <- enatex */
#if TCB_enatex_mask > 0xffff
    andhi r6, r5, %hi(TCB_enatex_mask)
#else
    andi r6, r5, %lo(TCB_enatex_mask)
#endif /* TCB_enatex_mask > 0xffff */
    andhi r6, r5, 4
    beq  r6, zero, ret_int_2      /* enatex  FALSE ʤ꥿ */
    ldw  r7, TCB_texptn(r4)       /* r7 <- texptn, texptn0Ǥʤ */
    beq  zero, r7, ret_int_2      
    call call_texrtn              /* 㳰롼θƤӽФ */

ret_int_2:
    ldw   et,   0(sp)    /* 쥸 */
    wrctl estatus, et
    ldw   at,   4(sp)
    ldw   r2,   8(sp)
    ldw   r3,  12(sp)
    ldw   r4,  16(sp)
    ldw   r5,  20(sp)
    ldw   r6,  24(sp)
    ldw   r7,  28(sp)
    ldw   r8,  32(sp)
    ldw   r9,  36(sp)
    ldw   r10, 40(sp)
    ldw   r11, 44(sp)
    ldw   r12, 48(sp)
    ldw   r13, 52(sp)
    ldw   r14, 56(sp)
    ldw   r15, 60(sp)
    ldw   fp,  64(sp)
    ldw   ra,  68(sp)
    ldw   ea,  72(sp)
    addi  sp, sp, 76        
    eret      


    

    .global dispatch
    .align  2
dispatch:
    addi  sp, sp, -40                /* 쥸¸ */    
    stw   r16,  0(sp)
    stw   r17,  4(sp)
    stw   r18,  8(sp)
    stw   r19, 12(sp)
    stw   r20, 16(sp)
    stw   r21, 20(sp)
    stw   r22, 24(sp)
    stw   r23, 28(sp)
    stw   fp,  32(sp)
    stw   ra,  36(sp)
    ldw   r4,  %gprel(runtsk)(gp)  /* r4 <- runtsk              */
    stw   sp,  TCB_sp(r4)          /* åTCB¸ */
    movhi r5,  %hiadj(dispatch_r)  /* ¹ԳϤ¸        */
    addi  r5,  r5, %lo(dispatch_r)
    stw   r5,  TCB_pc(r4)          /* ¹ԺƳϤTCB¸   */
    br    dispatcher

dispatch_r:
    ldw   r16,  0(sp)              /* 쥸 */
    ldw   r17,  4(sp)
    ldw   r18,  8(sp)
    ldw   r19, 12(sp)
    ldw   r20, 16(sp)
    ldw   r21, 20(sp)
    ldw   r22, 24(sp)
    ldw   r23, 28(sp)
    ldw   fp,  32(sp)     
    /*
     * 㳰롼εư
     *  dispatch_r  dispatcher ƤӽФ뤿ᡤ
     *  tcb Υɥ쥹 r4 äƤ
     */    
    ldw  r5, TCB_enatex(r4)       /* r5 <- enatex */
#if TCB_enatex_mask > 0xffff
    andhi r6, r5, %hi(TCB_enatex_mask)
#else
    andi r6, r5, %lo(TCB_enatex_mask)
#endif /* TCB_enatex_mask > 0xffff */
    beq  r6, zero, dispatch_r_1   /* enatex  FALSE ʤ꥿ */
    ldw  r7, TCB_texptn(r4)       /* r7 <- texptn, texptn0Ǥʤ */
    beq  r7, zero, dispatch_r_1    
    call call_texrtn              /* 㳰롼θƤӽФ */

dispatch_r_1:
    ldw   ra, 36(sp)              /* ĤΥ쥸 */    
    addi  sp, sp, 40                
    ret



    .global exit_and_dispatch
exit_and_dispatch:
    stw      zero, %gprel(interrupt_count)(gp)  /* interrupt_count 򥯥ꥢ */
dispatcher:
    /*
     * ϳ߶ػߤ뤳
     */    
    ldw   r4,   %gprel(schedtsk)(gp) /* r4 <- schedtsk              */
    stw   r4,   %gprel(runtsk)(gp)   /* schedtsk  runtsk        */
    beq   r4,   zero, dispatcher_1   /* schedtsk뤫            */
    ldw   sp,   TCB_sp(r4)           /* TCB饿å */
    ldw   r5,   TCB_pc(r4)           /* TCB¹ԺƳϤ   */
    jmp   r5
dispatcher_1:
    /*
     * ǳߥ⡼ɤڤؤΤϡȯ߽
     * ˤɤΥåȤȤβȡߥϥɥ
     * ΥǥѥåɻߤȤ2Ĥΰ̣롥
     */
    movhi sp, %hiadj(STACKTOP)            /* ߥåѹ  */
    addi  sp, sp, %lo(STACKTOP)              
    movi  r5, 1                           /* interrupt_count 1 */
    stw   r5, %gprel(interrupt_count)(gp)  
dispatcher_2:
    wrctl status, r5      /* ߤε */
    nop
    nop
    nop
    nop
    wrctl status, zero                      /* ߤζػ             */
    ldw   r6, %gprel(reqflg)(gp)            /* r6 <- reqflg             */
    beq   r6, zero, dispatcher_2            /* reqflg  FALSE ʤ     */
    stw   zero, %gprel(interrupt_count)(gp) /* interrupt_count 򥯥ꥢ */ 
    stw   zero, %gprel(reqflg)(gp)          /* reqflg  FALSE        */ 
    br    dispatcher


    .text
    .global activate_r
    .align 2
activate_r:
    movi  r2, 1
    wrctl status, r2      /* ߵ       */
    ldw   r4, 4(sp)       /* (exinf)      */
    ldw   r2, 0(sp)       /* μ¹ */
    addi  sp, sp, 8
    movhi ra, %hiadj(ext_tsk)
    addi  ra, ra, %lo(ext_tsk)
    jmp   r2              /* μ¹Գ */


