/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.4 2004/09/10 14:38:21 honda Exp $
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

/*
 * CPU¸ޥ⥸塼Nios2ѡ
 */ 
#include <s_services.h>
#include <nios2.h>

/*
 * ޳ߥϥɥγֹ
 */
#define INHNO_TIMER TIM_INTLVL

#ifndef _MACRO_ONLY

/*
 * ͤɽη
 */
typedef UW CLOCK;

/*                                                                             
 *  ͤɽȥߥáñ̤ȤѴ                               
 *  TIMER_CLOCK ϥåȥܡ                                     
 */
#define TO_CLOCK(nume, deno)  (TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)      ((clock) * 1000 / TIMER_CLOCK)

/*
 *  Ǥ祿޼ñ̤ɽ
 */
#define MAX_CLOCK ((CLOCK) 0xffffffff)

/*
 *  ǽɾѥƥФݤν֤θѤ͡ñ̤ɽ
 */
#define GET_TOLERANCE	100
#define BEFORE_IREQ(clock) \
        ((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)


/*
 * ޤεư
 *
 * ޤŪʥ޳ߤȯ
 */ 
Inline void
hw_timer_initialize(void)
{
  
    CLOCK cyc = TO_CLOCK(TIC_NUME, TIC_DENO);

    /* ޡȥå */
    sil_wrw_mem((VP)TIM_CONTROL,TIM_CONTROL_STOP);
    /* ॢȥơꥢ */
    sil_wrw_mem((VP)TIM_STATUS, 0x00);
    
      
    assert(cyc <= MAX_CLOCK);                          /* ޾ͤΥå */
    sil_wrw_mem((VP)TIM_PERIODL, (cyc & 0xffff)); /* 󥿡å 16bit */
    sil_wrw_mem((VP)TIM_PERIODH, (cyc >> 16));    /* 󥿡å 16bit */
  
    /*
     * ޡȡȥɡߵ
     */
    sil_wrw_mem((VP)TIM_CONTROL, TIM_CONTROL_START
                                 |TIM_CONTROL_COUNT|TIM_CONTROL_ITO);

    /*
     * ߥȥε
     */
    ena_int(TIM_INTLVL);
}


/*
 *   ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear()
{
    /* TOӥåȤΥꥢ */
    sil_wrw_mem((VP)TIM_STATUS,0x00);
}


/*
 *   ޤζػ߽
 */
Inline void
hw_timer_terminate()
{
    /*  */
    sil_wrw_mem((VP)TIM_CONTROL, TIM_CONTROL_STOP);

    /* ׵Υꥢ */
    sil_wrw_mem((VP)TIM_STATUS, 0x00);
}


/*
 *   ޤθͤɤ߽Ф
 *
 *   ߶ػ߶ǸƤӽФ
 */
Inline CLOCK
hw_timer_get_current(void)
{
    CLOCK count;

    /* ʥåץ쥸˽񤭹ͤۡɤ */
    sil_wrw_mem((VP)TIM_SNAPL, 0x00);

    /* ͤɤ߹ */
    count = sil_rew_mem((VP)TIM_SNAPL);
    count |= sil_rew_mem((VP)TIM_SNAPH) << 16; 
    
    return(TIMER_CLOCK - count);
}


/*
 *   ߤȯƤ뤫Ƚ
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{
    return(sil_rew_mem((VP)TIM_STATUS) & TIM_STATUS_TO);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
