/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2006 by Witz Corporation, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: uart.c,v 1.1 2006/04/10 08:19:25 honda Exp $
 */

/*
 *  Ʊ̿ (UART)ꥢͥǥХSIO˥ɥ饤
 *  Zup-F16ĥܡѡ
 */
#include <s_services.h>
#include <sil.h>
#include <tmp91cy22.h>
#include <uart.h>

/*
 *  ꥢI/O쥸ؤΥեå
 */
#define		TOFFSET_SC0BUF			0x0000
#define		TOFFSET_SC0CR			0x0001
#define		TOFFSET_SC0MOD0			0x0002
#define		TOFFSET_BR0CR			0x0003
#define		TOFFSET_BR0ADD			0x0004
#define		TOFFSET_SC0MOD1			0x0005
 
/*
 *  ꥢI/OݡȾ֥ե饰
 */
#define		TBIT_STS_DEF			0x00
#define		TBIT_TXB_EMPTY			0x01
#define		TBIT_ENE_TXCBR			0x02
#define		TBIT_ENE_RXCBR			0x04
#define		TBIT_LOG_PORT			0x80

/*
 *  ꥢI/OݡȽ֥å
 *
 *  ID = 1 uart1ID = 2 uart0бƤ롥
 */
static const SIOPINIB siopinib_table[TNUM_PORT] = {
	{ TADR_SFR_SC1BUF, TADR_SFR_INTES1, 0x08, (TBIT_SIOSMU8 | TBIT_SIORXE | TBIT_SIOSCBRG),
	  0x00, BRCR_19200, BRADD_19200, TBIT_RX1_CLR }	/* ID1 UART1 19200bps	*/
/*	{ TADR_SFR_SC1BUF, TADR_SFR_INTES1, 0x08, (TBIT_SIOSMU8 | TBIT_SIORXE | TBIT_SIOSCBRG),
	  0x00, BRCR_38400, BRADD_38400, TBIT_RX1_CLR }*/	/* ID1 UART1 38400bps	*/
/*	{ TADR_SFR_SC0BUF, TADR_SFR_INTES0, 0x01, (TBIT_SIOSMU8 | TBIT_SIORXE | TBIT_SIOSCBRG),
	  0x00, BRCR_19200, BRADD_19200, TBIT_RX0_CLR }*/	/* ID2 UART0 19200bps	*/
};

/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 */
static SIOPCB siopcb_table[TNUM_PORT];

/*
 *  ꥢI/OݡID֥åФΥޥ
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  SIOɥ饤Фν롼
 */
void
uart_initialize()
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  ꥢI/Oݡȴ֥åν
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_PORT; siopcb++, i++) {
		siopcb->siopinib = &(siopinib_table[i]);
		siopcb->sts_flag = TBIT_STS_DEF;
		siopcb->rxb = -1;
	}
}

/*
 *  ꥢI/OݡȤΥץ
 */
SIOPCB *
uart_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB		*siopcb;
	const SIOPINIB	*siopinib;
	int i;

	/* ݡID֥å	*/
	siopcb = get_siopcb(siopid);
	siopinib = siopcb->siopinib;

	/* ֥å˾	*/
	siopcb->sts_flag |= TBIT_TXB_EMPTY;
	siopcb->exinf = exinf;
	if( siopid == LOGTASK_PORTID ){	/* ƥѤΥݡȤξ	*/
		siopcb->sts_flag |= TBIT_LOG_PORT;
		if( log_io_busy == TRUE ){
			/* ξϴλޤԤ	*/
			while( (sil_reb_mem((VP)(siopinib->hint)) & TBIT_INTC_H) == 0 );
		}
		log_io_busy = FALSE;	/* ʤΤŪ˹ԤäƤ   */
	}

	/* 	*/
	sil_wrb_mem((VP)(siopinib->cntrl+TOFFSET_SC0MOD0), 0x00 );
	/* ݡ(TXDȤƻ)	*/
	sil_wrb_mem((VP)(TADR_SFR_P9FC), siopinib->pcrfc_def );
	sil_wrb_mem((VP)(TADR_SFR_P9CR), siopinib->pcrfc_def );

	/* ư⡼	*/
	sil_wrb_mem((VP)(siopinib->cntrl+TOFFSET_SC0MOD0), siopinib->scmod0_def );
	sil_reb_mem((VP)(siopinib->cntrl+TOFFSET_SC0CR));	/* ɽФˤꥨ顼ե饰ꥢ	*/
	sil_wrb_mem((VP)(siopinib->cntrl+TOFFSET_SC0CR), siopinib->sccr_def );
	sil_wrb_mem((VP)(siopinib->cntrl+TOFFSET_BR0CR), siopinib->brcr_def);
	sil_wrb_mem((VP)(siopinib->cntrl+TOFFSET_BR0ADD), siopinib->bradd_def);
	sil_wrb_mem((VP)(siopinib->cntrl+TOFFSET_SC0MOD1), TBIT_SIOI2S);

	/* ꥢߤꤪ׵ե饰ꥢ	 */
	sil_wrb_mem((VP)TADR_SFR_INTCLR, (siopinib->int_clr) );		/* ׵᥯ꥢ	*/
	sil_wrb_mem((VP)TADR_SFR_INTCLR, (VB)(siopinib->int_clr + 1) );	/* ׵᥯ꥢ	*/
	sil_wrb_mem((VP)(siopinib->hint), (VB)((INT_LEVEL_UART << 4) | INT_LEVEL_UART) );

	/*
	 * ߡǡ
	 */
	sil_reb_mem((VP)(siopinib->cntrl+TOFFSET_SC0BUF));
	sil_reb_mem((VP)(siopinib->cntrl+TOFFSET_SC0BUF));

	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
void
uart_cls_por(SIOPCB *siopcb)
{
	const SIOPINIB	*siopinib;

	siopinib = siopcb->siopinib;

	/* 	*/
	sil_wrb_mem((VP)(siopinib->cntrl+TOFFSET_SC0MOD0), 0x00 );

	/* ƥѥݡȤν	*/
	if( (siopcb->sts_flag & TBIT_LOG_PORT) == TBIT_LOG_PORT ){
		if( log_io_busy == TRUE ){
			/* ξϴλޤԤ	*/
			while( (sil_reb_mem((VP)(TADR_SFR_INTES0)) & TBIT_INTC_H) == 0 );
		}
		log_io_busy = FALSE;
	}

	/* ꥢߤζػߤ׵ե饰ꥢ	 */
	sil_wrb_mem((VP)(siopinib->hint), 0x00 );
	sil_wrb_mem((VP)TADR_SFR_INTCLR, (siopinib->int_clr) );		/* ׵᥯ꥢ	*/
	sil_wrb_mem((VP)TADR_SFR_INTCLR, (VB)(siopinib->int_clr + 1) );	/* ׵᥯ꥢ	*/
	/* ݡ(ݡȤȤƻ)	*/
	sil_wrb_mem((VP)(TADR_SFR_P9FC), 0x00 );
	sil_wrb_mem((VP)(TADR_SFR_P9CR), 0x00 );

	siopcb->sts_flag = TBIT_STS_DEF;
}

/*
 *  ꥢI/OݡȤؤʸ
 */
BOOL
uart_snd_chr(SIOPCB *siopcb, char c)
{
	if( (siopcb->sts_flag & TBIT_TXB_EMPTY) == TBIT_TXB_EMPTY ){
		siopcb->sts_flag &= (UB)~TBIT_TXB_EMPTY;
		sil_wrb_mem((VP)(siopcb->siopinib->cntrl+TOFFSET_SC0BUF), c);

	/* ƥѥݡȤν	*/
		if( (siopcb->sts_flag & TBIT_LOG_PORT) == TBIT_LOG_PORT ){
			log_io_busy = TRUE;	/* 	*/
		}
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  ꥢI/OݡȤʸ
 */
INT
uart_rcv_chr(SIOPCB *siopcb)
{
	return(siopcb->rxb);
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void
uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case UART_ERDY_SND:
		siopcb->sts_flag |= TBIT_ENE_TXCBR;
		break;
	case UART_ERDY_RCV:
		siopcb->sts_flag |= TBIT_ENE_RXCBR;
		break;
	default:
		break;
	}
}

/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case UART_ERDY_SND:
		siopcb->sts_flag &= (UB)~TBIT_ENE_TXCBR;
		break;
	case UART_ERDY_RCV:
		siopcb->sts_flag &= (UB)~TBIT_ENE_RXCBR;
		break;
	default:
		break;
	}
}

/*
 *  ݡID=1˻ꤵƤSIOͥ(uart1)μ
 */
void serial_in_handler1()
{
	SIOPCB *siopcb = &siopcb_table[0];

	/* 顼ξʤ   */
	if( ( sil_reb_mem((VP)(siopcb->siopinib->cntrl+TOFFSET_SC0CR)) & 0x1c ) == 0 ){

		/* ǡ	*/
		siopcb->rxb = (INT)sil_reb_mem((VP)(siopcb->siopinib->cntrl+TOFFSET_SC0BUF));

		/* ХåĤƤ	*/
		if( (siopcb->sts_flag & TBIT_ENE_RXCBR) == TBIT_ENE_RXCBR ){
			/*
			 *  ΥХå롼ƤӽФ
			 */
			uart_ierdy_rcv(siopcb->exinf);
		}
	}
}

/*
 *  ݡID=1˻ꤵƤSIOͥ(uart1)
 */
void serial_out_handler1()
{
	SIOPCB *siopcb = &siopcb_table[0];

	/* ǡλե饰ON	*/
	siopcb->sts_flag |= TBIT_TXB_EMPTY;

	/* ƥѥݡȤν	*/
	if( (siopcb->sts_flag & TBIT_LOG_PORT) == TBIT_LOG_PORT ){
		log_io_busy = FALSE;	/* λ	*/
	}

	/* ХåĤƤ	*/
	if( (siopcb->sts_flag & TBIT_ENE_TXCBR) == TBIT_ENE_TXCBR ){
		/*
		 *  ǽХå롼ƤӽФ
		 */
		uart_ierdy_snd(siopcb->exinf);
	}
}

#if TNUM_PORT >= 2
/*
 *  ݡID=2˻ꤵƤSIOͥ(uart0)μ
 */
void serial_in_handler2()
{
	SIOPCB *siopcb = &siopcb_table[1];

	/* 顼ξʤ   */
	if( ( sil_reb_mem((VP)(siopcb->siopinib->cntrl+TOFFSET_SC0CR)) & 0x1c ) == 0 ){

		/* ǡ	*/
		siopcb->rxb = (INT)sil_reb_mem((VP)(siopcb->siopinib->cntrl+TOFFSET_SC0BUF));

		/* ХåĤƤ	*/
		if( (siopcb->sts_flag & TBIT_ENE_RXCBR) == TBIT_ENE_RXCBR ){
			/*
			 *  ΥХå롼ƤӽФ
			 */
			uart_ierdy_rcv(siopcb->exinf);
		}
	}
}

/*
 *  ݡID=2˻ꤵƤSIOͥ(uart0)
 */
void serial_out_handler2()
{
	SIOPCB *siopcb = &siopcb_table[1];

	/* ǡλե饰ON	*/
	siopcb->sts_flag |= TBIT_TXB_EMPTY;

	/* ƥѥݡȤν	*/
	if( (siopcb->sts_flag & TBIT_LOG_PORT) == TBIT_LOG_PORT ){
		log_io_busy = FALSE;	/* λ	*/
	}

	/* ХåĤƤ	*/
	if( (siopcb->sts_flag & TBIT_ENE_TXCBR) == TBIT_ENE_TXCBR ){
		/*
		 *  ǽХå롼ƤӽФ
		 */
		uart_ierdy_snd(siopcb->exinf);
	}
}

#endif

