/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: tl16c550cfn.c,v 1.4 2003/12/19 10:03:31 honda Exp $
 */

/*
 * TL16c550cfn ѥɥ饤
 */

#include <s_services.h>
#include "tl16c550cfn.h"

/*
 * ͥ뵯ưѤν(sys_putcѤ뤿)
 */
void
uart_init(void)
{
	/*  FIFOͭˤFIFO򥯥ꥢ
	 *  ȥꥬ٥ᣱ(̡
	 *  8ǡ1ȥåץӥåȡno parity 
	 */ 
	UART_FCR = (FCR_FIFO | FCR_RFRST | FCR_TFRST | FIFO_TRIG);
	UART_LCR = 0x03;
	 /*  ܡ졼ȥ쥸˥ */
	UART_LCR |= LCR_DLAB;
	UART_DLL = UART_BAUD_RATE;
	UART_DLM = UART_BAUD_RATE >> 8;
	/*  BAUD RATE꽪λ  */
	UART_LCR &= ~LCR_DLAB;
	UART_SCR = UART_LSR;
}

/*
 *  ꥢI/OݡȽ֥å
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {0};

/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 */
SIOPCB	siopcb_table[TNUM_SIOP];

/*
 *  ꥢI/OݡID֥åФΥޥ
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  ʸ
 */
Inline BOOL
uart_getready(SIOPCB *siopcb)
{
	return((UART_LSR & LSR_DR) != 0);
}

/*
 *  ʸǤ뤫
 */
Inline BOOL
uart_putready(SIOPCB *siopcb)
{
	return((UART_LSR & LSR_THRE) != 0);
}

/*
 *  ʸμФ
 */
Inline char
uart_getchar(SIOPCB *siopcb)
{
	return((char) UART_RBR);
}

/*
 *  ʸν
 */
Inline void
uart_putchar(SIOPCB *siopcb, char c)
{
	UART_THR = (UB) c;
}

/*
 *  ߵ
 */
Inline void
uart_enable_send(SIOPCB *siopcb)
{
	UART_IER |= IER_TIE;
}

/*
 *  ߶ػ
 */
Inline void
uart_disable_send(SIOPCB *siopcb)
{
	UART_IER &= ~IER_TIE;
}

/*
 *  ߵ
 */
Inline void
uart_enable_rcv(SIOPCB *siopcb)
{
	UART_IER = IER_RIE;
}

/*
 *  ߶ػ
 */
Inline void
uart_disable_rcv(SIOPCB *siopcb)
{
	UART_IER &= ~IER_RIE;
}

/*
 *  SIOɥ饤Фν롼
 */
void
uart_initialize()
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  ꥢI/Oݡȴ֥åν
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
		siopcb->siopinib = &(siopinib_table[i]);
		siopcb->openflag = FALSE;
	}
}

/*
 * ץ󤷤ƤݡȤ뤫
 */
BOOL
uart_openflag(void)
{
	return(siopcb_table[0].openflag);
}



/*
 *  ꥢI/OݡȤΥץ
 */
SIOPCB *
uart_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;

	siopcb = get_siopcb(siopid);
	
	/*  FIFOͭˤFIFO򥯥ꥢ
	 *  ȥꥬ٥ᣱ(̡
	 *  8ǡ1ȥåץӥåȡno parity 
	 */
	UART_FCR = (FCR_FIFO | FCR_RFRST | FCR_TFRST | FIFO_TRIG);
	UART_LCR = 0x03;
	/*  ܡ졼ȥ쥸˥ */
	UART_LCR |= LCR_DLAB;
	UART_DLL = UART_BAUD_RATE;
	UART_DLM = UART_BAUD_RATE >> 8;
	/*  BAUD RATE꽪λ  */
	UART_LCR &= ~LCR_DLAB;
	/*  顼ե饰򥯥ꥢ  */
	UART_SCR = UART_LSR;
	UART_IER = IER_RIE;       /*  ߵ  */
	
	siopcb->exinf = exinf;
	siopcb->openflag = TRUE;
	siopcb->getready = siopcb->putready = FALSE;

	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
void
uart_cls_por(SIOPCB *siopcb)
{
	/* ׵ػ */
	UART_IER = 0;
	
	siopcb->openflag = FALSE;
}

/*
 *  ꥢI/OݡȤؤʸ
 */
BOOL
uart_snd_chr(SIOPCB *siopcb, char chr)
{
	if (uart_putready(siopcb)) {
		uart_putchar(siopcb, chr);
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  ꥢI/OݡȤʸ
 */
INT
uart_rcv_chr(SIOPCB *siopcb)
{
	if (uart_getready(siopcb)) {
		return((INT)(UB) uart_getchar(siopcb));
	}
	return(-1);
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void
uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	    case SIO_ERDY_SND:
		uart_enable_send(siopcb);
		break;
	    case SIO_ERDY_RCV:
		uart_enable_rcv(siopcb);
		break;
	}
}

/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	    case SIO_ERDY_SND:
		uart_disable_send(siopcb);
		break;
	    case SIO_ERDY_RCV:
		uart_disable_rcv(siopcb);
		break;
	}
}

/*
 *  ꥢI/OݡȤФ߽
 */
static void
uart_isr_siop(SIOPCB *siopcb)
{
	if (uart_getready(siopcb)) {
		/*
		 *  ΥХå롼ƤӽФ
		 */
		uart_ierdy_rcv(siopcb->exinf);
	}
	if (uart_putready(siopcb)) {
		/*
		 *  ǽХå롼ƤӽФ
		 */
		uart_ierdy_snd(siopcb->exinf);
	}
}

/*
 *  SIOγߥӥ롼
 */
void
uart_isr()
{
	if (siopcb_table[0].openflag) {
		uart_isr_siop(&(siopcb_table[0]));
	}
}
