/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.15 2003/12/15 07:19:22 takayuki Exp $
 */


/*
 *	ץå¸⥸塼Windowsѡ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  Windows-HALȼΥ󥯥롼ɥե
 */


/*
 *  Windows-HALȼ
 */

#define FPU_CONTEXTSIZE 108     /* ư˥åȤ򤹤륳ƥȤ礭 */

/*
 *  chg_ims/ref_ims 򥵥ݡȤ뤫ɤ
 */
#define	SUPPORT_CHG_IMS

/*
 *  TCB Ϣ
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */

/*
 *  TCB ΥեɤΥӥå
 */
#define	TBIT_TCB_PRIORITY	8	/* priority եɤΥӥå */
#define	TBIT_TCB_TSTAT		8	/* tstat եɤΥӥå */


#ifndef _MACRO_ONLY

#include <s_services.h>

/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
	HANDLE	        ThreadHandle;		//˳Ƥ줿åɤΥϥɥ
	DWORD		    ThreadID;			//˳Ƥ줿åɤID
	unsigned int    InterruptLevel;		//ΥưƤȤγߥޥ٥
} CTXB;

/*
 * CPU֥ե饰
 */
#define CPU_STAT_LOCK			0x01		//CPUå֤Ǥ
#define CPU_STAT_EXC			0x02		//㳰Ǥ
#define CPU_STAT_DOUBLEFAULT	0x04		//֥եȤäƤޤ

extern volatile char CPUStatus;

/*
 *   CPU㳰ϥɥ
 */

/*#define EXCHNO_ZDIV  EXCEPTION_INT_DIVIDE_BY_ZERO */

/*
 *  ƥֻ
 */

Inline BOOL
sense_context()
{
		/* ĤǤʤ󥿥ƥȤǤ */
	return (CurrentInterruptLevel != 0) ? TRUE : FALSE;
}

Inline BOOL
sense_lock()
{
		/* 㳰 or å֥ե饰ΩäƤ CPUå֤Ǥ */
	return (CPUStatus & (CPU_STAT_LOCK|CPU_STAT_EXC)) != 0 ? TRUE : FALSE;
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUåȤβʥƥѡ
 *
 *  task_intmask ϡchg_ipm 򥵥ݡȤ뤿ѿchg_ipm 򥵥ݡ
 *  Ȥʤˤϡtask_intmask  0 ˤʤäƤȹͤФ褤
 */

#include "debugout.h"
#include "device.h"

unsigned long task_intmask;

Inline void
i_lock_cpu()
{   dis_int(0);   }

Inline void
i_unlock_cpu()
{	ena_int(0);   }

#define t_lock_cpu	i_lock_cpu
#define t_unlock_cpu	i_unlock_cpu

/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥå
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	dispatch();
extern void idispatch();

/*
 *  ߤΥƥȤΤƤƥǥѥå
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */

extern void    exit_and_dispatch(void);

/*
 *  ߥϥɥ顿CPU㳰ϥɥ
 */


/*
 *  ߥϥɥ
 *
 *  ٥ȥֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 */

Inline void
define_inh(INHNO inhno, FP inthdr)
{	def_int((unsigned int)inhno,(void *)inthdr);   }

/*
 *  CPU㳰ϥɥ
 *
 *  ٥ȥֹ excno CPU㳰ϥɥεưϤ exchdr ꤹ롥
 */
Inline void
define_exc(EXCNO excno, FP exchdr)
{	def_exc( (DWORD)excno, (void *)exchdr);   }

/*
 *  ߥϥɥ顿CPU㳰ϥɥν
 */

/*
 *  ߥϥɥνޥ
 *
 *  ƤγߥϥɥϥǥѥåưSIGUSR1ޥ
 *  ư롣
 *  reqflg å˳ߤػߤʤȡreqflg å
 *  ˵ư줿ߥϥɥǥǥѥå׵ᤵ줿ˡǥ
 *  ѥåʤ
 */

	/* Windows-HALˤƤνϳߥߥ졼˰ǤƤ */

#define INT_ENTRY(hdr) hdr
#define INTHDR_ENTRY(inthdr) extern void inthdr(void)

/*
 *  CPU㳰ϥɥνޥ
 *
 *  CPU㳰ϥɥϡ󥿥ƥȤǼ¹Ԥ롥ΤᡤCPU
 *  ϥɥƤӽФ˳ߥ⡼ɤ˰ܹԤ꥿󤷤Ƥ
 *  Υ⡼ɤ᤹Υ⡼ɤ᤹ˡߥ⡼ɤ˰ܹԤ
 *   SR ߥå¸롥CPU㳰ƥȤ
 *  ȯreqflg  TRUE ˤʤäˡret_exc ʬ롥
 *  reqflg å˳ߤػߤʤȡreqflg å
 *  ˵ư줿ߥϥɥǥǥѥå׵ᤵ줿ˡǥ
 *  ѥåʤ
 */

#define EXC_ENTRY(hdr) hdr
#define EXCHDR_ENTRY(inthdr) extern void inthdr(void)

/*
 *  CPU㳰ȯΥƥ֤λ
 */

/*
 *  CPU㳰ȯΥǥѥå
 *
 *   WindowsHALѥե饰äƤǡξϤΤޤ
 *   ǼƤ롣
 */
#define exc_sense_context sense_context

/*
 *  CPU㳰ȯCPUå֤λ
 */
#define exc_sense_lock sense_lock

/*
 *  ץå¸ν
 */
extern void	cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void	cpu_terminate(void);

/*
 *  atexitϿ줿ؿɽФ (Windowsϲ⤷ʤ -> CRTǤ)
 */
extern void	call_atexit(void);

/*
 *   Windows Dedicated Routines 
 */
extern LONG WINAPI HALExceptionHandler( EXCEPTION_POINTERS * exc );

/*
 *   ̿ŪʼԤФн롼
 */
extern void FatalAssertion(int exp, LPCSTR format, ... );


/*
 *   ν롼
 */
extern void set_logcontrol(BOOL enable);

/*
 *   ͥǥХåprintf
 */

#ifdef KERNEL_DEBUG_MODE
#  define kprintf(x) _kernel_debugprintf x
#else
#  define kprintf(x)
#endif

extern void _kernel_debugprintf(const char * format, ... );

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
