/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.c,v 1.5 2003/12/15 07:19:22 takayuki Exp $
 */

/*
 *	åȰ¸ޥ⥸塼Windowsѡ
 */

#ifndef _HW_TIMER_C_
#define _HW_TIMER_C_

#include <s_services.h>
#include <hw_timer.h>
#include <hal_msg.h>

extern HANDLE PrimaryThreadHandle;

/*
 *  Windowsɸॿ
 */
#if defined(TIMER_WINDOWSTIMER)

	/* ޤεư */
void hw_timer_initialize()
{
    kprintf(("hw_timer_initialize()\n"));
	SetTimer((HWND)PrimaryThreadHandle,RTC_EVENT,TIMER_CLOCK_WINDOWS,NULL);
}

	/* ޤ߽ */
void hw_timer_terminate()
{
    kprintf(("hw_timer_terminate()\n"));
	KillTimer((HWND)PrimaryThreadHandle,RTC_EVENT);
}


/*
 *  ޥǥ
 */
#elif defined(TIMER_MULTIMEDIATIMER)

#include <mmsystem.h>

static DWORD TimerID = 0;

static void CALLBACK MultiMediaTimerCallbackFunction(UINT wTimerID, UINT msg, DWORD dwUser, DWORD dw1, DWORD dw2)
{	HALInterruptRequest(INHNO_TIMER);	}

	/* ޤεư */
void hw_timer_initialize()
{
	MMRESULT result;
	TIMECAPS devcap;

    kprintf(("hw_timer_initialize()\n"));

    result = timeGetDevCaps(&devcap, sizeof(TIMECAPS));
	FatalAssertion(result == TIMERR_NOERROR &&  TIMER_CLOCK_WINDOWS >= devcap.wPeriodMin && TIMER_CLOCK_WINDOWS <= devcap.wPeriodMax, "ꤵ줿åƥåϥޥǥޤǽϰϤĶƤޤ");

	timeBeginPeriod(TIMER_CLOCK_WINDOWS);	//timeBeginPeriod(devcap.wPeriodMin); ȼ¹Ԥȡ٤Ȱ٤夬

	TimerID = timeSetEvent(TIMER_CLOCK_WINDOWS, TIMER_CLOCK_WINDOWS,  MultiMediaTimerCallbackFunction, 0, TIME_PERIODIC|TIME_CALLBACK_FUNCTION);
	FatalAssertion(TimerID != 0, "hw_tiemr_initialize failed to perform 'timeSetEvent' function.");
}

	/* ޤ߽ */
void hw_timer_terminate()
{
    kprintf(("hw_timer_terminate()\n"));

    if(TimerID != 0)
	{
		timeKillEvent(TimerID);
		timeEndPeriod(TIMER_CLOCK_WINDOWS);
	}
}

#elif defined(TIMER_NOTHING)

void hw_timer_initialize() {}
void hw_timer_terminate()  {}

#else

#error "Ѥ륿ޤμ̤򤵤Ƥޤ"

#endif



#endif /* _HW_TIMER_H_ */

