/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2005 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */

/*
 *      ץå¸⥸塼 ֥Xstormy16ѡ
 */

#define _MACRO_ONLY
#include <offset.h>
#include <cpu_sfrs.h>

/*
 *  ߡ㳰RAMΰ
 */
        .section .data_0,"aw"

                                /*
                                 *  ߡ㳰ͥȥ
                                 *  (ͥ뵯ư󥿥ƥȤ
                                 *  ưͤ1Ȥ)
                                 */
        .global _kernel_intnest
_kernel_intnest:
        .hword 1

                                /*
                                 *  ߥϥɥơ֥
                                 *  (UARTߤޤ17)
                                 */
        .global _kernel_ih_table
_kernel_ih_table:
        .hword 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

                                /*
                                 *  㳰ϥɥơ֥
                                 *  (̤̿/ϥɥ/
                                 *  곰/reserved)
                                 */
        .global _kernel_eh_table
_kernel_eh_table:
        .hword 0,0,0,0

/*
 *  ߥ٥ȥ
 *  (section8000h-8083h˥󥯤)
 */
        .section .int_vec,"ax"
        .global _start
        .align 1
_start:
	clr1 psw,#7
        br _kernel_int_irq_0
	clr1 psw,#7
        br _kernel_int_irq_1
	clr1 psw,#7
        br _kernel_int_irq_2
	clr1 psw,#7
        br _kernel_int_irq_3
	clr1 psw,#7
        br _kernel_int_irq_4
	clr1 psw,#7
        br _kernel_int_irq_5
	clr1 psw,#7
        br _kernel_int_irq_6
	clr1 psw,#7
        br _kernel_int_irq_7
	clr1 psw,#7
        br _kernel_int_irq_8
	clr1 psw,#7
        br _kernel_int_irq_9
	clr1 psw,#7
        br _kernel_int_irq_a
	clr1 psw,#7
        br _kernel_int_irq_b
	clr1 psw,#7
        br _kernel_int_irq_c
	clr1 psw,#7
        br _kernel_int_irq_d
	clr1 psw,#7
        br _kernel_int_irq_e
	clr1 psw,#7
        br _kernel_int_irq_f
        .org 0x80
        jmpf _kernel_int_irq_ex

/*
 *  ߥϥɥ
 */
_kernel_int_irq_0:
                                /*
                                 *  åɥå޳ߤRESETȽ
                                 */
        bn __WDTCR,#4,_after_reset
        bp __WDTCR,#5,_after_reset
        push r0
        mov r0,#_kernel_ih_table+0
        br _int_common
_after_reset:
	jmpf _int_reset
_kernel_int_irq_1:
        push r0
        mov r0,#_kernel_ih_table+2
        br _int_common
_kernel_int_irq_2:
        push r0
        mov r0,#_kernel_ih_table+4
        br _int_common
_kernel_int_irq_3:
        push r0
        mov r0,#_kernel_ih_table+6
        br _int_common
_kernel_int_irq_4:
        push r0
        mov r0,#_kernel_ih_table+8
        br _int_common
_kernel_int_irq_5:
        push r0
        mov r0,#_kernel_ih_table+10
        br _int_common
_kernel_int_irq_6:
        push r0
        mov r0,#_kernel_ih_table+12
        br _int_common
_kernel_int_irq_7:
        push r0
        mov r0,#_kernel_ih_table+14
        br _int_common
_kernel_int_irq_8:
        push r0
        mov r0,#_kernel_ih_table+16
        br _int_common
_kernel_int_irq_9:
        push r0
        mov r0,#_kernel_ih_table+18
        br _int_common
_kernel_int_irq_a:
        push r0
        mov r0,#_kernel_ih_table+20
        br _int_common
_kernel_int_irq_b:
        push r0
        mov r0,#_kernel_ih_table+22
        br _int_common
_kernel_int_irq_c:
        push r0
        mov r0,#_kernel_ih_table+24
        br _int_common
_kernel_int_irq_d:
        push r0
        mov r0,#_kernel_ih_table+26
        br _int_common
_kernel_int_irq_e:
        push r0
        mov r0,#_kernel_ih_table+28
        br _int_common
_kernel_int_irq_f:
        push r0
        mov r0,#_kernel_ih_table+30
        br _int_common

/*
 *  ߥϥɥ
 */
_int_common:
                                /*
                                 *  r1/r2(r0Ѥ)
                                 */
        push r1
        push r2
                                /*
                                 *  ͥȤߤɤå
                                 */
        mov r1,_kernel_intnest
        bz interrupt_from_task

/*
 *  ͥȤߤν
 */
                                /*
                                 *  ͥȥ󥿤򥤥󥯥Ȥ
                                 *  ̤γߤ
                                 */
        inc r1
        mov _kernel_intnest,r1
        set1 psw,#7
                                /*
                                 *  r3-r9(caller saved register)
                                 */
        push r3
        push r4
        push r5
        push r6
        push r7
        push r8
        push r9
                                /*
                                 *  ߥϥɥθƤӽФ
                                 */
        mov r1,(r0)
        bz 1f
        mov r8,#0
        call r8,r1
1:
                                /*
                                 *  r1-r9
                                 */
        pop r9
        pop r8
        pop r7
        pop r6
        pop r5
        pop r4
        pop r3
        pop r2
        pop r1
                                /*
                                 *  ͥȥ󥿤ǥȤ
                                 *  ޤ줿γߥϥɥ
                                 */
        clr1 psw,#7
        mov r0,_kernel_intnest
        dec r0
        mov _kernel_intnest,r0
        pop r0
        iret

/*
 *  ͥȤƤʤߤν
 */
interrupt_from_task:
                                /*
                                 *  ͥȥ󥿤򥤥󥯥
                                 */
        mov _kernel_intnest,#1
                                /*
                                 *  å󥿥Ѥڤؤ
                                 *  ߤ
                                 */
        mov r1,sp
        mov sp,#__stack
        set1 psw,#7
                                /*
                                 *  r3-r9(caller saved register)
                                 *  ¦å
                                 */
        mov (r1++),r3
        mov (r1++),r4
        mov (r1++),r5
        mov (r1++),r6
        mov (r1++),r7
        mov r3,r8
        mov (r1++),r3
        mov r3,r9
        mov (r1++),r3
                                /*
                                 *  ¦åݥ󥿤
                                 *  å
                                 */
        push r1
                                /*
                                 *  ߥϥɥθƤӽФ
                                 */
        mov r1,(r0)
        bz 1f
        mov r8,#0
        call r8,r1
1:
                                /*
                                 *  ߤػ
                                 */
        clr1 psw,#7

/*
 *  ߡ㳰̤νи
 */
ret_int_and_exc:
                                /*
                                 *  ѥå᤹
                                 */
        pop r1
        mov sp,r1
                                /*
                                 *  ͥȥ󥿤ǥ
                                 */
        mov _kernel_intnest,#0
                                /*
                                 *  reqflgåFALSEʤ顢
                                 *  ˥
                                 */
        mov r0,#_kernel_reqflg
        mov r1,(r0)
        bz ret_to_task_int

/*
 *  ˥ڤؤ׵᤬ȯν
 */
                                /*
                                 *  reqflg򥯥ꥢ
                                 */
        mov r1,#0
        mov (r0),r1
                                /*
                                 *  ǥѥåػߤruntsk=schedtsk
                                 *  ʤ顢Υ
                                 */
        mov r0,#_kernel_enadsp
        mov r1,(r0)
        bz ret_int_1
        mov r0,#_kernel_runtsk
        mov r1,(r0)
        mov r2,#_kernel_schedtsk
        mov r3,(r2)
        bz r1,r3,ret_int_1
                                /*
                                 *  ڤؤΤᡢr10-13/sp
                                 */
        push r10
        push r11
        push r12
        push r13
        mov r7,sp
        mov (r1,+TCB_sp),r7             /* r1 points runtsk */
                                /*
                                 *  mode=1(ret_int_r)ꤷ
                                 *  ǥѥå
                                 */
        mov r7,#1
        mov (r1,+TCB_mode),r7
        br dispatcher

/*
 *  Υǥѥå
 */
ret_int_r:

                                /*
                                 *  r10-13
                                 */
        pop r13
        pop r12
        pop r11
        pop r10

/*
 *  Υ
 */
ret_int_1:
        mov r0,#_kernel_runtsk
        mov r1,(r0)
                                /*
                                 *  㳰ϥɥĤΥå
                                 */
        mov.b r7,(r1,+TCB_enatex)
        bn r7,#TCB_enatex_bit,ret_to_task_int
                                /*
                                 *  㳰ȯΥå
                                 */
        mov r7,(r1,+TCB_texptn)
        bz ret_to_task_int
                                /*
                                 *  㳰ϥɥθƤӽФ
                                 */
        callf _kernel_call_texrtn
                                /*
                                 *  r0-r9Υ
                                 */
ret_to_task_int:
        pop r9
        pop r8
        pop r7
        pop r6
        pop r5
        pop r4
        pop r3
        pop r2
        pop r1
        pop r0
        iret

/*
 *  㳰ϥɥ
 */
        .global _kernel_int_irq_ex
_kernel_int_irq_ex:
        push r0
                                /*
                                 *  UART㳰ϳߤȤƽ
                                 */
        bn __U0CR,#0,1f                 /* UART0 RxRdy */
        bn __U0CR,#1,1f
        mov r0,#_kernel_ih_table+32
        br _int_common
1:
        bn __U0CR,#2,2f                 /* UART0 TxEmpty */
        bn __U0CR,#3,2f
        mov r0,#_kernel_ih_table+32
        br _int_common
2:
        bn __U1CR,#0,3f                 /* UART1 RxRdy */
        bn __U1CR,#1,3f
        mov r0,#_kernel_ih_table+32
        br _int_common
3:
        bn __U1CR,#2,4f                 /* UART1 TxEmpty */
        bn __U1CR,#3,4f
        mov r0,#_kernel_ih_table+32
        br _int_common
4:
                                /*
                                 *  r1,r2򤷡r2㳰ȯSP
                                 *  (㳰ϥɥؤΰ)
                                 */
        push r1
        push r2
        mov r2,sp
        sub r2,#6
                                /*
                                 *  ȯ㳰Ƚ/ꥢ
                                 */
        bn __EXCPL,#1,5f                /* undefined instruction */
        set1 psw,#11
        clr1 __EXCPL,#1
        clr1 psw,#11
        mov r0,#_kernel_eh_table+0
        br _exc_common
5:
        bn __EXCPL,#3,6f                /* word access to odd address */
        set1 psw,#11
        clr1 __EXCPL,#3
        clr1 psw,#11
        mov r0,#_kernel_eh_table+2
        br _exc_common
6:
        bn __EXCPL,#5,7f                /* acccess out of mamoey range */
        set1 psw,#11
        clr1 __EXCPL,#5
        clr1 psw,#11
        mov r0,#_kernel_eh_table+4
        br _exc_common
7:
        mov r0,#_kernel_eh_table+6      /* unknown exception */
        br _exc_common

/*
 *  㳰ϥɥ
 */
_exc_common:
                                /*
                                 *  ͥȤ㳰ɤå
                                 *  (㳰ϡ¾γߤ˥ͥȤ
                                 *  Ȥ̵Τǡ߶ػ߽
                                 *  )
                                 */
        mov r1,_kernel_intnest
        bz exception_from_task

/*
 *  ͥȤ㳰ν
 */
                                /*
                                 *  ͥȥ󥿤򥤥󥯥
                                 */
        inc r1
        mov _kernel_intnest,r1
                                /*
                                 *  r3-r9(caller saved register)
                                 */
        push r3
        push r4
        push r5
        push r6
        push r7
        push r8
        push r9
                                /*
                                 *  㳰ϥɥθƤӽФ
                                 */
        mov r1,(r0)
        bz 1f
        mov r8,#0
        call r8,r1
1:
                                /*
                                 *  r1-r9
                                 */
        pop r9
        pop r8
        pop r7
        pop r6
        pop r5
        pop r4
        pop r3
        pop r2
        pop r1
                                /*
                                 *  ͥȥ󥿤ǥȤ
                                 *  ޤ줿γߥϥɥ
                                 */
        mov r0,_kernel_intnest
        dec r0
        mov _kernel_intnest,r0
        pop r0
        iret

/*
 *  ͥȤƤʤ㳰ν
 */
exception_from_task:
                                /*
                                 *  ͥȥ󥿤򥤥󥯥
                                 */
        mov _kernel_intnest,#1
                                /*
                                 *  å󥿥Ѥڤؤ
                                 */
        mov r1,sp
        mov sp,#__stack
                                /*
                                 *  r3-r9(caller saved register)
                                 *  ¦å
                                 */
        mov (r1++),r3
        mov (r1++),r4
        mov (r1++),r5
        mov (r1++),r6
        mov (r1++),r7
        mov r3,r8
        mov (r1++),r3
        mov r3,r9
        mov (r1++),r3
                                /*
                                 *  ¦åݥ󥿤
                                 *  å
                                 */
        push r1
                                /*
                                 *  㳰ϥɥθƤӽФ
                                 */
        mov r1,(r0)
        bz 1f
        mov r8,#0
        call r8,r1
1:
                                /*
                                 *  ߡ㳰̽и
                                 */
        br ret_int_and_exc

/*
 *  exit_and_dispatch()
 *  ΥƥȤ¸ڤؤ
 *  (ͥ볫ϸǽΥεưޤ)
 */
        .global _kernel_exit_and_dispatch
_kernel_exit_and_dispatch:
                                /*
                                 *  ͥȥ󥿤򥯥ꥢ
                                 *  (ͥ볫ľ˼¹ԤƤ
                                 *  ̵硢󥿥ƥ
                                 *  ¹򼨤ᡢͥȥ󥿤1
                                 *  ʤäƤ롣򥯥ꥢ)
                                 */
        mov _kernel_intnest,#0
                                /*
                                 *  ǥѥåǥ
                                 */
        br dispatcher

/*
 *  dispatch()
 *  ΥƥȤ¸ڤؤ
 */
        .global _kernel_dispatch
_kernel_dispatch:
                                /*
                                 *  r10-r14(callee-saved egister)¸
                                 */
        push r10
        push r11
        push r12
        push r13
        push psw
                                /*
                                 *  SPruntsk->tskctxb.sp¸
                                 */
        mov r0,#_kernel_runtsk
        mov r1,(r0)
        mov r7,sp
        mov (r1,+TCB_sp),r7
                                /*
                                 *  mode=0(dispatch_r)ꤷ
                                 *  ǥѥå
                                 */
        mov r7,#0
        mov (r1,+TCB_mode),r7
        br dispatcher

/*
 *  dispatch()
 *  (r3TCB򼨤)
 */
dispatch_r:
                                /*
                                 *  r10-r14(callee-saved egister)
                                 */
        pop psw
        pop r13
        pop r12
        pop r11
        pop r10
                                /*
                                 *  㳰å&
                                 *  㳰ʤƤӽФ
                                 */
        mov.b r7,(r3,+TCB_enatex)
        bn r7,#TCB_enatex_bit,1f
        mov r7,(r3,+TCB_texptn)
        bz 1f
        jmpf _kernel_call_texrtn
1:
                                /*
                                 *  dispatch()Ƥ
                                 */
        ret

/*
 *  create_context()/activate_context()
 *  εư
 *  (r2TCB򼨤)
 */
        .global _kernel_create_context
_kernel_create_context:
        ret

        .global _kernel_activate_context
_kernel_activate_context:
                                /*
                                 *  åݥ󥿤
                                 *  tcb->tskctxb.sp=tcb->tinib->stk
                                 */
        mov r0,(r2,+TCB_tinib)
        mov r1,(r0,+TINIB_stk)
        mov (r2,+TCB_sp),r1
                                /*
                                 *  mode=2(activate_r)
                                 */
        mov r1,#2
        mov (r2,+TCB_mode),r1
        ret

/*
 *  activate_context()줿εư
 *  (r3TCB򼨤)
 */
activate_r:
                                /*
                                 *  returnǽλȤˡ
                                 *  ext_tsk()ƤФ褦
                                 *  åѤ
                                 */
        mov r1,#@lo(ext_tsk)
        push r1
        mov r2,#@hi(ext_tsk)
        push r2
                                /*
                                 *  ϥɥ쥹򥹥åѤ
                                 */
        mov r0,(r3,+TCB_tinib)
        mov r1,(r0,+TINIB_task)
        push r1
        mov r2,#0
        push r2
                                /*
                                 *  PSWͤ򥹥åѤ
                                 */
        mov r1,#0x0080
        push r1
                                /*
                                 *  r2=exinf
                                 */
        mov r2,(r0,+TINIB_exinf)
                                /*
                                 *  ư
                                 */
        iret

/*
 *  ǥѥå㡼
 */
dispatcher:
                                /*
                                 *  runtsk = schedtsk
                                 */
        mov r2,#_kernel_schedtsk
        mov r3,(r2)
        mov r0,#_kernel_runtsk
        mov (r0),r3
                                /*
                                 *  schedtsk = NULL(¹Բǽʥ̵)
                                 *  ξ硢ɥ
                                 */
        bz dispatcher_1
                                /*
                                 *  SP
                                 */
        mov r7,(r3,+TCB_sp)
        mov sp,r7
                                /*
                                 *  modeˤäơ
                                 *   =0 : dispatch_r
                                 *   =1 : ret_int_r
                                 *   =2 : activate_r
                                 */
        mov r7,(r3,+TCB_mode)
        bz dispatch_r
        bz r7,#1,ret_int_r
        br activate_r

/*
 *  ɥ(¹Բǽ̵)
 */
dispatcher_1:
                                /*
                                 *  å󥿥Ѥڤؤ
                                 */
        mov sp,#__stack
                                /*
                                 *  󥿥򼨤
                                 *  ͥȥ󥿤1򥻥å
                                 */
        mov _kernel_intnest,#1
                                /*
                                 *  ¹ԲǽԤΥ롼
                                 */
dispatcher_2:
                                /*
                                 *  ߥ٥0(IL=0)
                                 */
        mov psw,#0x0000
                                /*
                                 *  ɥ롼ƤӽФ
                                 */
        callf _kernel_idle
                                /*
                                 *  ¹ԲǽˤʤäΥå
                                 *  (reqflg=1?)
                                 */
        mov r0,#_kernel_reqflg
        mov r1,(r0)
        bz dispatcher_2
                                /*
                                 *  reqflgȥͥȥ󥿤򥯥ꥢ
                                 *  ǥѥå
                                 */
        mov r1,#0
        mov (r0),r1
        mov _kernel_intnest,#0
        br dispatcher

/*
 *  ǥեȤΥɥ롼
 */
        .weak _kernel_idle
_kernel_idle:
                                /*
                                 *  ߤ
                                 */
        set1 psw,#7
                                /*
                                 *  Ԥ
                                 */
        halt
                                /*
                                 *  ߤػ
                                 */
        clr1 psw,#7
        ret

        .end

