/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2005 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */

/*
 *  ꥢI/OǥХSIO˥ɥ饤СXstprmy16ѡ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>

/*
 *  SIOγߥϥɥΥ٥ֹ
 */
#define INHNO_SIO   INHNO_UART

/*
 *  ꥢI/Oݡȴ֥å
 */
typedef struct sio_port_control_block {
    const UH uhMagic ;
    const UH uhBase ;
    const UH uhExcpMask ;
    VP_INT vpiExinf ;
    B bNotExist ;
    B bOpened ;
    B bTxIe ;
    B bRxIe ;
    B bLastIsCr ;
} SIOPCB;

/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND    1u      /* ǽХå */
#define SIO_ERDY_RCV    2u      /* ΥХå */

/*
 *  SIOɥ饤Фν롼
 */
extern void sio_initialize(void) throw() ;

/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB *sio_opn_por(ID siopid, VP_INT exinf) throw() ;

/*
 *  ꥢI/OݡȤΥ
 */
extern void sio_cls_por(SIOPCB *siopcb) throw() ;

/*
 *  SIOγߥϥɥ
 */
extern void sio_handler(void) throw() ;

/*
 *  ꥢI/OݡȤؤʸ
 */
extern BOOL sio_snd_chr(SIOPCB *siopcb, char c) throw() ;

/*
 *  ꥢI/OݡȤʸ
 */
extern INT sio_rcv_chr(SIOPCB *siopcb) throw() ;

/*
 *  ꥢI/OݡȤΥХåε
 */
extern void sio_ena_cbr(SIOPCB *siopcb, UINT cbrtn) throw() ;

/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void sio_dis_cbr(SIOPCB *siopcb, UINT cbrtn) throw() ;

/*
 *  ꥢI/OݡȤǽХå
 */
extern void sio_ierdy_snd(VP_INT exinf) throw() ;

/*
 *  ꥢI/OݡȤμΥХå
 */
extern void sio_ierdy_rcv(VP_INT exinf) throw() ;

/*
 *  ꥢI/OݡȤؤƱʸ
 */
extern void sio_asnd_chr( INT c ) throw() ;

/*
 *  ꥢI/OݡȤƱʸ
 */
extern INT sio_arcv_chr( void ) throw() ;

#endif /* _HW_SERIAL_H_ */
