/* Threads compatibility routines for libgcc2 and libobjc for TOPPERS kernel  */
/* Compile this one with gcc.  */
/* Copyright (C) 1997, 1999, 2000, 2002 Free Software Foundation, Inc.
   Copyright (C) 2003 TAKAGI Nobuhisa

This file is part of GCC.

GCC is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

GCC is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

/* As a special exception, if you link this library with other files,
   some of which are compiled with GCC, to produce an executable,
   this library does not by itself cause the resulting executable
   to be covered by the GNU General Public License.
   This exception does not however invalidate any other reasons why
   the executable file might be covered by the GNU General Public License.  */

#ifndef _GLIBCPP_GCC_GTHR_TOPPERS_H
#define _GLIBCPP_GCC_GTHR_TOPPERS_H

#ifdef _LIBOBJC

/* Thread local storage for a single thread */
static void *thread_local_storage = NULL;

/* Backend initialization functions */

/* Initialize the threads subsystem.  */
int
__gthread_objc_init_thread_system(void)
{
  /* No thread support available */
  return -1;
}

/* Close the threads subsystem.  */
int
__gthread_objc_close_thread_system(void)
{
  /* No thread support available */
  return -1;
}

/* Backend thread functions */

/* Create a new thread of execution.  */
objc_thread_t
__gthread_objc_thread_detach(void (*_func)(void *arg), void *arg)
{
  /* No thread support available */
  return NULL;
}

/* Set the current thread's priority.  */
int
__gthread_objc_thread_set_priority(int priority)
{
  /* No thread support available */
  return -1;
}

/* Return the current thread's priority.  */
int
__gthread_objc_thread_get_priority(void)
{
  return OBJC_THREAD_INTERACTIVE_PRIORITY;
}

/* Yield our process time to another thread.  */
void
__gthread_objc_thread_yield(void)
{
  return;
}

/* Terminate the current thread.  */
int
__gthread_objc_thread_exit(void)
{
  /* No thread support available */
  /* Should we really exit the program */
  /* exit(&__objc_thread_exit_status); */
  return -1;
}

/* Returns an integer value which uniquely describes a thread.  */
objc_thread_t
__gthread_objc_thread_id(void)
{
  /* No thread support, use 1.  */
  return (objc_thread_t)1;
}

/* Sets the thread's local storage pointer.  */
int
__gthread_objc_thread_set_data(void *value)
{
  thread_local_storage = value;
  return 0;
}

/* Returns the thread's local storage pointer.  */
void *
__gthread_objc_thread_get_data(void)
{
  return thread_local_storage;
}

/* Backend mutex functions */

/* Allocate a mutex.  */
int
__gthread_objc_mutex_allocate(objc_mutex_t mutex)
{
  return 0;
}

/* Deallocate a mutex.  */
int
__gthread_objc_mutex_deallocate(objc_mutex_t mutex)
{
  return 0;
}

/* Grab a lock on a mutex.  */
int
__gthread_objc_mutex_lock(objc_mutex_t mutex)
{
  /* There can only be one thread, so we always get the lock */
  return 0;
}

/* Try to grab a lock on a mutex.  */
int
__gthread_objc_mutex_trylock(objc_mutex_t mutex)
{
  /* There can only be one thread, so we always get the lock */
  return 0;
}

/* Unlock the mutex */
int
__gthread_objc_mutex_unlock(objc_mutex_t mutex)
{
  return 0;
}

/* Backend condition mutex functions */

/* Allocate a condition.  */
int
__gthread_objc_condition_allocate(objc_condition_t condition)
{
  return 0;
}

/* Deallocate a condition.  */
int
__gthread_objc_condition_deallocate(objc_condition_t condition)
{
  return 0;
}

/* Wait on the condition */
int
__gthread_objc_condition_wait(objc_condition_t condition, objc_mutex_t mutex)
{
  return 0;
}

/* Wake up all threads waiting on this condition.  */
int
__gthread_objc_condition_broadcast(objc_condition_t condition)
{
  return 0;
}

/* Wake up one thread waiting on this condition.  */
int
__gthread_objc_condition_signal(objc_condition_t condition)
{
  return 0;
}

#else /* _LIBOBJC */

#ifdef __cplusplus
extern "C" {
#endif

#define __GTHREADS 1

#ifdef __cplusplus
#define __throw()  throw()
#else
#define __throw()
#endif

typedef int _toppers_cxxrt_sync_t;
typedef volatile char _toppers_cxxrt_once_t;
struct _toppers_cxxrt_tls
{
  void **_data;
  void (*_dtor)(void*);
};

extern int _toppers_cxxrt_once (_toppers_cxxrt_once_t *, void (*) (void)) __throw();
extern int _toppers_cxxrt_key_create (struct _toppers_cxxrt_tls **, void (*) (void*)) __throw();
extern int _toppers_cxxrt_key_delete (struct _toppers_cxxrt_tls *) __throw();
extern int _toppers_cxxrt_lock (_toppers_cxxrt_sync_t *) __throw();
extern int _toppers_cxxrt_trylock (_toppers_cxxrt_sync_t *) __throw();
extern int _toppers_cxxrt_unlock (_toppers_cxxrt_sync_t *) __throw();
extern int _toppers_cxxrt_get_tskid (void) __throw();

typedef struct _toppers_cxxrt_tls * __gthread_key_t;
typedef _toppers_cxxrt_sync_t __gthread_mutex_t;
typedef _toppers_cxxrt_once_t __gthread_once_t;

#define __GTHREAD_MUTEX_INIT    0
#define __GTHREAD_ONCE_INIT     0

static inline int
__gthread_active_p (void)
{
  return 1;
}

static inline int
__gthread_once (__gthread_once_t *_once, void (*_func) (void))
{
	return _toppers_cxxrt_once (_once, _func);
}

/* This only works for the code in libgcc2.c.  */

static inline int
__gthread_key_create (__gthread_key_t *_key, void (*_dtor) (void *))
{
  return _toppers_cxxrt_key_create (_key, _dtor);
}

static inline int
__gthread_setspecific(__gthread_key_t _key, const void *_ptr)
{
  _key->_data[_toppers_cxxrt_get_tskid()] = (void*)_ptr;
  return 0;
}

static inline int
__gthread_key_dtor (__gthread_key_t _key, void *_ptr)
{
  return 0;
}

static inline int
__gthread_key_delete (__gthread_key_t _key)
{
  return _toppers_cxxrt_key_delete (_key);
}

static inline void *
__gthread_getspecific (__gthread_key_t _key)
{
  return _key->_data[_toppers_cxxrt_get_tskid()];
}

static inline int
__gthread_mutex_lock (__gthread_mutex_t *_mutex)
{
  return _toppers_cxxrt_lock (_mutex);
}

static inline int
__gthread_mutex_trylock (__gthread_mutex_t *_mutex)
{
  return _toppers_cxxrt_trylock (_mutex);
}

static inline int
__gthread_mutex_unlock (__gthread_mutex_t *_mutex)
{
  return _toppers_cxxrt_unlock (_mutex);
}

#ifdef __cplusplus
}
#endif

#endif /* _LIBOBJC */

#endif /* ! _GLIBCPP_GCC_GTHR_TOPPERS_H */
