/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  
 */


#define _MACRO_ONLY

/*
 *	ͥѤΥȥåץ⥸塼BLACKfinѡ
 */
 
#include "jsp_kernel.h"
 


			// ߡ㳰ꥯȤ㳰
#define RETURNREQ 0xf

			// 32bit 쥸¨ͤɤޥ
#ifdef __GNUC__
#define LOADLABEL( reg, value32 ) reg##.h = value32; reg##.l = value32;
#define LOADVALUE( reg, value32 ) reg##.h = ( value32 >> 16 ) &0xFFFF; reg##.l = value32 & 0xFFFF;
#elif defined(__ECC__)
#define LOADVALUE( reg, value32 ) reg##.h = hi(value32); reg##.l = lo(value32);
#define LOADLABEL LOADVALUE
#else
#error "Compiler is not supported"
#endif


#ifdef __GNUC__
#include "cdef_LPBlackfin.h"		/* gnu tool chain */
#elif defined(__ECC__)
#include <cdef_lpblackfin.h>	/* VisualDSP++ */
#else
#error "Compiler is not supported"
#endif

#include "saverestore.h"


#ifdef __GNUC__
.section .init;
.extern _boot_for_gdb;
.extern __bss_start, __bss_end;
#elif defined(__ECC__)
.section program;
#else
#error "Compiler is not supported"
#endif

.global start;
.extern _exc_vector;
.extern ldf_stack_end;
.extern _kernel_start;
.extern _reqflg;

#ifdef USE_RUNTIME_INIT
.extern _mi_initialize;
#endif

start:
	R0 = 0;
	LC0 = R0;
	LC1 = R0;
	L0 = R0;
	L1 = R0;
	L2 = R0;
	L3 = R0;
    LOADLABEL( p0, ldf_stack_end )
    sp = p0;
#ifdef __GNUC__                 // bssΰν
    LOADLABEL( r0, __bss_start) // bss
    LOADLABEL( r1, __bss_end )
    r2 = r1 - r0;            // bssΥ
    p0 = r0;                // ϥɥ쥹
    p2 = r2;
    r0 = 0;
    loop bssfill lc0 = p2; 
loop_begin bssfill
        b[p0++] = r0;
loop_end bssfill;

    sp += -12;
    call _boot_for_gdb;     // gdbǥɤȤ˥ꥻåȤμ¤ˤ뤿Υ
    sp += 12;
#elif defined(__ECC__)
#else
#error "Compiler is not supported"
#endif

#ifdef USE_RUNTIME_INIT			// board_config.h 򻲾
	sp += -12;
	call _mi_initialize;		// ơ֥
	sp += 12;
	cc = r0;					// ֤ͤå
invalid : 
	if cc jump invalid; 		// 0ʤ饨顼
#endif
					// TOPPERS/JSP for BLACKfin emu,rst,nmiʤ
	LOADVALUE( p0,EVT0+2*4)	// NMI٥ȥ
	p1 = 4;


	LOADLABEL( r0, nmiEntry )		// NMI
	[p0++p1] = r0;

	LOADLABEL( r0, expEntry)		// EXP
	[p0++p1] = r0;

	p0 = p0+p1;					// ͽΰ򥹥å

	LOADLABEL( r0, ivHWEntry)		// ϡɥ顼
	[p0++p1] = r0;

	LOADLABEL( r0, ivTMREntry)		// ޡ
	[p0++p1] = r0;

	LOADLABEL( r0, ivg7Entry)		// IVG7
	[p0++p1] = r0;

	LOADLABEL( r0, ivg8Entry)		// IVG8
	r0.H = ivg8Entry;
	[p0++p1] = r0;

	LOADLABEL( r0, ivg9Entry)		// IVG9
	[p0++p1] = r0;

	LOADLABEL( r0, ivg10Entry)		// IVG10
	[p0++p1] = r0;

	LOADLABEL( r0, ivg11Entry)		// IVG11
	[p0++p1] = r0;

	LOADLABEL( r0, ivg12Entry)		// IVG12
	[p0++p1] = r0;

	LOADLABEL( r0, ivg13Entry)		// IVG13
	[p0++p1] = r0;

	LOADLABEL( r0, ivg14Entry)		// IVG14
	[p0++p1] = r0;

	LOADLABEL( r0, task_level)		// IVG15ϥܤ뤿Υȥ꡼
	[p0++p1] = r0;
	
	LOADLABEL( p2, user)				// ߡϤ
	reti = p2;
	csync;
	raise	15;					// IVG15롣ߤٱȯ롣
	
	r0 = 0xC01F(z);				// IVG15ղǽ(CPUå)
	sti r0;
	csync;
	rti;						// 桼⡼ɤܤ
	
task_level:                     // 饿μ¹Խ
    r0 = syscfg;
    r1 = 0x4;                   // աͥƥ󥰳
    r0 = r0 | r1;
    syscfg = r0;                // աͥȤͭ

    sp += -12;
#ifdef __GNUC__					/* GCC */
#elif defined(__ECC__)			/* VisualDSP++ */
#ifdef INIT_C_PLUS_PLUS
    r0 = 0;
    r1 = 0;
    call.x ___ctorloop;
#endif
#else
#error "Compiler is not supported"
#endif

    [--sp] = reti;				// ϤΤƤƳ߲ǽˤ
    jump.x _kernel_start;			// kernel_stgart()äƤʤ
user:
	jump	user;
start.end:




#ifdef __GNUC__
.section .text;
#elif defined(__ECC__)
.section program;
#else
#error "Compiler is not supported"
#endif

.extern interrupt_dispatcher;
.extern task_context;

/*
*	㳰Υȥ
*
*	ߤȤΥͥȴطĴ١ͥȤƤʤʤ饤٥ȥå򥻥åȤ롣
*		p0 : 桼㳰ϥɥΥɥ쥹
*		p1 : IPENDΥɥ쥹
*		p2 : reqflgΥɥ쥹
*		r6 : å
*		r7 : ASTAT
*
*/
expEntry:
	[--sp] = p0;	
	save_regs;					// 桼쥸

	LOADLABEL( p0, _exc_vector)		// 桼㳰ϥɥγǼɥ쥹
	LOADVALUE( p1, IPEND )			// IPEND쥸Υɥ쥹

	l0 = r0;
	l1 = r0;
	l2 = r0;
	l3 = r0;
	lc0 = r0;					// ǽ㲼ΤLCx򥯥ꥢ
	lc1 = r0;

	p0 = [p0];					// p0 = exc_vector	
	r0 = [p1];					// IPENDͤ
	r1 = 0x7fef;				// 
	r0 = r0 & r1;				// IVG15GIDʳĴ٤. r0.Hɬ0
	r0.L = ones r0;				// Υ٥Ȥο
	r0 += -1;					// ٥Ȥο-1ͥȤƤʤ0ˤʤ롣
	cc = r0 == 0;				// ͥȤƤʤп
	if !cc jump call_exception; // ⤷ͥȤƤХϥɥƤ
								// ͥȤƤʤ٥Ȥʤ顢åڤؤ
	r6 = sp;					// åݥ󥿤
	LOADLABEL( r0, ldf_stack_end)	// ٥ȥåݥ󥿤
	sp = r0;
	
call_exception:
	r7 = astat;					// ccˤϥͥȾäƤ롣
	r0 = p1;					// IPENDΥɥ쥹
	sp += -12;					// ߡΰ (E)
	call	(p0);				// Cǽ񤫤줿㳰ϥɥƤ
	sp += 12;					// ߡΰ賫 (E)
	astat = r7;					// cc
	if !cc jump get_back_x;		// ⤷ͥȤƤʤСΤޤ޵
	
								// Ǥϥ٥ȤϥͥȤƤʤ
	sp = r6;					// å򥿥å

	LOADLABEL( p2, _reqflg )
	r0 = [p2];					// reqflgͤ
	cc = r0;					// ǥѥå㳰׵ϽФƤ뤫
	if !cc jump get_back_x;		// ФƤʤʤгޤ줿

								// ƥڤؤȳ
	r0 = 0;						// 
	[p2] = r0;					// reqflg򥯥ꥢ.
	r0 = retx;					// ϤФ
	r1 = 1;
	r0 = r1 | r0; 				// աͥȤǤȵ
	[--sp] = r0;				// Ϥ򥹥åˤĤ
	LOADLABEL( p0, task_context)
	
	cli r0;						// ߤCPUå֤
	[--sp] = r0;				// å֤
	r1 = 0xC01F(z);				// ƥȤϤCPUå֤Ǽ¹Ԥ
	
#ifdef UNMANAGED_INT
    r2 = UNMANAGED_INT(z);
    r0 = r0 & r2;				// ߤΥޥ֤
    r1 = r0 | r1;				// ƥȤCPUå֤Ǽ¹Ԥ
#endif
	sti r1;						// CPUå (F)
	
	retx = p0;					// ٥"taskiv_context"㳰Ϥˤ
	rtx;						// 㳰롣ƥȤϥˤʤ
	
get_back_x:	
	restore_regs;				// 򤷤쥸᤹
	p0=[sp++];
	rtx;
expEntry.end:

// ٥ȥϥɥΥȥ꡼ɷ
// EVTΥȥˤбʲΥɤΥ٥뤬Ǽ롣
// 줾Υɤϥ٥ˤp0˳Ǽ塢
// interrupt_dispatcher˥פ
// evtvectorϥ桼ϥɥؤΥݥ󥿤




ivHWEntry:
	[--sp] = p0;
	p0 = 5;
	jump.x interrupt_dispatcher;
ivHWEntry.end:

ivTMREntry:
	[--sp] = p0;
	p0 = 6;
	jump.x interrupt_dispatcher;
ivTMREntry.end:

ivg7Entry:
	[--sp] = p0;
	p0 = 7;
	jump.x interrupt_dispatcher;
ivg7Entry.end:

ivg8Entry:
	[--sp] = p0;
	p0 = 8;
	jump.x interrupt_dispatcher;
ivg8Entry.end:

ivg9Entry:
	[--sp] = p0;
	p0 = 9;
	jump.x interrupt_dispatcher;
ivg9Entry.end:

ivg10Entry:
	[--sp] = p0;
	p0 = 10;
	jump.x interrupt_dispatcher;
ivg10Entry.end:

ivg11Entry:
	[--sp] = p0;
	p0 = 11;
	jump.x interrupt_dispatcher;
ivg11Entry.end:

ivg12Entry:
	[--sp] = p0;
	p0 = 12;
	jump.x interrupt_dispatcher;
ivg12Entry.end:

ivg13Entry:
	[--sp] = p0;
	p0 = 13;
	jump.x interrupt_dispatcher;
ivg13Entry.end:

ivg14Entry:					// dispatch()γԤ
#if !defined(USE_TIC_CORE) && !defined(USE_HW_ERROR)
	csync;						// ޡǥƥåȤˤidle̿Ȥʤ
	idle;						// ٥Ԥ
	csync;
#endif
	[--sp] = reti;				// ߥͥȵ
	r1 = 0xffff(z);				// CPU åѥѥ
#ifdef UNMANAGED_INT
    cli r0;               // ߤΥޥФ
	r2 = UNMANAGED_INT(z);
	r0 = r0 & r2;				// ߤΤ߼Ф
	r2 = ~r2;					// եޥ
	r1 = r1 & r2;				// 
	r1 = r1 | r0;				// ߤθޥ
#endif
	sti r1;						// CPU å
	r1 = 0xC01F(z);				// CPU åѥѥ
    cli r0;               // ߤΥޥФ
                                // ߤȤʤ⡢ݸΤɬ
#ifdef UNMANAGED_INT
	r2 = UNMANAGED_INT(z);
	r0 = r0 & r2;				// ߤΤ߼Ф
	r1 = r1 | r0;				// ߤθޥ
#endif
	sti r1;
	reti=[sp++];				// ߥͥȶػ
	rti;
ivg14Entry.end:




nmiEntry:
	jump	nmiEntry;
	rtn;
nmiEntry.end:	




#ifdef __GNUC__
#elif defined(__ECC__)

#ifdef INIT_C_PLUS_PLUS
.section ctor;
	.align 4;
___ctor_table:
	.byte4=0;
.global ___ctor_table;
.type ___ctor_table,STT_OBJECT;
.extern ___ctorloop;
.section .gdt;
        .align 4;
___eh_gdt:
.global ___eh_gdt;
        .byte4=0;
.type ___eh_gdt,STT_OBJECT;
.section .frt;
        .align 4;
___eh_frt:
.global ___eh_frt;
        .byte4=0;
.type ___eh_frt,STT_OBJECT;
#endif  /* INIT_C_PLUS_PLUS */

#else
#error "Compiler is not supported"
#endif

