/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: clause.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

// $Header: /cvsroot/toppersjsp4bf/jsp/cfg/base/clause.h,v 1.1 2009/01/31 05:27:37 suikan Exp $

#ifndef CLAUSE_H
#define CLAUSE_H

#include "base/testsuite.h"
#include "base/parser.h"
#include "base/singleton.h"
#include "base/except.h"

#include <map>
#include <string>

#define INTEGER_CLAUSE_IDENTIFIER   "##INTEGER" //2Ϣ#ȼ̻Ҥ쵤˼ФȤϤǤʤΤ̾Ťʤ뤳ȤϤʤ
#define LITERAL_CLAUSE_IDENTIFIER   "##STRING"
#define OPERATOR_CLAUSE_IDENTIFIER  "##OPERATOR"

    //ʸΰ륯饹
class Clause
{
public:
        //֤̾°Υޥå
    typedef std::map<std::string, Clause *> map_type;

        //̾
    class Namespace : public std::map<std::string, map_type>
    { public: SINGLETON_CONSTRUCTOR(Namespace) throw() {} };

protected:
    static map_type * getClauseMap(std::string ns) throw();

        //ȡ󤫤鼱̾
    static std::string getClauseIdentifier(Token token) throw();

        //ȤϿ
    void   addClause(std::string ns, std::string identifier) throw();

        //ʬʣleading identifierбդ
    void   addMultipleClauses(std::string ns, std::string identifier_list) throw();

protected:  /* 󥿥ե */

        //ѡ
    virtual void before(const Token & first, Parser & p);
    virtual void body  (const Token & first, Parser & p) = 0;
    virtual void after (const Token & first, Parser & p);

        //ѡԻβ
    virtual void onFail(const Token & first, Parser & p) throw();

public:
    Clause(void) throw() {}
    virtual ~Clause(void) throw() {}

        //ͭȽ
    inline bool isValid(void) const throw()
    {   return (this != 0);   }

        //β
    static bool parseClause(std::string ns, Parser & p);

        //firstǻϤޤ᤬뤫
    static bool hasClause(std::string ns, std::string first) throw();

        //[إ] ϿƤΰ
    static std::string makeClauseList(std::string ns, int width = 80) throw();

    TESTSUITE_PROTOTYPE(main)
};


    /*
     *   ŪAPI
     */
#define NAMESPACE_STATICAPI "StaticAPI"

class StaticAPI : public Clause
{
protected:

    virtual void before(const Token & first, Parser & p);
    virtual void after (const Token & first, Parser & p);

        //ѡԻβ
    virtual void onFail(const Token & first, Parser & p) throw();

public:
        //ǥեȥ󥹥ȥ饯 (⤷ʤ)
    StaticAPI(void) throw() {}      
        //API̾ꤷ (regist)
    StaticAPI(std::string apinamelist) throw()
    {   addMultipleClauses(NAMESPACE_STATICAPI, apinamelist);   }

    inline void regist(std::string apinamelist) throw()
    {   addMultipleClauses(NAMESPACE_STATICAPI, apinamelist);   }

        //β
    static bool parseStaticAPI(Parser & p)
    {   return Clause::parseClause(NAMESPACE_STATICAPI, p);   }

        //firstǻϤޤ᤬뤫
    inline static bool hasStaticAPI(std::string first) throw()
    {   return Clause::hasClause(NAMESPACE_STATICAPI, first);   }

        //[إ] ϿƤΰ
    inline static std::string makeClauseList(int width = 80) throw()
    {   return Clause::makeClauseList(NAMESPACE_STATICAPI, width);   }

        //å
    static void skip(Parser & p, bool invalid_api = true) throw();

    TESTSUITE_PROTOTYPE(main)
};


    /*
     *   ץץǥ쥯ƥ
     */
#define NAMESPACE_DIRECTIVES "Directives"

class Directives : public Clause
{
protected:

    virtual void after(const Token & first, Parser & p) throw(Exception);

        //ѡԻβ
    virtual void onFail(const Token & first, Parser & p) throw();

public:
        //ǥեȥ󥹥ȥ饯 (⤷ʤ)
    Directives(void) throw() {}      
        //API̾ꤷ (regist)
    Directives(std::string apinamelist) throw()
    {   addMultipleClauses(NAMESPACE_DIRECTIVES, apinamelist);   }

    inline void regist(std::string apinamelist) throw()
    {   addMultipleClauses(NAMESPACE_DIRECTIVES, apinamelist);   }

        //β
    inline static bool parseDirectives(Parser & p)
    {   return Clause::parseClause(NAMESPACE_DIRECTIVES, p);   }

        //firstǻϤޤ᤬뤫
    inline static bool hasDirectives(std::string first) throw()
    {   return Clause::hasClause(NAMESPACE_DIRECTIVES, first);   }

        //[إ] ϿƤΰ
    inline static std::string makeClauseList(int width = 80) throw()
    {   return Clause::makeClauseList(NAMESPACE_DIRECTIVES, width);   }

    TESTSUITE_PROTOTYPE(main)
};

#endif



