/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: coverage.cpp,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

#include "base/coverage_defs.h"
#include "base/coverage_undefs.h"

#include <iostream>
#include <iomanip>

using namespace std;

#if defined(COVERAGE)
/*
 *   ñʥХåå
 */

    //եޥåȺѤߥե־μ
string Coverage::Location::getDetails(void) const
{
    string result;

    result = string(filename) + ":" + String(lineno);
    if(*additional != '\x0')
        result += string("(") + additional + ")";

    return result;
}



    //Ǥ
Coverage::BranchMap::~BranchMap(void) throw()
{
    iterator scope;

    scope = begin();
    while(scope != end()) {
        delete scope->second;
        ++ scope;
    }

    clear();
}

    //ǤϿ
Coverage::BranchBase::BranchBase(const Location & location) throw()
{
    BranchMap * bmap = Singleton<BranchMap>::getInstance();
    NewBranchList * blist = Singleton<NewBranchList>::getInstance();

    (*bmap)[location] = this;
    blist->push_back(this);
}

    //location˰פǤμ
Coverage::BranchBase * Coverage::BranchBase::find(const Location & location) throw()
{
    BranchMap * bmap = Singleton<BranchMap>::getInstance();
    BranchMap::iterator scope;
    BranchBase * result = 0;

    scope = bmap->find(location);
    if(scope != bmap->end())
        result = scope->second;

    return result;
}

    //BranchIf󥹥ȥ饯
Coverage::If::If(const Location & location) throw() : BranchBase(location), true_case(false), false_case(false)
{}

    //ifȽ (Ω/ΩξäƤ)
bool Coverage::If::checkValidity(void) const throw()
{   return true_case && false_case;   }

    //̲μ
string Coverage::If::getDetails(void) const throw()
{
    string result;

    if(true_case)
        result += "true";

    if(false_case) {
        if(true_case)
            result += "/";
        result += "false";
    }

    return result;
}

    //ifʬΥå
bool Coverage::If::branch(const Location & location, bool expression) throw()
{
    If * node = dynamic_cast<If *>(find(location));
    if(node == 0)
        node = new(nothrow) If(location);

    if(node != 0) {
        if(expression)
            node->true_case = true;
        else
            node->false_case = true;
    }
    else
        cerr << "[Coverage::Branch] Memory allocation error!\n";

    return expression;
}


    //While󥹥ȥ饯
Coverage::While::While(const Location & location) throw() : BranchBase(location), valid(false)
{}

    //WhileȽ (ʤȤϥ롼פޤäƤ)
bool Coverage::While::checkValidity(void) const throw()
{   return valid;   }

    //̲μ
string Coverage::While::getDetails(void) const throw()
{
    string result;

    if(valid)
        result = "valid";
    else
        result = "invalid";

    return result;
}

    //whileʬΥå (ʤȤϥ롼פޤäƤ)
bool Coverage::While::branch(const Location & location, bool expression) throw()
{
    While * node = dynamic_cast<While *>(find(location));
    if(node == 0)
        node = new(nothrow) While(location);

    if(node != 0) {
        if(expression)
            node->valid = true;
    }
    else
        cerr << "[Coverage::Branch] Memory allocation error!\n";

    return expression;
}


    //Switch󥹥ȥ饯
Coverage::Switch::Switch(const Location & location) throw() : BranchBase(location)
{}

    //SwitchȽ (̲ᤷǤФƤ (塹Ƚ줿))
bool Coverage::Switch::checkValidity(void) const throw()
{   return true;   }

    //̲μ
string Coverage::Switch::getDetails(void) const throw()
{
    stringstream buf;
    set<int>::const_iterator scope;

    scope = checkpoint.begin();
    while(scope != checkpoint.end()) {
        buf << *scope;

        ++ scope;
        if(scope != checkpoint.end())
            buf << ", ";
    }
        
    return buf.str();
}

    //SwitchʬΥå
void Coverage::Switch::_branch(const Location & location, int expression) throw()
{
    Switch * node = dynamic_cast<Switch *>(find(location));
    if(node == 0)
        node = new(nothrow) Switch(location);

    if(node != 0) {
        if(expression)
            node->checkpoint.insert(expression);
    }
    else
        cerr << "[Coverage::Branch] Memory allocation error!\n";
}

    //Ƥιܤɽ
void Coverage::printCoverage(ostream & out)
{
    BranchMap * bmap = Singleton<BranchMap>::getInstance();
    BranchMap::iterator scope;

    unsigned long cases = 0;
    unsigned long fails = 0;

    scope = bmap->begin();
    while(scope != bmap->end()) {
        ++ cases;

        if(scope->second->checkValidity())
            out << "Success : ";
        else {
            out << "Failure : ";
            ++ fails;
        }
        out << scope->first.getDetails() << ' ' << scope->second->getDetails() << '\n';

        ++ scope;
    }

    out << fails << " fails in " << cases << " cases (" << setprecision(2) << (fails * 100.0 / cases) << "%)\n";
}

    //̲ᤷɤΥå
bool Coverage::checkValidity(void)
{
    bool result = true;

    NewBranchList * blist = Singleton<NewBranchList>::getInstance();
    NewBranchList::iterator scope;

    scope = blist->begin();
    while(scope != blist->end()) {
        if(!(*scope)->checkValidity())
            result = false;
        ++ scope;
    }

    blist->clear();
    return result;
}
    //̾Τμ
string Coverage::getBranchName(BranchBase * node)
{
        //פǤθ
    BranchMap * bmap = Singleton<BranchMap>::getInstance();
    BranchMap::iterator scope;

    scope = bmap->begin();
    while(scope != bmap->end()) {
        if(scope->second == node)
            break;
        ++ scope;
    }

    //assert(scope != bmap->end());
    
    return scope->first.getDetails();
}

#endif /* COVERAGE */

