/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: manager.cpp,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

// $Header: /cvsroot/toppersjsp4bf/jsp/cfg/base/manager.cpp,v 1.1 2009/01/31 05:27:37 suikan Exp $

#ifdef _MSC_VER
#  pragma warning(disable:4786)
#  define CDECL __cdecl
#else
#  define CDECL
#endif

#include <stdlib.h>
#include <fstream>
#include <iostream>

#include "base/event.h"
#include "base/message.h"
#include "base/component.h"
#include "base/directorymap.h"

using namespace std;

Event<StartupEvent>   startupEvent;
Event<ShutdownEvent>  shutdownEvent;

int CDECL main(int argc, char ** argv)
{
    ShutdownEvent evt;
    OptionParameter & option= getOptionParameter();

    evt.exit_code = EXIT_FAILURE;

    if(SingletonBase::isValid() && Component::isValid()) {

        option.parseOption(argc, argv, "-h");

        try {
            startupEvent.raise();
            Component::executeComponents(option);
            evt.exit_code = EXIT_SUCCESS;
        }
        catch(Exception & e)
        {
            cerr << Message("Program failed in its process by following reason.\n","ץ̿Ūʥ顼ˤǤޤ.\n");
            cerr << "  " << e.getDetails() << '\n';
        }
        catch(ExceptionMessage & e) {
            CHECKPOINT("catch(ExceptionMessage)");
            cerr << "Program failed : " << e << '\n';
        }
        catch(bad_alloc & e) {
            CHECKPOINT("catch(bad_alloc)");
            cerr << "Program failed : bad_alloc (" << e.what() << ")\n";
        }
        catch(...) {
            CHECKPOINT("catch(...)");
            cerr << "Program filed : Unknown Exception Occured\n";
        }
    }
    else
        cerr << "Program initialization failure\n";

    try {
        DebugMessage("shutdown event - exitcode(%)\n") << evt.exit_code;
        shutdownEvent.raise(evt);
    }
    catch(Exception & e)
    {
        DebugMessage("exception was raised in the event - %\n") << e.getDetails();
        cerr << Message("Program failed in its process by following reason.\n","ץ̿Ūʥ顼ˤǤޤ.\n");
        cerr << "  " << e.getDetails() << '\n';
    }

    catch(...) {
        DebugMessage("exception was raised in the event\n");
        CHECKPOINT("catch(...) in shutdownEvent::raise");
        evt.exit_code = EXIT_FAILURE;
    }

    DebugMessage("Exit code (%)\n") << evt.exit_code;

    return evt.exit_code;
}

/************************************* ƥȥ *************************************/

#ifdef TESTSUITE
#include "coverage_undefs.h"

namespace {

    extern void testsuite(TestSuiteControl & _suite_control);
    TestSuite testsuite_onTop("Entrypoint(main)", testsuite);

    class TestComponent : public Component
    {
    public:
        int mode;

        void parseOption(OptionParameter &)
        {
            switch(mode) {
                case 0:
                    CHECKPOINT("TestComponent::case 0");
                    break;
                case 1:
                    ExceptionMessage("exception").throwException();
                case 2:
                    throw bad_alloc();
            }
        }
    };

    void dummyStartupHandler(StartupEvent &)
    {
        TestSuite::check("dummyStartupHandler");
    }

    int dummyShutdownHandler_exit_code;
    void dummyShutdownHandler(ShutdownEvent & evt)
    {
        dummyShutdownHandler_exit_code = evt.exit_code;
        TestSuite::check("dummyShutdownHandler");
    }

        //ƥȥȤ
    void testsuite(TestSuiteControl & _suite_control)
    {
        SingletonBase::ContextChain chain;

        chain.saveContext<Component::ComponentInfo>();
        chain.saveContext<Event<StartupEvent>::handler_list_type>();
        chain.saveContext<Event<ShutdownEvent>::handler_list_type>();

        BEGIN_CASE("1","mainؿñ + ݡͥȤʤ") {
            chain.renewInstance();

            Event<StartupEvent>::add(dummyStartupHandler);
            Event<ShutdownEvent>::add(dummyShutdownHandler);

            BEGIN_CASE("1","̤˼¹Ԥ") {
                TestSuite::clearCheckpoints();

                char * argv[] = { "test.exe" };

                Exception::setThrowControl(true);
                TestComponent test;
                test.mode = 0;

                TEST_CASE("1","mainؿEXIT_SUCCESS֤", main(1, argv) == EXIT_SUCCESS);

                TEST_CASE("2","㳰¹Ԥʤ catch(Exception)", !TestSuite::isReached("catch(Exception)"));
                TEST_CASE("3","㳰¹Ԥʤ catch(bad_alloc)", !TestSuite::isReached("catch(bad_alloc)"));
                TEST_CASE("4","㳰¹Ԥʤ catch(...)",       !TestSuite::isReached("catch(...)"));
                TEST_CASE("5","Component¹ԤƤ", TestSuite::isReached("TestComponent::case 0"));
                TEST_CASE("6","ȥåץϥɥ餬ưƤ", TestSuite::isReached("dummyStartupHandler"));
                TEST_CASE("7","åȥϥɥ餬ưƤ", TestSuite::isReached("dummyShutdownHandler"));
                TEST_CASE("8","åȥϥɥEXIT_SUCCESSƤ", dummyShutdownHandler_exit_code == EXIT_SUCCESS);
            } END_CASE;

            BEGIN_CASE("2","Exception㳰֤") {
                TestSuite::clearCheckpoints();

                char * argv[] = { "test.exe" };

                Exception::setThrowControl(true);
                TestComponent test;
                test.mode = 1;

                TEST_CASE("1","mainؿEXIT_FAILURE֤", main(1, argv) == EXIT_FAILURE);

                TEST_CASE("2","㳰¹Ԥ   catch(Exception)", TestSuite::isReached("catch(Exception)"));
                TEST_CASE("3","㳰¹Ԥʤ catch(bad_alloc)", !TestSuite::isReached("catch(bad_alloc)"));
                TEST_CASE("4","㳰¹Ԥʤ catch(...)",       !TestSuite::isReached("catch(...)"));
                TEST_CASE("5","ȥåץϥɥ餬ưƤ", TestSuite::isReached("dummyStartupHandler"));
                TEST_CASE("6","åȥϥɥ餬ưƤ", TestSuite::isReached("dummyShutdownHandler"));
                TEST_CASE("7","åȥϥɥEXIT_FAILUREƤ", dummyShutdownHandler_exit_code == EXIT_FAILURE);
            } END_CASE;

            BEGIN_CASE("3","bad_alloc㳰֤") {
                TestSuite::clearCheckpoints();

                char * argv[] = { "test.exe" };

                Exception::setThrowControl(true);
                TestComponent test;
                test.mode = 2;

                TEST_CASE("1","mainؿEXIT_FAILURE֤", main(1, argv) == EXIT_FAILURE);

                TEST_CASE("2","бcatchΤߤ¹ԤƤ", !TestSuite::isReached("catch(Exception)") && TestSuite::isReached("catch(bad_alloc)") && !TestSuite::isReached("catch(...)"));
                TEST_CASE("3","ȥåץϥɥ餬ưƤ", TestSuite::isReached("dummyStartupHandler"));
                TEST_CASE("4","åȥϥɥ餬ưƤ", TestSuite::isReached("dummyShutdownHandler"));
                TEST_CASE("5","åȥϥɥEXIT_FAILUREƤ", dummyShutdownHandler_exit_code == EXIT_FAILURE);
            } END_CASE;
        } END_CASE;

        chain.restoreContext();
    }

}

#endif


