/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: option.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

// $Header: /cvsroot/toppersjsp4bf/jsp/cfg/base/option.h,v 1.1 2009/01/31 05:27:37 suikan Exp $

#ifndef OPTION_H
#define OPTION_H

#include "base/testsuite.h"
#include "base/singleton.h"

#include <string>
#include <vector>
#include <map>

#define DEFAULT_PARAMETER "#default"

using namespace std;

/*
 *   ץѥ᡼륯饹
 */
class OptionParameter
{
public:
    class OptionItem : public std::string
    {
    protected:
        bool                      checked;  //Ѥɤ
        std::vector<std::string>  param;    //ץ

    public:
            //󥹥ȥ饯
        OptionItem(void) throw() : string(DEFAULT_PARAMETER), checked(false) {}
        OptionItem(const std::string & name) throw() : string(name), checked(false) {}
        OptionItem(const OptionItem & src) throw() : string(src), checked(src.checked), param(src.param) {}

            //ץѥ᡼ϤOptionItem
        static bool createItem(OptionItem & item, string & argv);

            //̤OptionItemĥѥ᡼ʬɲä
        void mergeItem(const OptionItem & src);

            //ѥ᡼ɲ
        inline void addParameter(const std::string & src) throw()
        {   param.push_back(src);   }

            //ѥ᡼μ
        inline size_t countParameter(void) const throw()
        {   return param.size();    }

            //ѥ᡼äƤ뤫ɤ
        inline bool hasParameter(void) const throw()
        {   return countParameter() != 0;   }

            //֤ꤷƥѥ᡼򻲾 (̵ʰ֤ȶʸ)
        inline std::string operator[](std::vector<std::string>::size_type offset) const throw()
        {
            string result;

            if(offset < countParameter())
                result = param[offset];

            return result;
        }

            //ΥץѤȤ򵭤 (OptionParameter𤷤ƤѤΤߤʤΤ "_" ĤƤ)
        inline void _check(void) throw()
        {   checked = true;   }

            //Υץ˿äɤ
        inline bool isChecked(void) const throw()
        {   return checked;   }

            //ͭɤ (ʤʤ̵)
        inline bool isValid(void) const throw()
        {   return !empty();   }

            //̵ʥץ󥢥ƥ
        static OptionItem createInvalidItem(void) throw();

            //ƤΥѥ᡼礷Τ
        std::string getParameters(std::string punctuator = " ") const throw();

            //ѥ᡼θĿå
        bool checkParameterCount(size_t count, bool allow_zero = false) const throw();

        TESTSUITE_PROTOTYPE(main)
    };

protected:
        //ץǼѿ
    std::map<std::string, OptionItem> container;    //set::begin()const_iterator֤ʤΤǻʤmapѤ (ͤ...)

        //ץ̾
    std::string program_name;

        //ޥɥ饤Ϥ줿Τ
    std::string cmdline;    

        //ǥեȥ󥹥ȥ饯 (ƥ)
    OptionParameter(void) throw() {}

        //Ǥθ
    std::map<std::string, OptionItem>::iterator _find(const std::string & name, bool check = true) throw();

public:

        //󥰥ȥ󥳥󥹥ȥ饯
    SINGLETON_CONSTRUCTOR(OptionParameter) throw() {}

        //ץѥ᡼Υѡ
    bool parseOption(int _argc, char const * const * _argv, char const * _default = NULL) throw();

        //ƤΥץ󤬻Ѥ줿ɤγǧ
    bool validateOption(void) const throw();

        //Ѥʤäץ
    std::string getInvalidOptions(void) const throw();

        //ƥο
    inline size_t countItem(void) const throw()
    {   return container.size();   }

        //ץ󥢥ƥλ
    OptionItem get(const std::string & name, bool check = true) throw();
    
    inline OptionItem operator [] (const std::string & name) throw()
    {   return get(name);   }
    
    inline OptionItem operator [] (const char * name) throw()
    {   return get(string(name));   }

        //ץ̵ͭθ
    inline bool find(std::string name) throw()
    {   return get(name).isValid(); }


        //ȥޡĤ
    inline bool check(const std::string & name) throw()
    {   return _find(name) != container.end();   }

    inline bool check(const char * name) throw()
    {   return check(string(name));   }

        //ץ̾
    inline const std::string & getProgramName(void) const throw()
    {   return program_name;    }

        //򤽤Τޤ޼ (ץ̾ϴޤޤ)
    inline const std::string & getCommandLine(void) const throw()
    {   return cmdline;   }

    TESTSUITE_PROTOTYPE(main)
};

    /* ƥñOptionParameter뤿δؿ */
inline OptionParameter & getOptionParameter(void) throw()
{   return *Singleton<OptionParameter>::getInstance();   }

#endif


