/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: singleton.h,v 1.2 2009/06/12 13:30:29 suikan Exp $
 */

// $Header: /cvsroot/toppersjsp4bf/jsp/cfg/base/singleton.h,v 1.2 2009/06/12 13:30:29 suikan Exp $

#include "base/testsuite.h"

#ifndef SINGLETON_H
#define SINGLETON_H

#ifdef _MSC_VER
#  pragma warning(disable:4290) //C++ 㳰λ̵뤵ޤؿ __declspec(nothrow) ǤʤȤΤɽޤ
#  pragma warning(disable:4291) //ݥɤ㳰򥹥ݤȡ'new' 黻ҤѤƤȥޤ
#  pragma warning(disable:4786) //ǥХåǼ̻Ҥ 255 ʸڤΤƤޤ
#endif

#include <new>
#include <stdexcept>
#include <cstdlib>

/*
 *  󥰥ȥѥ 
 */

    //󥰥ȥ쥯饹
    //  #gccfriend class Singleton򿩤äƤʤΤǴ
class SingletonBase {
public:
        //ǥȥ饯Υ
    struct chain {
        struct chain * next;
        void (*destructor)(void);
    };

        //󥰥ȥǥ󥹥󥹤Ȥ򼨤Υ饹
        //    Υ饹Singleton餷βǤʤΤǡ
        //    ۤΥ饹餳ˤĥ󥹥ȥ饯Ѥ뤳ȤϤǤʤ
    class SingletonConstructionLocker
    {
    friend class SingletonBase;
    protected:
        SingletonConstructionLocker() {}
    };

private:
    static bool   initialize;       //Ѥߤ (atexitƤɤ)
    static bool   is_valid;         //˼Ԥ󥰥ȥ󥬤뤫ɤ
    static struct chain * top;      //ǥȥ饯

        //ǥȥ饯εư
    static void final_release(void) throw()
    {
            //Ƭ (Ф)
        while(top != 0) {
            struct chain * node = top;
            top = node->next;

            (*node->destructor)();

            delete node;
        }
    }

protected:
        //˥ǥȥ饯ɲ
    static bool addDestructor(void (* destructor)(void)) throw()
    {
        bool result = false;
        struct SingletonBase::chain * node = new(std::nothrow) struct SingletonBase::chain;
        if(node != 0) {

                //ǤƬɲ
            node->next       = top;
            node->destructor = destructor;
            
            top = node;

            result = true;

                //˴Τ˺Ǹ˴롼ư
            if(!initialize) {
                atexit(final_release);
                initialize = true;
            }
        }
        return result;
    }

        //SingletonConstructionLockerեȥ
    inline static SingletonConstructionLocker getLocker(void)
    {   return SingletonConstructionLocker();   }

public:
        //˼Ԥ󥰥ȥ󤬤ʤȤ
    static bool isValid(void) throw()
    {   return is_valid;   }

#ifdef TESTSUITE
        /*
         *   ƥȥ (ƥѥ󥰥ȥ󥳥ƥ)
         */
    class ContextChain {
    protected:
        struct chain {
            struct chain * next;
            void * context;
            void (*restore)(void * & context) throw();
            void (*renew)(void) throw();
            void (*clear)(void);
        } * top;

    public:
        ContextChain(void) throw() : top(0)
        {}

        ~ContextChain(void) throw()
        {   restoreContext();   }

            /* ƥȤ */
        void restoreContext(void) throw()
        {
            while(top != 0) {
                struct chain * node = top;
                top = top->next;

                (*node->restore)(node->context);
                delete node;
            }
        }

            /* ƤΥ󥹥󥹤 */
        void renewInstance(void) throw(std::bad_alloc)
        {
            struct chain * node = top;
            while(node != 0) {
                (*node->renew)();
                node = node->next;
            }
        }
            
            /* ƤΥ󥹥󥹤˴ */
        void clearInstance(void) throw(std::bad_alloc)
        {
            struct chain * node = top;
            while(node != 0) {
                (*node->clear)();
                node = node->next;
            }
        }
            
            /* ƥȤ */
        template<class T> void saveContext(void) throw(std::bad_alloc)
        {
            struct chain * node = new struct chain;

            node->next = top;
            node->restore = reinterpret_cast<void(*)(void*&)>(Singleton<T>::restoreContext);
            node->renew   = Singleton<T>::renewInstance;
            node->clear   = Singleton<T>::clearInstance;

            Singleton<T>::saveContext(reinterpret_cast<Singleton<T>::Context &>(node->context));

            top = node;
        }
    };
#endif


    TESTSUITE_PROTOTYPE(main)
};


template<class T>
class Singleton : SingletonBase
{
protected:
    Singleton(void);
    ~Singleton(void);

    static T * instance;

        //ǥȥ饯
    static void destructor(void) throw()
    {
        if(instance != 0) {
            try{ delete instance; } catch(...) {}
            instance = 0;
        }
    }

        //󥹥󥹤 (󥹥 + ǥȥ饯Ͽ + 顼)
    static T * createInstance(std::nothrow_t) throw()
    {
        T * instance = 0;
        try {
            instance = new(std::nothrow) T(getLocker());

            if(instance != 0) {
                if(!addDestructor(destructor))
                    throw false;    //catch¹Ԥ
            }
        }
        catch(...) {
            if(instance != 0) {
                try { delete instance; } catch(...) {}
                instance = 0;
            }
        }
        return instance;
    }

        //󥹥 (bad_alloc㳰򥹥)
    static T * createInstance(void) throw(std::bad_alloc)
    {
        instance = createInstance(std::nothrow);
        if(instance == 0)
            throw std::bad_alloc();
        return instance;
    }

public:
        //󥹥󥹤μ
    inline static T * getInstance(void) throw(std::bad_alloc)
    {
        if(instance == 0)
            instance = createInstance();
        return instance;
    }

        //󥹥󥹤μ
    inline static T * getInstance(std::nothrow_t) throw()
    {
        if(instance == 0)
            instance = createInstance(std::nothrow);
        return instance;
    }

#ifdef TESTSUITE    /* ƥ */

    typedef T * Context;    //

        //󥹥󥹤
    static void renewInstance(void) throw(std::bad_alloc)
    {
        destructor();                     //Υ󥹥󥹤˴
        instance = new T(getLocker());    //󥹥󥹤 (ǥȥ饯ϿƤޤΤcreateInstanceƤǤϤʤ)
    }

        //󥹥˴
    static void clearInstance(void) throw()
    {   destructor();   }

        //ƥ
    static void saveContext(Context & context) throw()
    {
        context  = instance;
        instance = 0;
    }

        //ƥ
    static void restoreContext(Context & context) throw()
    {
        destructor();           //Υ󥹥󥹤˴
        instance = context;     //򤷤󥹥󥹤
    }

#endif /* TESTSUITE */

};



    //Singleton Ūѿ
template<class T> T * Singleton<T>::instance = 0;

#define SINGLETON_CONSTRUCTOR(x)  explicit x(const SingletonBase::SingletonConstructionLocker &)
#define SINGLETON_CONSTRUCTOR_(x) explicit x(const SingletonBase::SingletonConstructionLocker & _singleton)

#define SINGLETON_WRAPPER(derived, base) class derived : public base { public: SINGLETON_CONSTRUCTOR_(derived) throw() : base(_singleton) {} };

#endif /* SINGLETON_H */

