/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: jsp_common.cpp,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

#include "jsp/jsp_common.h"

#include "base/option.h"

#include <ctime>

#if defined(_MSC_VER) || defined(__BORLANDC__)
#  define  GETLOGINNAME_WINDOWS
#  include <windows.h>
#elif __GNUC__
#  define  GETLOGINNAME_UNIX
#  include <unistd.h>
#endif

using namespace std;

#if 0
namespace {
    string get_loginname(void) throw()
    {
        string result("TOPPERS/JSP KernelConfigurator");

#ifdef GETLOGINNAME_WINDOWS
        char  buffer[1024];
        DWORD sz = 1024;
        ::GetUserName(buffer, &sz);
        result.assign(buffer);
#elif defined(GETLOGINNAME_UNIX)
        result.assign(getlogin());
#endif

        return result;
    }
}
#endif


    //󥯥롼ɥեηѹ
string ToppersJsp::conv_includefile(string file) throw()
{
    OptionParameter & option = getOptionParameter();
    string result;

        //ilץդȤˤ "<...>" ǽ
    if(option["il"].isValid())
        result = string("<") + file + ">";
    else
        result = string("\"") + file + "\"";

    return result;
}

    //ͥѿ̾ηѹ
string ToppersJsp::conv_kernelobject(string obj) throw()
{
    OptionParameter & option = getOptionParameter();
    string result;

    result = obj;

        // TOPPERS/JSP rel 1.3ϥͥѿƬ _kernel_ Ĥ
    if(!option["1.3"].isValid())
        result = string("_kernel_") + obj;

    return result;
}

ToppersJsp::SpecialtyFile::SpecialtyFile(void) throw() : MultipartStream(), RuntimeObject(true)
{}

#if 0
string ToppersJsp::get_agreement(string filename) throw()
{
    const char * base_agreement =
        "/*\n"
        " *  TOPPERS/JSP Kernel\n"
        " *      Toyohashi Open Platform for Embedded Real-Time Systems/\n"
        " *      Just Standard Profile Kernel\n"
        " * \n"
        " *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory\n"
        " *                              Toyohashi Univ. of Technology, JAPAN\n"
        " * \n"
        " *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation \n"
        " *  ˤäƸɽƤ GNU General Public License  Version 2 ˵\n"
        " *  ҤƤ˸¤ꡤܥեȥܥեȥ\n"
        " *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ\n"
        " *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥\n"
        " *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭\n"
        " *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ\n"
        " *      ˴ޤޤƤ뤳ȡ\n"
        " *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻\n"
        " *      ѤǤǺۤˤϡۤȼɥȡ\n"
        " *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ\n"
        " *      ̵ݾڵǺܤ뤳ȡ\n"
        " *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻\n"
        " *      ѤǤʤǺۤˤϡΤ줫ξ\n"
        " *      ȡ\n"
        " *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭\n"
        " *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ\n"
        " *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ\n"
        " *        𤹤뤳ȡ\n"
        " *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»\n"
        " *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ\n"
        " * \n"
        " *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ\n"
        " *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ\n"
        " *  ޤơʤݾڤԤʤޤܥեȥѤˤľ\n"
        " *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ\n"
        " * \n";

    string work(base_agreement);

        //CVSIDΤΤ򤯤äĤ
    time_t t;
    time(&t);

    work += string(" * @(#)$Id: ");
    work += filename;
    work += " ";
    work += static_cast<const char *>(asctime(localtime(&t)));
    
    work.erase(work.size() - 1);    //asctimeǲԤΤchomp

    work += " ";
    work += get_loginname();
    work += " Exp $\n */\n\n";

    return work;
}
#endif


/***************************************** ƥȥ *****************************************/

#ifdef TESTSUITE

class SpecialtyFile_test : public ToppersJsp::SpecialtyFile
{
public:
    ~SpecialtyFile_test(void) throw() { TestSuite::check("SpecialtyFile::~SpecialtyFile"); }
    TESTSUITE_PROTOTYPE(main)
};

TESTSUITE(main, SpecialtyFile_test)
{
    BEGIN_CASE("constructor","constructor") {
        BEGIN_CASE("1","ROT˾") {
            SpecialtyFile_test file;

            if(RuntimeObjectTable::getInstance<SpecialtyFile_test>() == 0)
                TEST_FAIL;
        } END_CASE;

        BEGIN_CASE("2","˴оݤˤʤäƤ") {
            Singleton<RuntimeObjectTable>::Context context;
            Singleton<RuntimeObjectTable>::saveContext(context);

            Singleton<RuntimeObjectTable>::renewInstance();

            new SpecialtyFile_test;

            TEST_CASE("0","[] ϿƤ", RuntimeObjectTable::getInstance<SpecialtyFile_test>() != 0);
            
            TestSuite::clearCheckpoints();
            Singleton<RuntimeObjectTable>::renewInstance(); //󥹥󥹤κROT

            TEST_CASE("1","ROTƤ", RuntimeObjectTable::getInstance<SpecialtyFile_test>() == 0);
            TEST_CASE("2","ǥȥ饯ưƤ", TestSuite::isReached("SpecialtyFile::~SpecialtyFile"));

            Singleton<RuntimeObjectTable>::restoreContext(context);
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("createInstance","createInstance") {
        BEGIN_CASE("1","󥹥󥹤Ǥ") {
            SpecialtyFile_test * file = SpecialtyFile::createInstance<SpecialtyFile_test>("test.txt");

            file->disableOutput();  //ϤƤ⺤Τ

            TEST_CASE("1","NULL֤", file != 0);
            TEST_CASE("2","ե̾",  file->getFilename().compare("test.txt") == 0);
        } END_CASE;

        BEGIN_CASE("2","ʸϤ㳰") {

            bool result = false;
            try {
                SpecialtyFile::createInstance<SpecialtyFile_test>("");
            }
            catch(Exception &) {
                result = true;
            }

            TEST_CASE("1","㳰", result);
            TEST_CASE("2","֥ȤϤʤ", RuntimeObjectTable::getInstance<SpecialtyFile_test>() == 0);
        } END_CASE;
    } END_CASE;
}

namespace {
    extern void testsuite(TestSuiteControl & _suite_control);
    TestSuite testsuite_onTop("TOPPERS/JSP Common Function(main)", testsuite);

            //ƥȥȤ
    void testsuite(TestSuiteControl & _suite_control)
    {
        Singleton<OptionParameter>::Context context;
        Singleton<OptionParameter>::saveContext(context);

        BEGIN_CASE("conv_includefile","conv_includefile") {
            BEGIN_CASE("1","-ilդƤʤȥ֥륯ȤǤ") {
                Singleton<OptionParameter>::renewInstance();

                if(ToppersJsp::conv_includefile("test.h").compare("\"test.h\"") != 0)
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("1","-ilդƤ<>Ǥ") {
                Singleton<OptionParameter>::renewInstance();
                char * argv[] = {"test.exe","-il"};
                getOptionParameter().parseOption(2, argv);

                if(ToppersJsp::conv_includefile("test.h").compare("<test.h>") != 0)
                    TEST_FAIL;
            } END_CASE;
        } END_CASE;

        BEGIN_CASE("conv_kernelobject","conv_kernelobject") {
            BEGIN_CASE("1","-1.3դƤʤ_kernel_դ") {
                Singleton<OptionParameter>::renewInstance();

                if(ToppersJsp::conv_kernelobject("test").compare("_kernel_test") != 0)
                    TEST_FAIL;
            } END_CASE;

            BEGIN_CASE("1","-1.3դƤȤΤޤ޽ФƤ") {
                Singleton<OptionParameter>::renewInstance();
                char * argv[] = {"test.exe","-1.3"};
                getOptionParameter().parseOption(2, argv);

                if(ToppersJsp::conv_kernelobject("test").compare("test") != 0)
                    TEST_FAIL;
            } END_CASE;
        } END_CASE;

        Singleton<OptionParameter>::restoreContext(context);

    }
}
#endif


