/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 */

/*
 *  ꥢI/OǥХSIO˥ɥ饤СBlackfin UARTѡ
 *
 *   ΥեϡTOPPERS/JSP 1.4.2 config/sh3/ms7727cp01/hw_serial.h
 *   ͡षμ̻ҤѹΤǤ롣
 *
 *   Υեϲ̤ΥǥХ롼«ͤƾ̤ؤϤ
 *   ΤΤǤ롣Blackfinγˤ륷ꥢTOPPERS/JSPǴʤ
 *   Τʤ顢ѹɬפϤʤ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>

#include "uart.h"



/*
 *  SIOɥ饤Фν롼
 */
#define sio_initialize  uart_initialize

#ifndef _MACRO_ONLY
/*
 *  ꥢI/OݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
    SIOPCB  *siopcb;

    /*
     *  ǥХ¸Υץ
     */
    siopcb = uart_opn_por(siopid, exinf);

	/*
	* Enable Corrensponding Interrupt at IMASK
	* Note that, this implementation has only 1 SIO in a system
	*/
	ena_int( INTNO_UART_TX );
	ena_int( INTNO_UART_RX );

    return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{

	/*
	 * ǤSIC_IMASKбӥåȤ򥯥ꥢʤSIC_IMASKΥꥢ
	 * Ǥ롣UARTγߤ uart_cls_porǶػߤΤ
	 * ʬǤ롣
	 */

    /*
     *  ǥХ¸Υ
     */
    uart_cls_por(siopcb);
}


/*
 *  SIOγߥϥɥ
 */
#define sio0_rx_handler uart0_rx_isr
#define sio0_tx_handler uart0_tx_isr

/*
 *  ꥢI/OݡȤؤʸ
 */
#define sio_snd_chr uart_snd_chr

/*
 *  ꥢI/OݡȤʸ
 */
#define sio_rcv_chr uart_rcv_chr

/*
 *  ꥢI/OݡȤΥХåε
 */
#define sio_ena_cbr uart_ena_cbr

/*
 *  ꥢI/OݡȤΥХåζػ
 */
#define sio_dis_cbr uart_dis_cbr

/*
 *  ꥢI/OݡȤǽХå
 */
#define sio_ierdy_snd   uart_ierdy_snd

/*
 *  ꥢI/OݡȤμΥХå
 */
#define sio_ierdy_rcv   uart_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
