/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *
 */


/*
 *	ץå˰¸륢ץꥱѻ񸻤BLACKfinѡ
 *
 *  Υ󥯥롼ɥեϡkernel.h  sil.h ǥ󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤ뤳ȤϤʤΥե򥤥
 *  롼ɤˡt_stddef.h  itron.h 󥯥롼ɤΤǡ
 *  ˰¸Ƥ褤
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

#define BLACKFIN			/* ץåά */

/*
 * Core MMR
 */

#define __IMASK	0xFFE02104
#define __IPEND	0xFFE02108
#define __EVT0     0xFFE02000

#define __TCNTL    0xFFE03000
#define __TPERIOD  0xFFE03004


#define __pIMASK ((volatile unsigned long *)__IMASK)
#define __pIPEND ((volatile unsigned long *)__IPEND)
#define __pEVT0 ((volatile void * volatile) __EVT0)

#define __pTCNTL ((volatile unsigned long *)__TCNTL)
#define __pTPERIOD ((volatile unsigned long *)__TPERIOD)
/*
 *  ƥࡦ󥿡ե쥤䡼
 */

/*
 *  ץåΥǥ
 */
#define	SIL_ENDIAN	SIL_ENDIAN_LITTLE	/* ȥ륨ǥ */


/*
* ߥå
*/

#define SIL_PRE_LOC		UINT _intmask_
#define SIL_LOC_INT()	asm volatile ( "cli %0;": "=d"(_intmask_) )
#define SIL_UNL_INT()	asm volatile ( "sti %0;": :"d"(_intmask_) )





#ifndef _MACRO_ONLY

/*
 *  ߡCPU㳰ϥɥֹη
 */
typedef	UINT	INHNO;		/* ߥϥɥֹ */
typedef	UINT	EXCNO;		/* CPU㳰ϥɥֹ */



/*
 *  Ԥ
 *  ƥ¸ SIL_DLY_TIM1SIL_DLY_TIM2Ƥ
 *  SIL_DLY_TIM1sil_dly_nseθƤӽФСإå(nS)
 *  SIL_DLY_TIM2sil_dly_nseΥ롼פĹ(nS)
 */
void sil_dly_nse(UINT dlytim);



/*
 *  ǽɾѥƥλ
 *  cycle󥿤64ӥåȤͤФ
 */
typedef	long long	SYSUTIM;	/* ǽɾѥƥ */

Inline  ER	vxget_tim(SYSUTIM *p_sysutim)
{
	unsigned int lo, hi;

	Asm( "%0=CYCLES; %1=CYCLES2;" :"=d"(lo), "=d"(hi) );
	((unsigned int *)p_sysutim)[0] = lo;
	((unsigned int *)p_sysutim)[1] = hi;
	return(0);
}

/*
* ƥࡦꡦ
*/

#define sil_wrb_iop(iop, data)	sil_wrh_mem( iop, (UB)data )
#define sil_wrh_iop	sil_wrh_mem
#define sil_wrw_iop	sil_wrw_mem
#define sil_wrh_lep sil_wrh_lem
#define sil_wrw_lep sil_wrw_lem
#define sil_wrh_bep sil_wrh_bem
#define sil_wrw_bep sil_wrw_bem

VB sil_reb_iop(VP iop);
VH sil_reh_iop(VP iop);
VW sil_rew_iop(VP iop);
VH sil_reh_lep(VP iop);
VW sil_rew_lep(VP iop);
VH sil_reh_bep(VP iop);
VW sil_rew_bep(VP iop);


#endif /* _MACRO_ONLY */




#endif /* _CPU_DEFS_H_ */
