/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_insn.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	ץåü̿Υ饤ؿM68040ѡ
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

/*
 *  ơ쥸SRˤθͤɽФ
 */
Inline UH
current_sr()
{
	UH	sr;

	Asm("move.w %%sr, %0" : "=g"(sr));
	return(sr);
}

/*
 *  ơ쥸SRˤθͤѹ
 */
Inline void
set_sr(UH sr)
{
	Asm("move.w %0, %%sr" : : "g"(sr));
}

/*
 *  NMI٤Ƥγߤػ
 */
Inline void
disint()
{
	Asm("or.w #0x0700, %sr");
}

/*
 *  ٤Ƥγߤ
 */
Inline void
enaint()
{
	Asm("and.w #~0x0700, %sr");
}

/*
 *  ٥١쥸VBRˤθͤɽФ
 */
Inline VP
current_vbr()
{
	VP	vbr;

	Asm("movec.l %%vbr, %0" : "=r"(vbr));
	return(vbr);
}

/*
 *  ٥١쥸VBRˤ
 */
Inline void
set_vbr(VP vbr)
{
	Asm("movec.l %0, %%vbr" : : "r"(vbr));
}

/*
 *  ǥ塼ΤΥӥåȥޥåץؿ
 *
 *  ӥåȥޥåפβ16ӥåȤѤǲ̥ӥåȤͥ٤б
 *  롥
 */
#define	CPU_BITMAP_SEARCH
#define	PRIMAP_BIT(pri)		(0x8000u >> (pri))

Inline UINT
bitmap_search(UINT bitmap)
{
	UINT	offset;

	/*
	 *  ΥɤϡbitmapUINTˤ32ӥåȤǤ뤳Ȥꤷ
	 *  Ƥ롥
	 */
	Asm("bfffo %1{16,16}, %0" : "=d"(offset) : "g"(bitmap));
	return(offset - 16);
}

#endif /* _CPU_INSN_H_ */
