/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cyclic.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	ϥɥ鵡ǽ
 */

#ifndef _CYCLIC_H_
#define _CYCLIC_H_

#include "queue.h"
#include "time_event.h"

/*
 *  ϥɥ֥å
 */
typedef struct cyclic_handler_initialization_block {
	ATR	cycatr;		/* ϥɥ° */
	VP_INT	exinf;		/* ϥɥγĥ */
	FP	cychdr;		/* ϥɥεư */
	RELTIM	cyctim;		/* ϥɥεư */
	RELTIM	cycphs;		/* ϥɥεư */
} CYCINIB;

/*
 *  ϥɥ֥å
 */
typedef struct cyclic_handler_control_block {
	const CYCINIB *cycinib;	/* ϥɥ֥åؤΥݥ */
	BOOL	cycsta;		/* ϥɥư */
	EVTTIM	evttim;		/* ˼ϥɥư */
	TMEVTB	tmevtb;		/* ।٥ȥ֥å */
} CYCCB;

/*
 *  ϥɥ鵡ǽν
 */
extern void	cyclic_initialize(void);

/*
 *  ϥɥ鵯ưΤΥ।٥ȥ֥åϿ
 */
extern void	tmevtb_enqueue_cyc(CYCCB *cyccb, EVTTIM evttim);

/*
 *  ϥɥ鵯ư롼
 */
extern void	call_cychdr(CYCCB *cyccb);

#endif /* _CYCLIC_H_ */
