/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: time_event.c,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	।٥ȴ⥸塼
 */

#include "jsp_kernel.h"
#include "check.h"
#include "time_event.h"

/*
 *  ।٥ȥҡޥ
 */
#define	PARENT(index)	((index) >> 1)		/* ƥΡɤ */
#define	LCHILD(index)	((index) << 1)		/* λҥΡɤ */
#define	TMEVT_NODE(index)	(tmevt_heap[(index) - 1])

/*
 *  ٥ȯӥޥ
 *
 *  ٥ȯϡcurrent_time ͤӤ롥ʤ
 *  current_time Ǿ͡ʺǤᤤˡcurrent_time - 1 
 *  ʺǤ󤤻ˤȤߤʤӤ롥
 */
#define	EVTTIM_LT(t1, t2) (((t1) - current_time) < ((t2) - current_time))
#define	EVTTIM_LE(t1, t2) (((t1) - current_time) <= ((t2) - current_time))

#ifdef __tmeini

/*
 *  ƥΥեå
 */
SYSTIM	systim_offset;

/*
 *  ߤΥƥñ: ߥá
 *
 *  ̩ˤϡΥƥåΥƥ
 */
SYSTIM	current_time;

/*
 *  ΥƥåΥƥñ: 1ߥá
 */
SYSTIM	next_time;

/*
 *  ƥѻѿñ: 1/TIM_DENOߥá
 */
#if TIC_DENO != 1
UINT	next_subtime;
#endif /* TIC_DENO != 1 */

/*
 *  ।٥ȥҡפκǸλΰΥǥå
 */
UINT	last_index;

/*
 *  ޥ⥸塼ν
 */
void
tmevt_initialize(void)
{
	systim_offset = 0;
	current_time = 0;
#if TIC_DENO == 1
	next_time = current_time + TIC_NUME;
#else /* TIC_DENO == 1 */
	next_subtime += TIC_NUME;
	next_time = current_time + next_subtime / TIC_DENO;
	next_subtime %= TIC_DENO;
#endif /* TIC_DENO == 1 */
	last_index = 0;
}

#endif /* __tmeini */

/*
 *  ।٥Ȥ֤õ
 *
 *   time ȯ륿।٥ȤΡɤ뤿ˡ
 *  ҡפξ˸äƶΡɤư롥ưζΡɤΰ֤ 
 *  index ϤȡưζΡɤΰ֡ʤʤ֡ˤ֤
 */
#ifdef __tmeup

UINT
tmevt_up(UINT index, EVTTIM time)
{
	UINT	parent;

	while (index > 1) {
		/*
		 *  ƥΡɤΥ٥ȯᤤʤޤƱ
		 *  ʤСindex ֤ʤΤǥ롼פȴ롥
		 */
		parent = PARENT(index);
		if (EVTTIM_LE(TMEVT_NODE(parent).time, time)) {
			break;
		}

		/*
		 *  ƥΡɤ index ΰ֤˰ư롥
		 */
		TMEVT_NODE(index) = TMEVT_NODE(parent);
		TMEVT_NODE(index).tmevtb->index = index;

		/*
		 *  index ƥΡɤΰ֤˹
		 */
		index = parent;
	}
	return(index);
}

#endif /* __tmeup */

/*
 *  ।٥Ȥ֤򲼸õ
 *
 *   time ȯ륿।٥ȤΡɤ뤿ˡ
 *  ҡפβ˸äƶΡɤư롥ưζΡɤΰ֤ 
 *  index ϤȡưζΡɤΰ֡ʤʤ֡ˤ֤
 */
#ifdef __tmedown

UINT
tmevt_down(UINT index, EVTTIM time)
{
	UINT	child;

	while ((child = LCHILD(index)) <= last_index) {
		/*
		 *  λҥΡɤΥ٥ȯӤᤤ
		 *  ҥΡɤΰ֤ child ꤹ롥ʲλҥΡ
		 *  ϡФ줿λҥΡɤΤȡ
		 */
		if (child + 1 <= last_index
			&& EVTTIM_LT(TMEVT_NODE(child + 1).time,
				  TMEVT_NODE(child).time)) {
			child = child + 1;
		}

		/*
		 *  ҥΡɤΥ٥ȯ٤ʤޤƱ
		 *  ʤСindex ֤ʤΤǥ롼פȴ롥
		 */
		if (EVTTIM_LE(time, TMEVT_NODE(child).time)) {
			break;
		}

		/*
		 *  ҥΡɤ index ΰ֤˰ư롥
		 */
		TMEVT_NODE(index) = TMEVT_NODE(child);
		TMEVT_NODE(index).tmevtb->index = index;

		/*
		 *  index ҥΡɤΰ֤˹
		 */
		index = child;
	}
	return(index);
}

#endif /* __tmedown */

/*
 * ।٥ȥҡפؤϿ
 *
 *  ।٥ȥ֥å tmevtb time ǻꤷ֤в˥
 *  ٥Ȥȯ褦ˡ।٥ȥҡפϿ롥
 */
#ifdef __tmeins

void
tmevtb_insert(TMEVTB *tmevtb, EVTTIM time)
{
	UINT	index;

	/*
	 *  last_index 򥤥󥯥Ȥ֤õ
	 */
	index = tmevt_up(++last_index, time);

	/*
	 *  ।٥Ȥ index ΰ֤롥
	 */ 
	TMEVT_NODE(index).time = time;
	TMEVT_NODE(index).tmevtb = tmevtb;
	tmevtb->index = index;
}

#endif /* __tmeins */

/*
 *  ।٥ȥҡפκ
 */
#ifdef __tmedel

void
tmevtb_delete(TMEVTB *tmevtb)
{
	UINT	index = tmevtb->index;
	UINT	parent;
	EVTTIM	event_time = TMEVT_NODE(last_index).time;

	/*
	 *  ˤ꥿।٥ȥҡפˤʤϲ⤷ʤ
	 */
	if (--last_index == 0) {
		return;
	}

	/*
	 *  Ρɤΰ֤˺ǸΥΡɡlast_index + 1 ΰ
	 *  ΥΡɡˤŬڤʰ֤ذư롥ºݤˤϡ
	 *  ǸΥΡɤºݤΤǤϤʤΡɤΰ
	 *  ֤ΡɤˤʤΤǡǸΥΡɤ٤֤ظ
	 *  ƶΡɤư롥
	 *  ǸΥΡɤΥ٥ȯ郎ΡɤοƥΡ
	 *  Υ٥ȯξˤϡ˸ä֤
	 *  õǤʤˤϡ˸äõ
	 */
	if (index > 1 && EVTTIM_LT(event_time,
				TMEVT_NODE(parent = PARENT(index)).time)) {
		/*
		 *  ƥΡɤ index ΰ֤˰ư롥
		 */
		TMEVT_NODE(index) = TMEVT_NODE(parent);
		TMEVT_NODE(index).tmevtb->index = index;

		/*
		 *  ΡɤοƥΡɤ˸ä֤
		 *  õ
		 */
		index = tmevt_up(parent, event_time);
	}
	else {
		/*
		 *  Ρɤ鲼˸ä֤õ
		 */
		index = tmevt_down(index, event_time);
	}

	/*
	 *  ǸΥΡɤ index ΰ֤롥
	 */ 
	TMEVT_NODE(index) = TMEVT_NODE(last_index + 1);
	TMEVT_NODE(index).tmevtb->index = index;
}

#endif /* __tmedel */

/*
 *  ।٥ȥҡפƬΥΡɤκ
 */
Inline void
tmevtb_delete_top(void)
{
	UINT	index;
	EVTTIM	event_time = TMEVT_NODE(last_index).time;

	/*
	 *  ˤ꥿।٥ȥҡפˤʤϲ⤷ʤ
	 */
	if (--last_index == 0) {
		return;
	}

	/*
	 *  롼ȥΡɤ˺ǸΥΡɡlast_index + 1 ΰ֤ΥΡɡ
	 *  Ŭڤʰ֤ذư롥ºݤˤϡǸΥΡ
	 *  ɤºݤΤǤϤʤ롼ȥΡɤΡɤˤʤ
	 *  ΤǡǸΥΡɤ٤֤ظƶΡɤư
	 *  롥
	 */
	index = tmevt_down(1, event_time);

	/*
	 *  ǸΥΡɤ index ΰ֤롥
	 */ 
	TMEVT_NODE(index) = TMEVT_NODE(last_index + 1);
	TMEVT_NODE(index).tmevtb->index = index;
}

/*
 *  ƥåζ
 *
 *  TIC_NUME < TIC_DENO λϡȤ鷺˻ιǤ뤬
 *  ɤɤߤ䤹ˤ뤿 #if ¿Ѥ򤱤Ƥ롥
 */
#ifdef __isig_tim

SYSCALL ER
isig_tim(void)
{
	TMEVTB	*tmevtb;
	ER	ercd;

	LOG_ISIG_TIM_ENTER();
	CHECK_INTCTX_UNL();
	i_lock_cpu();

	/*
	 *  next_time ꥤ٥ȯᤤʤޤƱ˥।
	 *  ٥Ȥ򡤥।٥ȥҡפХåؿ
	 *  ƤӽФ
	 */
	while (last_index > 0 && EVTTIM_LE(TMEVT_NODE(1).time, next_time)) {
		tmevtb = TMEVT_NODE(1).tmevtb;
		tmevtb_delete_top();
		(*(tmevtb->callback))(tmevtb->arg);

		/*
		 *  ͥ٤ι⤤ߤդ롥
		 */
		i_unlock_cpu();
		i_lock_cpu();
	}

	/*
	 *  current_time 򹹿롥
	 */
	current_time = next_time;

	/*
	 *  next_timenext_subtime 򹹿롥
	 */
#if TIC_DENO == 1
	next_time = current_time + TIC_NUME;
#else /* TIC_DENO == 1 */
	next_subtime += TIC_NUME % TIC_DENO;
	next_time = current_time + TIC_NUME / TIC_DENO;
	if (next_subtime >= TIC_DENO) {
		next_subtime -= TIC_DENO;
		next_time += 1u;
	}
#endif /* TIC_DENO == 1 */

	ercd = E_OK;
	i_unlock_cpu();

    exit:
	LOG_ISIG_TIM_LEAVE(ercd);
	return(ercd);
}

#endif /* __isig_tim */
