#include "t_services.h"
#include "s_services.h"
#include <cdefBF533.h>
#include "ad1836a.h"



#define pFLASHA_PORTA_OUT ((volatile unsigned char * )0x20270004)
#define pFLASHA_PORTA_DIR ((volatile unsigned char * )0x20270006)


struct DMA_DESCRIPTOR{
	struct DMA_DESCRIPTOR * next;
	void * start;
	unsigned short config;
	unsigned short x_count;
	short x_modify;
};


// CODEC ǡ
static short sCodec1836TxRegs[] =
{									
					DAC_CONTROL_1	| 0x000,
					DAC_CONTROL_2	| 0x000,
					DAC_VOLUME_0	| 0x3ff,
					DAC_VOLUME_1	| 0x3ff,
					DAC_VOLUME_2	| 0x3ff,
					DAC_VOLUME_3	| 0x3ff,
					DAC_VOLUME_4	| 0x3ff,
					DAC_VOLUME_5	| 0x3ff,
					ADC_CONTROL_1	| 0x000,
					ADC_CONTROL_2	| 0x180,
					ADC_CONTROL_3	| 0x000
					
};

// ǥХåե
// 1ץ뤢8ǡž롣֥ХåեʤΤǤˤ2ɬ
static struct CODEC_BUFFER TxBuffer[2], RxBuffer[2];

static struct DMA_DESCRIPTOR tDescA, tDescB, rDescA, rDescB;

void run_ad1836_task(VP_INT extinf)
{
	ena_int( INTNO_SPI ); 			// SPI DMAߥޥϤ 
	ena_int( INTNO_SPORT0_RX );		// SPORT0 DMAߥޥϤ 

//--------------------------------------------------------
// 			AD1836Υꥻå 
//
    *pFLASHA_PORTA_DIR |= 0x01;   	// CODEC ꥻåȿϤ	
    *pFLASHA_PORTA_OUT &= 0xFE;   	// CODEC ꥻåȤ򥢥	
	tslp_tsk( 1 );					// ꥻå=Lѥ륹 
    *pFLASHA_PORTA_OUT |= 0x01;    	// CODEC ꥻåȤǥ 
	tslp_tsk( 1 );					// ꥻåȤβ֤Ϳ 

//--------------------------------------------------------
//			SPI 
// 	
	// PF4AD1836SPI SSԥ 
	*pSPI_FLG = FLS4;
	// SPIӥåȥ졼 = SCLK/(2*SPIBAUD) :褽 2MHz	
	*pSPI_BAUD = 32;
	// SPI DMA 񤭹ߤˤȥꥬ, 16bit ǡ, MSB first, ޥ
	*pSPI_CTL = TIMOD | SIZE | MSTR;

	
	
//--------------------------------------------------------
//			 SPI DMA  
//
	// 16bit ǡ꤫ɤ߽Фλ
	*pDMA5_CONFIG = WDSIZE_16 | DI_EN;
	// CODEC ʸΥɥ쥹 
	*pDMA5_START_ADDR = sCodec1836TxRegs;
	// DMA ž 
	*pDMA5_X_COUNT = sizeof( sCodec1836TxRegs ) / sizeof( short );
	// DMA ʬ 
	*pDMA5_X_MODIFY = sizeof( short );
	

//--------------------------------------------------------
//			 SPI 
	// DMA  
	*pDMA5_CONFIG |= DMAEN;
	// SPI  
	*pSPI_CTL |= SPE;

	
	// DMAнλԤ 
	wai_sem( spi_sem );
	// DMAλSPIλǤϤʤΤǡäԤ 
	tslp_tsk( 1 );

//--------------------------------------------------------
//		SPORT0  
//			ޥͥξ硢 SPORTx_yCR1.LATFS = 0
	// Sport0  
	// å, Ʊ, MSBե 
	// 32-bit ǡ 
	*pSPORT0_RCR1 = RFSR;
	*pSPORT0_RCR2 = 31;		// ǡĹ 32
	
	// Sport0 
	// å, Ʊ, MSBե 
	// 32ӥåȥǡ 
	*pSPORT0_TCR1 = TFSR;
	*pSPORT0_TCR2 = 31;		// ǡĹ 32 
	
	// ե졼ढ8åȤΥǡǻȤ 
	*pSPORT0_MTCS0 = 0x000000FF;
	*pSPORT0_MRCS0 = 0x000000FF;
	
	// ޥͥ
	*pSPORT0_MCMC1 = 0x0000; // եå = 0, ɥ = 8
	*pSPORT0_MCMC2 = 0x1000 | MCMEN | MCDRXPE | MCDTXPE; // MFD = 1;

//--------------------------------------------------------
// 			SPORT DMA  
//
	// DMA1 (SPORT0 RX)
	rDescA.next = &rDescB;
	rDescA.start = RxBuffer[0].data;
	rDescA.config = 0x7700 | WNR | WDSIZE_32 | DI_EN | DMAEN;	// Large List, 7 short word.
	rDescA.x_count = 8 * SAMPLE_PER_INTR;
	rDescA.x_modify = 4;
	
	rDescB.next = &rDescA;
	rDescB.start = RxBuffer[1].data;
	rDescB.config = 0x7700 | WNR | WDSIZE_32 | DI_EN | DMAEN;	// Large List, 7 short word.
	rDescB.x_count = 8 * SAMPLE_PER_INTR;
	rDescB.x_modify = 4;
	
	
	// DMA2 (SPORT0 TX)
	tDescA.next = &tDescB;
	tDescA.start = TxBuffer[0].data;
	tDescA.config = 0x7700 | WDSIZE_32 | DMAEN;	// Large List, 7 short word.
	tDescA.x_count = 8 * SAMPLE_PER_INTR;
	tDescA.x_modify = 4;
	
	tDescB.next = &tDescA;
	tDescB.start = TxBuffer[1].data;
	tDescB.config = 0x7700 | WDSIZE_32 | DMAEN;	// Large List, 7 short word.
	tDescB.x_count = 8 * SAMPLE_PER_INTR;
	tDescB.x_modify = 4;


	*pDMA2_NEXT_DESC_PTR = &tDescA;
	*pDMA1_NEXT_DESC_PTR = &rDescA;
	*pDMA2_CONFIG = 0x7700 | WDSIZE_32;
	*pDMA1_CONFIG = 0x7700 | WNR | WDSIZE_32;
	
	
//--------------------------------------------------------
//			 SPORT0 
	// DMA  
	*pDMA2_CONFIG |= DMAEN;
	*pDMA1_CONFIG |= DMAEN;
	asm("ssync;");
	// SPORT2  
	*pSPORT0_TCR1 |= TSPEN;
	*pSPORT0_RCR1 |= RSPEN;

//

	while( 1 ){
		int sample, slot, bufTx, bufRx;
		struct CODEC_BUFFER * BufToBeTransmit; 
	
				// DMAλߤƱ
		wai_sem( sport0_sem);
	
				// ץåȤäƤ褤ХåեФ	
		bufTx = ( &tDescA == *pDMA2_NEXT_DESC_PTR) ? 0 : 1;
		bufRx = ( &rDescA == *pDMA1_NEXT_DESC_PTR) ? 0 : 1;
				
		
		processData(&RxBuffer[bufRx], &TxBuffer[bufTx]);
				
	}

}

