/*
 *  @(#) $Id: lpc2388.ld,v 1.1 2009/09/21 04:24:44 suikan Exp $
 */

OUTPUT_FORMAT("elf32-littlearm", "elf32-bigarm","elf32-littlearm") 
OUTPUT_ARCH(arm)

PROVIDE(hardware_init_hook = 0);
PROVIDE(software_init_hook = 0);
PROVIDE(software_term_hook = 0);

MEMORY
  {
    MEM_FLASH (X!W)	  : ORIGIN = 0x00000000, LENGTH = 512K
    MEM_SRAM (XW)     : ORIGIN = 0x40000040, LENGTH = 0xFFC0
    MEM_USBSRAM (XW)  : ORIGIN = 0x7FD00000, LENGTH = 16K
    MEM_ETHERSRAM (XW): ORIGIN = 0x7FE00000, LENGTH = 16K
    MEM_EXTSRAM_0 (XW): ORIGIN = 0x80000000, LENGTH = 64K
    MEM_EXTSRAM_1 (XW): ORIGIN = 0x81000000, LENGTH = 64K
  }


SECTIONS
{
    .text :
    {
        __text = . ; 	
        start.o(.vector)
	    start.o(.text)
        *(.text)
        *(.glue_7t)
        *(.glue_7)
    } > MEM_FLASH
    
    _etext = .	;
    PROVIDE (etext = .)	;
    .rodata : { 
		*(.rodata) 
		*(.rodata.str1.4) 
	} > MEM_FLASH

    . = ALIGN(4);
    __idata_start = . ;
    .data   :  AT(__idata_start) 
    {
        __data_start = . ;
        *(.data)
    } > MEM_SRAM
    
    __idata_end = __idata_start + SIZEOF(.data);
    _edata  =  . ;
    PROVIDE (edata = .);
    . = ALIGN(4);
    __bss_start = .	;		
    .bss       :
    {
      *(.bss)
      *(COMMON)
   . = ALIGN(32 / 8);
    } > MEM_SRAM

   . = ALIGN(32 / 8);
     _end = .		;
    __bss_end = __bss_start + SIZEOF(.bss);
    PROVIDE (end = .)	;

}	

	
		
	