/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: FactOrRule.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_FACT_OR_RULE_HPP_
#define _TOPS_FACT_OR_RULE_HPP_

#include "tops/common/Printable.hpp"

#include <boost/shared_ptr.hpp>

namespace tops {

	class Fact;
	typedef boost::shared_ptr<Fact> FactPtr;
	class Rule;
	typedef boost::shared_ptr<Rule> RulePtr;

	/**
	 * [łB
	 * ̃NX́Ap[T̏o͂bsO܂B
	 *
	 * @author gDC[
	 */
	class FactOrRule : public Printable {
	private:
		typedef enum {
		    SMALLOPS_UNKNOWN = -1,
		    SMALLOPS_FACT,
		    SMALLOPS_RULE,
		} SMALLOPS_ELEMENT;

		SMALLOPS_ELEMENT m_type;
		FactPtr m_fact;
		RulePtr m_rule;

	public:
		/**
		 * ftHgRXgN^łB
		 */
		FactOrRule();

		/**
		 * \z܂B
		 */
		FactOrRule(const FactPtr& fact);

		/**
		 * [\z܂B
		 */
		FactOrRule(const RulePtr& rule);

	public:
		/**
		 * ǂ𔻒肵܂B
		 */
		bool isFact() const {
			return m_type == SMALLOPS_FACT;
		}

		/**
		 * 擾܂B
		 */
		FactPtr getFact() const {
			return (isFact()) ? m_fact : FactPtr();
		}

		/**
		 * v_NV[ǂ𔻒肵܂B
		 */
		bool isRule() const {
			return m_type == SMALLOPS_RULE;
		}

		/**
		 * v_NVK擾܂B
		 */
		RulePtr getRule() const {
			return (isRule()) ? m_rule : RulePtr();
		}

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

}  // namespace tops

#endif
