/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: Instance.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_INSTANCE_HPP_
#define _TOPS_INSTANCE_HPP_

#include "tops/common/Printable.hpp"

#include <string>

#include <boost/noncopyable.hpp>
#include <boost/shared_ptr.hpp>

namespace tops {

	class ProductionRule;
	class ProductionSystem;
	class UnificatedElements;
	class UnificationState;
	typedef boost::shared_ptr<UnificationState> UnificationStatePtr;
	class WMElement;

	class Instance;
	typedef boost::shared_ptr<Instance> InstancePtr;

	/**
	 * Pꉻ邱Ƃɂ萶ꂽCX^XłB
	 *
	 * @author gDC[
	 */
	class Instance : public boost::noncopyable, public Printable {
	private:
		ProductionRule& m_sourceRule;
		UnificationStatePtr m_state;

	public:
		/**
		 * CX^X\z܂B
		 */
		Instance(ProductionRule& sourceRule, const UnificationStatePtr& state);

	public:
		/**
		 * CX^XƂȂv_NV[擾܂B
		 */
		ProductionRule& getSourceProductionRule() const {
			return m_sourceRule;
		}

		/**
		 * CX^XƂȂ郏[LOvf擾܂B
		 */
		const UnificatedElements& getSourceElements() const;

		/**
		 * CX^XƂȂ郏[LOvf擾܂B
		 */
		WMElement* operator[](const std::string& label) const;

		/**
		 * TCY擾܂B
		 */
		size_t size() const;

		/**
		 * CX^XƂȂ郏[LOvf擾܂B
		 */
		WMElement* operator[](size_t i) const;

	public:
		/**
		 * 𔭉΂܂B
		 *
		 * @param system ΏۂƂȂv_NVVXew肵܂B
		 *
		 * @return 삪ꍇtrueAsꍇfalseԂ܂B
		 */
		bool fire(ProductionSystem& system);

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

}  // namespace tops

#endif
