/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: ProductionRule.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_PRODUCTION_RULE_HPP_
#define _TOPS_PRODUCTION_RULE_HPP_

#include "tops/ActionPart.hpp"
#include "tops/ConditionPart.hpp"

#include "tops/common/Printable.hpp"

#include <list>
#include <set>
#include <string>

#include <boost/noncopyable.hpp>
#include <boost/shared_ptr.hpp>

namespace tops {

	class ProductionRule;
	typedef boost::shared_ptr<ProductionRule> ProductionRulePtr;

	/**
	 * v_NV[łB
	 *
	 * @author gDC[
	 */
	class ProductionRule : public boost::noncopyable, public Printable {
		friend class RuleBase;

	private:
		typedef std::set<std::string> NameSet;
		typedef std::list<ProductionRulePtr> Container;

		typedef NameSet::iterator nameIterator;
		typedef NameSet::const_iterator const_nameIterator;

		typedef Container::iterator iterator;
		typedef Container::const_iterator const_iterator;

	private:
		RuleBase* m_owner;
		nameIterator m_selfNameIterator;
		iterator m_selfIterator;

	private:
		std::string m_name;
		ConditionPart m_lhs;
		ActionPart m_rhs;

	private:
		/**
		 * v_NV[\z܂B
		 *
		 * @param name Kw肵܂B
		 * @param lhs w肵܂B
		 * @param rhs sw肵܂B
		 */
		ProductionRule(const std::string& name, const ConditionPart& lhs, const ActionPart& rhs);

	public:
		/**
		 * v_NV[j܂B
		 */
		~ProductionRule();

	private:
		/**
		 * @see RuleBase
		 */
		void setOwner(RuleBase& owner, nameIterator selfNameIterator, iterator selfIterator);

	public:
		/**
		 * O擾܂B
		 */
		const std::string& getName() const {
			return m_name;
		}

		/**
		 * 擾܂B
		 */
		ConditionPart& getConditionPart() {
			return m_lhs;
		}

		/**
		 * Ή\s擾܂B
		 *
		 * @param variables ̉Ɏgpϐ\w肵܂B
		 */
		FireableActions getFireableActions(const Variables& variables);

	public:
		/**
		 * lfs܂B
		 *
		 * @param rule lfΏۂƂȂv_NV[w肵܂B
		 * @return lȂtrueAȂȂfalseԂ܂B
		 */
		bool equals(const ProductionRule& rule) const;

	public:
		/**
		 * [x[X܂B
		 */
		void release();

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

}  // namespace tops

#endif
