/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: RuleBase.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_RULE_BASE_HPP_
#define _TOPS_RULE_BASE_HPP_

#include "tops/common/Printable.hpp"

#include "tops/utilities/Iterator/SharedToPointerIterator.hpp"

#include <list>
#include <set>

#include <boost/noncopyable.hpp>
#include <boost/shared_ptr.hpp>

namespace tops {

	class ProductionRule;
	typedef boost::shared_ptr<ProductionRule> ProductionRulePtr;
	class Rule;
	typedef boost::shared_ptr<Rule> RulePtr;

	/**
	 * [x[XłB
	 *
	 * @author gDC[
	 */
	class RuleBase : public boost::noncopyable, public Printable {
		friend class ProductionRule;

	private:
		typedef std::set<std::string> NameSet;
		typedef std::list<ProductionRulePtr> Container;

		typedef NameSet::iterator nameIterator;
		typedef NameSet::const_iterator const_nameIterator;

		typedef Container::iterator InnerIterator;
		typedef Container::const_iterator ConstInnerIterator;

	public:
		typedef Utility::SharedToPointerIterator<InnerIterator, ProductionRule> iterator;
		typedef Utility::ConstSharedToPointerIterator<ConstInnerIterator, ProductionRule> const_iterator;

	private:
		/**
		 * v_NV[̖OłB
		 */
		NameSet m_names;

		/**
		 * v_NV[łB
		 */
		Container m_rules;

	public:
		/**
		 * [x[Xj܂B
		 */
		~RuleBase();

	private:
		ProductionRule* createProductionRule(const RulePtr& rule, nameIterator selfNameIterator);
		void removeProductionRule(nameIterator selfNameIterator, InnerIterator selfIterator);

	public:
		/**
		 * 󂩂ǂ𔻒f܂B
		 *
		 * @return 󂾂trueA󂶂ȂfalseԂ܂B
		 */
		bool empty() const;

		/**
		 * TCY擾܂B
		 */
		size_t size() const;

		/**
		 * [ǉ܂B
		 */
		ProductionRule* add(const RulePtr& rule);

		iterator begin() {
			return m_rules.begin();
		}

		const_iterator begin() const {
			return m_rules.begin();
		}

		iterator end() {
			return m_rules.end();
		}

		const_iterator end() const {
			return m_rules.end();
		}

	public:
		/**
		 * SẴv_NV[폜܂B
		 */
		void clear();

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

}  // namespace tops

#endif
