/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: UnificationState.hpp 11 2011-05-14 02:11:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _TOPS_UNIFICATION_STATE_HPP_
#define _TOPS_UNIFICATION_STATE_HPP_

#include "tops/UnificatedElements.hpp"

#include "tops/common/Printable.hpp"
#include "tops/value/Variables.hpp"

#include <boost/shared_ptr.hpp>

namespace tops {

	class WMElement;

	class UnificationState;
	typedef boost::shared_ptr<UnificationState> UnificationStatePtr;

	/**
	 * PꉻԂłB
	 *
	 * @author gDC[
	 */
	class UnificationState : public Printable {
	private:
		UnificatedElements m_sources;
		Variables m_variables;

	public:
		UnificationState(const UnificatedElements& sources, const Variables& variables) :
		m_sources(sources), m_variables(variables) {
		}

	public:
		/**
		 * TCY擾܂B
		 */
		size_t size() const {
			return m_sources.size();
		}

		/**
		 *
		 */
		const UnificatedElements& getSource() const {
			return m_sources;
		}

		/**
		 * PꉻƂȂ郏[LOvf擾܂B
		 */
		WMElement* operator[](size_t i) const;

		/**
		 * PꉻɎgpϐ\擾܂B
		 */
		const Variables& getVariables() const {
			return m_variables;
		}

	public:
		/**
		 * Xg[ɏo͂܂B
		 */
		void print(std::ostream& stream) const;
	};

}  // namespace tops

#endif
